/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.codesystems;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.util.DelegatingSelectionProvider;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.FavoritenCTabItem;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.core.ui.views.codesystems.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class LeistungenView
extends ViewPart
implements IActivationListener,
ISaveablePart2 {
    private static final String CAPTION_ERROR = Messages.LeistungenView_error;
    public static final String ID = "ch.elexis.LeistungenView";
    public CTabFolder ctab;
    CTabItem selected;
    private String defaultRGB = UiDesk.createColor(new RGB(255, 255, 255));
    private DelegatingSelectionProvider delegatingSelectionProvider;

    public void createPartControl(Composite parent) {
        this.delegatingSelectionProvider = new DelegatingSelectionProvider();
        parent.setLayout((Layout)new GridLayout());
        this.ctab = new CTabFolder(parent, 1024);
        this.ctab.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.ctab.setSimple(false);
        this.ctab.setMRUVisible(true);
        this.ctab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LeistungenView.this.selected = LeistungenView.this.ctab.getSelection();
                if (LeistungenView.this.selected instanceof FavoritenCTabItem) {
                    return;
                }
                if (LeistungenView.this.selected != null) {
                    CodeSelectorFactory codeSelectorFactory = (CodeSelectorFactory)LeistungenView.this.selected.getData("csf");
                    CodeSelectorFactory.cPage page = (CodeSelectorFactory.cPage)LeistungenView.this.selected.getControl();
                    if (page == null) {
                        page = new CodeSelectorFactory.cPage(LeistungenView.this.ctab, (ICodeElement)LeistungenView.this.selected.getData(), codeSelectorFactory);
                        LeistungenView.this.selected.setControl((Control)page);
                    }
                    page.cv.getConfigurer().getControlFieldProvider().clearValues();
                    if (codeSelectorFactory != null && codeSelectorFactory.hasContextMenu()) {
                        codeSelectorFactory.activateContextMenu(LeistungenView.this.getSite(), LeistungenView.this.delegatingSelectionProvider, LeistungenView.ID);
                    }
                }
                ((CodeSelectorFactory.cPage)LeistungenView.this.selected.getControl()).refresh();
                LeistungenView.this.setFocus();
            }
        });
        Menu tabFolderMenu = new Menu((Control)this.ctab);
        MenuItem miColor = new MenuItem(tabFolderMenu, 8);
        miColor.setText(Messages.LeistungenView_defineColor);
        miColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem item = LeistungenView.this.ctab.getSelection();
                ColorDialog cd = new ColorDialog(UiDesk.getTopShell());
                RGB selected = cd.open();
                if (selected != null) {
                    CoreHub.globalCfg.set("billing/color/" + item.getText(), UiDesk.createColor(selected));
                    LeistungenView.this.setCTabItemColor(LeistungenView.this.ctab.getSelection().getText());
                }
            }
        });
        this.ctab.setMenu(tabFolderMenu);
        CodeSelectorFactory.makeTabs(this.ctab, this.getViewSite(), "ch.elexis.core.ui.Verrechnungscode");
        GlobalEventDispatcher.addActivationListener(this, (IWorkbenchPart)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.delegatingSelectionProvider);
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener(this, (IWorkbenchPart)this);
        super.dispose();
    }

    public void setFocus() {
        if (this.selected == null && this.ctab.getItems().length > 0) {
            this.selected = this.ctab.getSelection();
        }
        if (this.selected instanceof FavoritenCTabItem) {
            ((FavoritenCTabItem)this.selected).update();
            return;
        }
        if (this.selected != null) {
            CodeSelectorFactory.cPage page = (CodeSelectorFactory.cPage)this.selected.getControl();
            if (page == null) {
                page = new CodeSelectorFactory.cPage(this.ctab, (ICodeElement)this.selected.getData(), (CodeSelectorFactory)this.selected.getData("csf"));
                this.selected.setControl((Control)page);
            }
            page.cv.getConfigurer().getControlFieldProvider().setFocus();
        }
        this.setCTabItemColor(this.selected.getText());
    }

    private void setCTabItemColor(String id) {
        String rgbColor = CoreHub.globalCfg.get("billing/color/" + id, this.defaultRGB);
        Color color = UiDesk.getColorFromRGB(rgbColor);
        this.ctab.setSelectionBackground(new Color[]{UiDesk.getDisplay().getSystemColor(1), color}, new int[]{100}, true);
    }

    void swapTabs(int iLeft, int iRight) {
        CTabItem ctLeft = this.ctab.getItem(iLeft);
        CTabItem ctRight = this.ctab.getItem(iRight);
        String t = ctLeft.getText();
        Control c = ctLeft.getControl();
        ctLeft.setText(ctRight.getText());
        ctLeft.setControl(ctRight.getControl());
        ctRight.setText(t);
        ctRight.setControl(c);
    }

    @Override
    public void activation(boolean mode) {
        if (this.selected instanceof FavoritenCTabItem) {
            return;
        }
        if (!mode) {
            if (this.selected != null) {
                CodeSelectorFactory.cPage page = (CodeSelectorFactory.cPage)this.selected.getControl();
                page.cv.getConfigurer().getControlFieldProvider().clearValues();
            }
            CodeSelectorHandler.getInstance().removeCodeSelectorTarget();
        } else if (this.selected != null) {
            CodeSelectorFactory.cPage page = (CodeSelectorFactory.cPage)this.selected.getControl();
            page.refresh();
        }
    }

    @Override
    public void visible(boolean mode) {
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void setSelected(CTabItem ctab) {
        this.selected = ctab;
    }
}

