/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.codesystems;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.util.DelegatingSelectionProvider;
import ch.elexis.core.ui.util.PersistentObjectDragSource;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.FavoritenCTabItem;
import ch.elexis.core.ui.views.IDetailDisplay;
import ch.elexis.core.ui.views.codesystems.ContributionAction;
import ch.elexis.core.ui.views.codesystems.Messages;
import ch.elexis.data.Anwender;
import ch.elexis.data.Leistungsblock;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.PersistentObjectFactory;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CodeSelectorFactory
implements IExecutableExtension {
    private static final String CAPTION_ERROR = Messages.CodeSelectorFactory_error;
    public static int ITEMS_TO_SHOW_IN_MFU_LIST = 15;
    private static Logger log = LoggerFactory.getLogger(CodeSelectorFactory.class);

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public abstract ViewerConfigurer createViewerConfigurer(CommonViewer var1);

    public abstract Class<? extends PersistentObject> getElementClass();

    public abstract void dispose();

    public abstract String getCodeSystemName();

    public String getCodeSystemCode() {
        return "999";
    }

    protected void addPopupCommandContributions(IMenuManager manager, Object[] selection) {
        List contributions = Extensions.getExtensions((String)"org.eclipse.ui.menus");
        for (IConfigurationElement contributionElement : contributions) {
            IConfigurationElement[] command;
            String locationUri = contributionElement.getAttribute("locationURI");
            String[] parts = locationUri.split(":");
            if (parts.length != 2 || !parts[0].equals("popup") || !parts[1].equals(this.getClass().getName()) || (command = contributionElement.getChildren("command")).length <= 0) continue;
            this.addMenuContribution(command[0], manager, selection);
        }
    }

    protected void addMenuContribution(IConfigurationElement commandElement, IMenuManager manager, Object[] selection) {
        ContributionAction action = new ContributionAction(commandElement);
        if (action.isValid()) {
            action.setSelection(selection);
            manager.add((IAction)action);
        }
    }

    public PersistentObject findElement(String code) {
        String s = String.valueOf(this.getElementClass().getName()) + "::" + code;
        return CoreHub.poFactory.createFromString(s);
    }

    public SelectionDialog getSelectionDialog(Shell parent, Object data) {
        throw new UnsupportedOperationException("SelectionDialog for code system " + this.getCodeSystemName() + " not implemented");
    }

    public static SelectionDialog getSelectionDialog(String codeSystemName, Shell parent, Object data) {
        List list = Extensions.getExtensions((String)"ch.elexis.core.ui.Genericcode");
        list.addAll(Extensions.getExtensions((String)"ch.elexis.core.ui.Verrechnungscode"));
        list.addAll(Extensions.getExtensions((String)"ch.elexis.core.ui.Diagnosecode"));
        if (list != null) {
            for (IConfigurationElement ic : list) {
                try {
                    PersistentObjectFactory po = (PersistentObjectFactory)ic.createExecutableExtension("ElementFactory");
                    CodeSelectorFactory codeSelectorFactory = (CodeSelectorFactory)ic.createExecutableExtension("CodeSelectorFactory");
                    if (codeSelectorFactory == null) {
                        String error = "CodeSelectorFactory is null: " + ic.getClass().getName();
                        SWTHelper.alert(CAPTION_ERROR, error);
                        log.error(error);
                        continue;
                    }
                    ICodeElement codeElement = (ICodeElement)po.createTemplate(codeSelectorFactory.getElementClass());
                    if (codeElement == null) {
                        String error = "CodeElement is null: " + po.getClass().getName();
                        SWTHelper.alert(CAPTION_ERROR, error);
                        log.error(error);
                        continue;
                    }
                    if (!codeSystemName.equals(codeElement.getCodeSystemName())) continue;
                    return codeSelectorFactory.getSelectionDialog(parent, data);
                }
                catch (CoreException ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        }
        throw new IllegalStateException("Could not find code system " + codeSystemName);
    }

    public static void makeTabs(CTabFolder ctab, IViewSite site, String point) {
        String settings = null;
        if (point.equals("ch.elexis.core.ui.Verrechnungscode")) {
            settings = CoreHub.userCfg.get("servicediagnose/srv", null);
        } else if (point.equals("ch.elexis.core.ui.Diagnosecode")) {
            settings = CoreHub.userCfg.get("servicediagnose/diagnose", null);
        }
        List list = Extensions.getExtensions((String)point);
        if (settings == null) {
            CodeSelectorFactory.addAllTabs(list, ctab, point);
        } else {
            CodeSelectorFactory.addUserSpecifiedTabs(list, settings, ctab, point);
        }
        if (ctab.getItemCount() > 0) {
            ctab.setSelection(0);
        }
    }

    private static void addAllTabs(List<IConfigurationElement> list, CTabFolder ctab, String point) {
        ITEMS_TO_SHOW_IN_MFU_LIST = CoreHub.userCfg.get("mfulist/size", 15);
        ctab.setSimple(false);
        if (point.equals("ch.elexis.core.ui.Verrechnungscode")) {
            new FavoritenCTabItem(ctab, 0);
        }
        if (list != null) {
            for (IConfigurationElement ic : list) {
                try {
                    PersistentObjectFactory po = (PersistentObjectFactory)ic.createExecutableExtension("ElementFactory");
                    CodeSelectorFactory codeSelectorFactory = (CodeSelectorFactory)ic.createExecutableExtension("CodeSelectorFactory");
                    if (codeSelectorFactory == null) {
                        String error = "CodeSelectorFactory is null: " + ic.getClass().getName();
                        SWTHelper.alert(CAPTION_ERROR, error);
                        log.error(error);
                        continue;
                    }
                    ICodeElement codeElement = (ICodeElement)po.createTemplate(codeSelectorFactory.getElementClass());
                    if (codeElement == null) {
                        String message = "null code element for " + codeSelectorFactory.getElementClass() + " in " + po.getClass();
                        SWTHelper.alert(CAPTION_ERROR, message);
                        log.error(message);
                        continue;
                    }
                    String codeSystemName = codeElement.getCodeSystemName();
                    if (StringTool.isNothing((Object)codeSystemName)) {
                        SWTHelper.alert(CAPTION_ERROR, "codesystemname");
                        codeSystemName = "??";
                    }
                    CTabItem tabItem = new CTabItem(ctab, 0);
                    tabItem.setText(codeSystemName);
                    tabItem.setData((Object)codeElement);
                    tabItem.setData("csf", (Object)codeSelectorFactory);
                }
                catch (CoreException ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        }
    }

    private static void addUserSpecifiedTabs(List<IConfigurationElement> list, String settings, CTabFolder ctab, String point) {
        String[] userSettings;
        HashMap<String, IConfigurationElement> allIcMap = new HashMap<String, IConfigurationElement>();
        for (IConfigurationElement ic : list) {
            try {
                IDetailDisplay d = (IDetailDisplay)ic.createExecutableExtension("CodeDetailDisplay");
                allIcMap.put(d.getTitle(), ic);
            }
            catch (Exception e) {
                ExHandler.handle((Throwable)e);
            }
        }
        String[] stringArray = userSettings = settings.split(",");
        int n = userSettings.length;
        int n2 = 0;
        while (n2 < n) {
            String tab = stringArray[n2];
            if ("Favoriten".equals(tab)) {
                if (point.equals("ch.elexis.core.ui.Verrechnungscode")) {
                    new FavoritenCTabItem(ctab, 0);
                }
            } else {
                try {
                    IConfigurationElement ic = (IConfigurationElement)allIcMap.get(tab);
                    if (ic != null) {
                        PersistentObjectFactory po = (PersistentObjectFactory)ic.createExecutableExtension("ElementFactory");
                        CodeSelectorFactory codeSelectorFactory = (CodeSelectorFactory)ic.createExecutableExtension("CodeSelectorFactory");
                        if (codeSelectorFactory == null) {
                            String error = "CodeSelectorFactory is null: " + ic.getClass().getName();
                            SWTHelper.alert(CAPTION_ERROR, error);
                            log.error(error);
                        } else {
                            ICodeElement codeElement = (ICodeElement)po.createTemplate(codeSelectorFactory.getElementClass());
                            if (codeElement == null) {
                                String message = "null code element for " + codeSelectorFactory.getElementClass() + " in " + po.getClass();
                                SWTHelper.alert(CAPTION_ERROR, message);
                                log.error(message);
                            } else {
                                String codeSystemName = codeElement.getCodeSystemName();
                                if (StringTool.isNothing((Object)codeSystemName)) {
                                    SWTHelper.alert(CAPTION_ERROR, "codesystemname");
                                    codeSystemName = "??";
                                }
                                CTabItem tabItem = new CTabItem(ctab, 0);
                                tabItem.setText(codeSystemName);
                                tabItem.setData((Object)codeElement);
                                tabItem.setData("csf", (Object)codeSelectorFactory);
                            }
                        }
                    }
                }
                catch (CoreException ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
            ++n2;
        }
    }

    static void doubleClickEnable(final org.eclipse.swt.widgets.List list) {
        list.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                int sel = list.getSelectionIndex();
                if (sel != -1) {
                    ArrayList backing = (ArrayList)list.getData();
                    PersistentObject po = (PersistentObject)backing.get(sel);
                    ICodeSelectorTarget target = CodeSelectorHandler.getInstance().getCodeSelectorTarget();
                    if (target != null) {
                        target.codeSelected(po);
                    }
                }
            }
        });
    }

    public boolean hasContextMenu() {
        return this.getSelectionProvider() != null && this.getMenuManager() != null;
    }

    public ISelectionProvider getSelectionProvider() {
        return null;
    }

    public MenuManager getMenuManager() {
        return null;
    }

    public void activateContextMenu(IWorkbenchPartSite site, DelegatingSelectionProvider selectionProvider, String viewId) {
        if (this.hasContextMenu() && site.getPart() != null) {
            selectionProvider.setSelectionProviderDelegate(this.getSelectionProvider());
            site.registerContextMenu(String.valueOf(viewId) + "." + this.getCodeSystemName(), this.getMenuManager(), (ISelectionProvider)selectionProvider);
        }
    }

    protected CommonViewer.DoubleClickListener getDoubleClickListener() {
        return new CommonViewer.DoubleClickListener(){

            @Override
            public void doubleClicked(PersistentObject obj, CommonViewer cv) {
                ICodeSelectorTarget target = CodeSelectorHandler.getInstance().getCodeSelectorTarget();
                if (target != null) {
                    if (obj instanceof Leistungsblock) {
                        Leistungsblock block = (Leistungsblock)obj;
                        List elements = block.getElements();
                        for (ICodeElement codeElement : elements) {
                            if (!(codeElement instanceof PersistentObject)) continue;
                            PersistentObject po = (PersistentObject)codeElement;
                            target.codeSelected(po);
                        }
                        List diff = block.getDiffToReferences(elements);
                        if (!diff.isEmpty()) {
                            StringBuilder sb = new StringBuilder();
                            diff.forEach(r -> {
                                if (sb.length() > 0) {
                                    sb.append("\n");
                                }
                                sb.append(r);
                            });
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Warnung", (String)("Warnung folgende Leistungen konnten im aktuellen Kontext (Fall, Konsultation, Gesetz) nicht verrechnet werden.\n" + sb.toString()));
                        }
                    } else {
                        target.codeSelected(obj);
                    }
                }
            }
        };
    }

    static class DragEnabler
    implements PersistentObjectDragSource.ISelectionRenderer {
        org.eclipse.swt.widgets.List list;

        DragEnabler(org.eclipse.swt.widgets.List list) {
            this.list = list;
        }

        @Override
        public List<PersistentObject> getSelection() {
            int sel = this.list.getSelectionIndex();
            ArrayList backing = (ArrayList)this.list.getData();
            PersistentObject po = (PersistentObject)backing.get(sel);
            ArrayList<PersistentObject> ret = new ArrayList<PersistentObject>();
            ret.add(po);
            return ret;
        }
    }

    private static class ResizeListener
    extends ControlAdapter {
        private final String k;
        private final SashForm mine;

        ResizeListener(SashForm form, String key) {
            this.k = key;
            this.mine = form;
        }

        public void controlResized(ControlEvent e) {
            int[] weights = this.mine.getWeights();
            StringBuilder v = new StringBuilder();
            v.append(Integer.toString(weights[0])).append(",").append(Integer.toString(weights[1])).append(",").append(Integer.toString(weights[2]));
            CoreHub.userCfg.set(this.k, v.toString());
        }
    }

    public static class cPage
    extends Composite {
        private ICodeElement template;
        private List<String> lUserMFU;
        private List<String> lPatientMFU;
        private ArrayList<PersistentObject> alPatient;
        private ArrayList<PersistentObject> alUser;
        private org.eclipse.swt.widgets.List lbPatientMFU;
        private org.eclipse.swt.widgets.List lbUserMFU;
        CommonViewer cv;
        ViewerConfigurer vc;
        int[] sashWeights = null;
        ResizeListener resizeListener;
        private final ElexisEventListenerImpl eeli_user = new ElexisUiEventListenerImpl(this, Anwender.class, 64){
            final /* synthetic */ cPage this$1;
            {
                this.this$1 = cPage2;
                super($anonymous0, $anonymous1);
            }

            @Override
            public void runInUi(ElexisEvent ev) {
                if (this.this$1.lbPatientMFU != null && !this.this$1.lbPatientMFU.isDisposed()) {
                    this.this$1.lbPatientMFU.setFont(UiDesk.getFont("anwender/stdfont"));
                }
                if (this.this$1.lbUserMFU != null && !this.this$1.lbUserMFU.isDisposed()) {
                    this.this$1.lbUserMFU.setFont(UiDesk.getFont("anwender/stdfont"));
                }
                if (this.this$1.cv != null && this.this$1.cv.getViewerWidget() != null && !this.this$1.cv.getViewerWidget().getControl().isDisposed()) {
                    this.this$1.cv.getViewerWidget().getControl().setFont(UiDesk.getFont("anwender/stdfont"));
                }
                this.this$1.refresh();
            }
        };

        protected cPage(CTabFolder ctab) {
            super((Composite)ctab, 0);
        }

        cPage(CTabFolder ctab, final ICodeElement codeElement, CodeSelectorFactory codeSelectorFactory) {
            super((Composite)ctab, 0);
            this.template = codeElement;
            this.setLayout((Layout)new FillLayout());
            SashForm sash = new SashForm((Composite)this, 66048);
            String cfgKey = "ansicht/codesystem/" + codeElement.getCodeSystemName();
            this.resizeListener = new ResizeListener(sash, cfgKey);
            String sashW = CoreHub.userCfg.get(cfgKey, "20,20,60");
            this.sashWeights = new int[3];
            int i = 0;
            String[] stringArray = sashW.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String sw = stringArray[n2];
                this.sashWeights[i++] = Integer.parseInt(sw);
                ++n2;
            }
            Group gUserMFU = new Group((Composite)sash, 0);
            gUserMFU.addControlListener((ControlListener)this.resizeListener);
            gUserMFU.setText(Messages.CodeSelectorFactory_yourMostFrequent);
            gUserMFU.setLayout((Layout)new FillLayout());
            gUserMFU.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.lbUserMFU = new org.eclipse.swt.widgets.List((Composite)gUserMFU, 514);
            Group gPatientMFU = new Group((Composite)sash, 0);
            gPatientMFU.addControlListener((ControlListener)this.resizeListener);
            gPatientMFU.setText(Messages.CodeSelectorFactory_patientsMostFrequent);
            gPatientMFU.setLayout((Layout)new FillLayout());
            gPatientMFU.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.lbPatientMFU = new org.eclipse.swt.widgets.List((Composite)gPatientMFU, 514);
            Group gAll = new Group((Composite)sash, 0);
            gAll.setText(Messages.CodeSelectorFactory_all);
            gAll.setLayout((Layout)new GridLayout());
            this.cv = new CommonViewer();
            List actions = codeElement.getActions(null);
            if (actions != null) {
                MenuManager menu = new MenuManager();
                menu.setRemoveAllWhenShown(true);
                menu.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        List actions = codeElement.getActions(null);
                        for (IAction ac : actions) {
                            manager.add(ac);
                        }
                    }
                });
                this.cv.setContextMenu(menu);
            }
            this.vc = codeSelectorFactory.createViewerConfigurer(this.cv);
            Composite cvc = new Composite((Composite)gAll, 0);
            cvc.setLayout((Layout)new GridLayout());
            cvc.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.cv.create(this.vc, cvc, 0, (Object)this);
            this.cv.getViewerWidget().getControl().setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.vc.getContentProvider().startListening();
            this.cv.addDoubleClickListener(codeSelectorFactory.getDoubleClickListener());
            CodeSelectorFactory.doubleClickEnable(this.lbUserMFU);
            CodeSelectorFactory.doubleClickEnable(this.lbPatientMFU);
            this.addUserPopupMenu(this.lbUserMFU);
            this.addPatientPopupMenu(this.lbPatientMFU);
            new PersistentObjectDragSource((Control)this.lbUserMFU, new DragEnabler(this.lbUserMFU));
            new PersistentObjectDragSource((Control)this.lbPatientMFU, new DragEnabler(this.lbPatientMFU));
            try {
                sash.setWeights(this.sashWeights);
            }
            catch (Throwable t) {
                ExHandler.handle((Throwable)t);
                sash.setWeights(new int[]{20, 20, 60});
            }
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_user});
            this.refresh();
        }

        public void dispose() {
            this.vc.getContentProvider().stopListening();
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_user});
            super.dispose();
        }

        public void refresh() {
            this.lbUserMFU.removeAll();
            if (CoreHub.actUser == null) {
                return;
            }
            if (this.template == null) {
                log.error(Messages.CodeSelectorFactory_16);
                return;
            }
            this.lUserMFU = CoreHub.actUser.getStatForItem(this.template.getClass().getName());
            this.alUser = new ArrayList();
            this.lbUserMFU.setData(this.alUser);
            int i = 0;
            while (i < ITEMS_TO_SHOW_IN_MFU_LIST) {
                if (i >= this.lUserMFU.size()) break;
                PersistentObject po = CoreHub.poFactory.createFromString(this.lUserMFU.get(i));
                this.alUser.add(po);
                String lbl = po.getLabel();
                if (StringTool.isNothing((Object)lbl)) {
                    lbl = "?";
                } else {
                    this.lbUserMFU.add(lbl);
                }
                ++i;
            }
            this.lbPatientMFU.removeAll();
            Patient act = ElexisEventDispatcher.getSelectedPatient();
            this.lPatientMFU = act != null ? act.getStatForItem(this.template.getClass().getName()) : new ArrayList<String>();
            this.alPatient = new ArrayList();
            this.lbPatientMFU.setData(this.alPatient);
            int i2 = 0;
            while (i2 < ITEMS_TO_SHOW_IN_MFU_LIST) {
                if (i2 >= this.lPatientMFU.size()) break;
                PersistentObject po = CoreHub.poFactory.createFromString(this.lPatientMFU.get(i2));
                if (po != null) {
                    this.alPatient.add(po);
                    String label = po.getLabel();
                    if (label == null) {
                        this.lbPatientMFU.add("?");
                    } else {
                        this.lbPatientMFU.add(label);
                    }
                }
                ++i2;
            }
        }

        private void addUserPopupMenu(org.eclipse.swt.widgets.List list) {
            Menu menu = new Menu((Decorations)list.getShell(), 8);
            MenuItem item = new MenuItem(menu, 8);
            item.setText(Messages.CodeSelectorFactory_resetStatistic);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Map exi = CoreHub.actUser.getMap("ExtInfo");
                    List statList = (List)exi.get(template.getClass().getName());
                    if (statList != null) {
                        statList.clear();
                        exi.put(template.getClass().getName(), statList);
                        CoreHub.actUser.setMap("ExtInfo", exi);
                    }
                    this.refresh();
                }
            });
            list.setMenu(menu);
        }

        private void addPatientPopupMenu(org.eclipse.swt.widgets.List list) {
            Menu menu = new Menu((Decorations)list.getShell(), 8);
            MenuItem item = new MenuItem(menu, 8);
            item.setText(Messages.CodeSelectorFactory_resetStatistic);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Patient patient = ElexisEventDispatcher.getSelectedPatient();
                    if (patient == null) {
                        return;
                    }
                    Map exi = patient.getMap("ExtInfo");
                    List statList = (List)exi.get(template.getClass().getName());
                    if (statList != null) {
                        statList.clear();
                        exi.put(template.getClass().getName(), statList);
                        patient.setMap("ExtInfo", exi);
                    }
                    this.refresh();
                }
            });
            list.setMenu(menu);
        }
    }
}

