/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.codesystems;

import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.views.codesystems.BlockElementViewerItem;
import ch.elexis.data.Leistungsblock;
import ch.elexis.data.VerrechenbarFavorites;
import java.util.List;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class BlockTreeViewerItem {
    private Leistungsblock block;
    private List<BlockElementViewerItem> currentChildren;

    public static BlockTreeViewerItem of(Leistungsblock block) {
        BlockTreeViewerItem ret = new BlockTreeViewerItem(block);
        return ret;
    }

    public BlockTreeViewerItem(Leistungsblock block) {
        this.block = block;
    }

    public String getText() {
        return this.block.getLabel();
    }

    public Leistungsblock getBlock() {
        return this.block;
    }

    public List<BlockElementViewerItem> getChildren() {
        this.currentChildren = BlockElementViewerItem.of(this.block, false);
        return this.currentChildren;
    }

    public boolean hasChildren() {
        if (this.currentChildren != null) {
            return !this.currentChildren.isEmpty();
        }
        return true;
    }

    public static class ColorizedLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private BlockElementViewerItem.ColorizedLabelProvider elementLabelProvider = new BlockElementViewerItem.ColorizedLabelProvider();

        public String getText(Object element) {
            if (element instanceof BlockElementViewerItem) {
                BlockElementViewerItem item = (BlockElementViewerItem)element;
                return this.elementLabelProvider.getText(item);
            }
            if (element instanceof BlockTreeViewerItem) {
                BlockTreeViewerItem item = (BlockTreeViewerItem)element;
                return item.getText();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            BlockTreeViewerItem item;
            VerrechenbarFavorites.Favorite fav;
            if (element instanceof BlockTreeViewerItem && (fav = VerrechenbarFavorites.isFavorite((IPersistentObject)(item = (BlockTreeViewerItem)element).getBlock())) != null) {
                return Images.IMG_STAR.getImage();
            }
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            if (element instanceof BlockElementViewerItem) {
                BlockElementViewerItem item = (BlockElementViewerItem)element;
                return this.elementLabelProvider.getBackground(item);
            }
            return null;
        }
    }
}

