/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.artikel;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.model.article.IArticle;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.commands.EditEigenartikelUi;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.artikel.Messages;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.core.ui.views.provider.StockEntryLabelProvider;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.StockEntry;
import ch.rgw.tools.ExHandler;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.part.ViewPart;

public class ArtikelSelektor
extends ViewPart
implements ISaveablePart2 {
    public static final String ID = "ch.elexis.ArtikelSelektor";
    CTabFolder ctab;
    TableViewer tv;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.ctab = new CTabFolder(parent, 0);
        this.ctab.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        List list = Extensions.getExtensions((String)"ch.elexis.core.ui.Verrechnungscode");
        this.ctab.addSelectionListener((SelectionListener)new TabSelectionListener());
        for (IConfigurationElement ice : list) {
            if (!"Artikel".equals(ice.getName())) continue;
            try {
                CodeSelectorFactory cs = (CodeSelectorFactory)ice.createExecutableExtension("CodeSelectorFactory");
                CTabItem ci = new CTabItem(this.ctab, 0);
                ci.setText(cs.getCodeSystemName());
                ci.setData("csf", (Object)cs);
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
            }
        }
        CTabItem ci = new CTabItem(this.ctab, 0);
        Composite c = new Composite((Composite)this.ctab, 0);
        c.setLayout((Layout)new GridLayout());
        ci.setControl((Control)c);
        ci.setText(Messages.ArtikelSelector_stockArticles);
        Table table = new Table(c, 576);
        table.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.tv = new TableViewer(table);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return CoreHub.getStockService().getAllStockEntries().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new StockEntryLabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                StockEntry se = (StockEntry)element;
                if (se.getArticle() != null) {
                    String ret = se.getArticle().getName();
                    Integer amount = CoreHub.getStockService().getCumulatedStockForArticle((IArticle)se.getArticle());
                    if (amount != null) {
                        ret = String.valueOf(ret) + " (" + Integer.toString(amount) + ")";
                    }
                    return ret;
                }
                String[] vals = se.get(false, new String[]{"ARTICLE_TYPE", "ARTICLE_ID"});
                return String.valueOf(vals[0]) + "[" + vals[1] + "]";
            }
        });
        this.tv.setInput((Object)this);
    }

    public void setFocus() {
    }

    public void dispose() {
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    private class TabSelectionListener
    extends SelectionAdapter {
        private TabSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            CTabItem top = ArtikelSelektor.this.ctab.getSelection();
            if (top != null && top.getControl() == null) {
                CommonViewer cv = new CommonViewer();
                CodeSelectorFactory cs = (CodeSelectorFactory)top.getData("csf");
                ViewerConfigurer vc = cs.createViewerConfigurer(cv);
                Composite c = new Composite((Composite)ArtikelSelektor.this.ctab, 0);
                c.setLayout((Layout)new GridLayout());
                cv.create(vc, c, 512, ArtikelSelektor.this.getViewSite());
                top.setControl((Control)c);
                top.setData((Object)cv);
                cv.addDoubleClickListener(new CommonViewer.DoubleClickListener(){

                    @Override
                    public void doubleClicked(PersistentObject obj, CommonViewer cv) {
                        EditEigenartikelUi.executeWithParams(obj);
                    }
                });
                vc.getContentProvider().startListening();
            }
        }
    }
}

