/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.dialogs.DocumentSelectDialog;
import ch.elexis.core.ui.dialogs.SelectFallDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.LockResponseHelper;
import ch.elexis.core.ui.text.EditLocalDocumentUtil;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Brief;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.MimeTool;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextView
extends ViewPart
implements IActivationListener {
    public static final String ID = "ch.elexis.TextView";
    TextContainer txt;
    Composite textContainer = null;
    private Brief actBrief;
    private Logger log = LoggerFactory.getLogger((String)"TextView");
    private IAction briefLadenAction;
    private IAction loadTemplateAction;
    private IAction loadSysTemplateAction;
    private IAction saveTemplateAction;
    private IAction showMenuAction;
    private IAction showToolbarAction;
    private IAction importAction;
    private IAction newDocAction;
    private IAction exportAction;
    private ViewMenus menus;

    public void createPartControl(Composite parent) {
        this.txt = new TextContainer(this.getViewSite());
        this.textContainer = this.txt.getPlugin().createContainer(parent, new SaveHandler());
        if (this.textContainer == null) {
            SWTHelper.showError(Messages.TextView_couldNotCreateTextView, Messages.TextView_couldNotLoadTextPlugin);
        } else {
            this.makeActions();
            this.menus = new ViewMenus(this.getViewSite());
            this.menus.createMenu(this.newDocAction, this.briefLadenAction, this.loadTemplateAction, this.loadSysTemplateAction, this.saveTemplateAction, null, this.showMenuAction, this.showToolbarAction, null, this.importAction, this.exportAction);
            GlobalEventDispatcher.addActivationListener(this, (IWorkbenchPart)this);
            this.setName();
        }
    }

    public void setFocus() {
        if (this.textContainer != null) {
            this.textContainer.setFocus();
        }
    }

    public TextContainer getTextContainer() {
        return this.txt;
    }

    public void dispose() {
        if (this.actBrief != null) {
            CoreHub.getLocalLockService().releaseLock((IPersistentObject)this.actBrief);
        }
        GlobalEventDispatcher.removeActivationListener(this, (IWorkbenchPart)this);
        this.actBrief = null;
        super.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean openDocument(Brief doc) {
        if (this.actBrief != null) {
            CoreHub.getLocalLockService().releaseLock((IPersistentObject)this.actBrief);
            this.actBrief.save(this.txt.getPlugin().storeToByteArray(), this.txt.getPlugin().getMimeType());
        }
        if (doc == null) {
            return false;
        }
        LockResponse result = CoreHub.getLocalLockService().acquireLock((IPersistentObject)doc);
        if (result.isOk()) {
            this.txt.getPlugin().setParameter(null);
        } else {
            LockResponseHelper.showInfo(result, (IPersistentObject)doc, this.log);
            this.txt.getPlugin().setParameter(ITextPlugin.Parameter.READ_ONLY);
        }
        if (this.txt.open(doc)) {
            this.log.debug("TextView.openDocument: ");
            this.actBrief = doc;
            this.setName();
            return true;
        }
        this.actBrief = null;
        CoreHub.getLocalLockService().releaseLock((IPersistentObject)doc);
        if (!CoreHub.localCfg.get("briefe/Textmodul_Support_Legacy", false)) {
            this.log.warn("TextView.openDocument: Preferences do not allow alternative method of documents created with legacy text-plugins");
            return false;
        }
        this.setName();
        String ext = MimeTool.getExtension((String)doc.getMimeType());
        if (ext.length() == 0) {
            this.log.warn("TextView.openDocument no extension found for mime type: " + doc.getMimeType());
            ext = "odt";
        }
        try {
            File tmp;
            block23: {
                tmp = File.createTempFile("elexis", "brief." + ext);
                this.log.debug("TextView.openDocument createTempFile: " + tmp.getAbsolutePath() + " mime " + doc.getMimeType());
                tmp.deleteOnExit();
                byte[] buffer = doc.loadBinary();
                if (buffer == null) {
                    this.log.warn("TextView.openDocument createTempFile [{}] -> loadBinary returned null array", (Object)doc.getId());
                    return false;
                }
                Throwable throwable = null;
                Object var6_8 = null;
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
                    try {
                        try (FileOutputStream fos = new FileOutputStream(tmp);){
                            FileTool.copyStreams((InputStream)bais, (OutputStream)fos);
                        }
                        if (bais == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (bais == null) throw throwable;
                        bais.close();
                        throw throwable;
                    }
                    bais.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            File file = new File(tmp.getAbsolutePath());
            file.setReadable(true);
            file.setExecutable(false);
            file.setWritable(false);
            return Program.launch((String)tmp.getAbsolutePath());
        }
        catch (IOException e) {
            ExHandler.handle((Throwable)e);
            return false;
        }
    }

    public boolean createDocument(Brief template, String subject) {
        this.log.debug("TextView.createDocument [{}]: {}", (Object)(template != null ? template.getLabel() : "null"), (Object)subject);
        if (template == null) {
            SWTHelper.showError(Messages.TextView_noTemplateSelected, Messages.TextView_pleaseSelectTemplate);
            return false;
        }
        this.actBrief = this.txt.createFromTemplate(Konsultation.getAktuelleKons(), template, "Allg.", null, subject);
        this.setName();
        if (this.actBrief == null) {
            this.log.debug("TextView.createDocument: createFromTemplate -> null");
            return false;
        }
        return true;
    }

    public boolean createDocument(Brief template, String subject, Kontakt adressat) {
        this.log.debug("TextView.createDocument [{}]: {} Kontakt", (Object)(template != null ? template.getLabel() : "null"), (Object)subject);
        if (template == null) {
            SWTHelper.showError(Messages.TextView_noTemplateSelected, Messages.TextView_pleaseSelectTemplate);
            return false;
        }
        this.actBrief = this.txt.createFromTemplate(Konsultation.getAktuelleKons(), template, "Allg.", adressat, subject);
        EditLocalDocumentUtil.startEditLocalDocument((IViewPart)this, this.actBrief);
        this.setName();
        if (this.actBrief == null) {
            this.log.debug("TextView.createDocument: createFromTemplate -> null");
            return false;
        }
        return true;
    }

    private void makeActions() {
        this.briefLadenAction = new Action(Messages.TextView_openLetter){

            public void run() {
                Patient actPatient = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
                DocumentSelectDialog bs = new DocumentSelectDialog(TextView.this.getViewSite().getShell(), (Person)actPatient, 0);
                if (bs.open() == 0) {
                    TextView.this.openDocument(bs.getSelectedDocument());
                }
            }
        };
        this.loadSysTemplateAction = new Action(Messages.TextView_openSysTemplate){

            public void run() {
                DocumentSelectDialog bs = new DocumentSelectDialog(TextView.this.getViewSite().getShell(), (Person)CoreHub.actMandant, 4);
                if (bs.open() == 0) {
                    TextView.this.openDocument(bs.getSelectedDocument());
                }
            }
        };
        this.loadTemplateAction = new Action(Messages.TextView_openTemplate){

            public void run() {
                DocumentSelectDialog bs = new DocumentSelectDialog(TextView.this.getViewSite().getShell(), (Person)CoreHub.actMandant, 2);
                if (bs.open() == 0) {
                    TextView.this.openDocument(bs.getSelectedDocument());
                }
            }
        };
        this.saveTemplateAction = new Action(Messages.TextView_saveAsTemplate){

            public void run() {
                if (TextView.this.actBrief != null) {
                    TextView.this.txt.saveTemplate(TextView.this.actBrief.get(Messages.TextView_Subject));
                } else {
                    TextView.this.txt.saveTemplate(null);
                }
            }
        };
        this.showMenuAction = new Action(Messages.TextView_showMenu, 2){

            public void run() {
                TextView.this.txt.getPlugin().showMenu(this.isChecked());
            }
        };
        this.showToolbarAction = new Action(Messages.TextView_Toolbar, 2){

            public void run() {
                TextView.this.txt.getPlugin().showToolbar(this.isChecked());
            }
        };
        this.importAction = new Action(Messages.TextView_importText){

            public void run() {
                try {
                    File file;
                    FileDialog fdl = new FileDialog(TextView.this.getViewSite().getShell());
                    String filename = fdl.open();
                    if (filename != null && (file = new File(filename)).exists()) {
                        TextView.this.actBrief = null;
                        TextView.this.setPartName(filename);
                        FileInputStream fis = new FileInputStream(file);
                        TextView.this.txt.getPlugin().loadFromStream(fis, false);
                    }
                }
                catch (Throwable ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        };
        this.exportAction = new Action(Messages.TextView_exportText){

            public void run() {
                try {
                    if (TextView.this.actBrief == null) {
                        SWTHelper.alert("Fehler", "Es ist kein Dokument zum exportieren geladen");
                    } else {
                        FileDialog fdl = new FileDialog(TextView.this.getViewSite().getShell(), 8192);
                        fdl.setFilterExtensions(new String[]{"*.odt", "*.xml", "*.*"});
                        fdl.setFilterNames(new String[]{"OpenOffice.org Text", "XML File", "All files"});
                        String filename = fdl.open();
                        if (filename != null) {
                            if (FileTool.getExtension((String)filename).equals("")) {
                                filename = String.valueOf(filename) + ".odt";
                            }
                            File file = new File(filename);
                            byte[] contents = TextView.this.actBrief.loadBinary();
                            ByteArrayInputStream bais = new ByteArrayInputStream(contents);
                            FileOutputStream fos = new FileOutputStream(file);
                            FileTool.copyStreams((InputStream)bais, (OutputStream)fos);
                            fos.close();
                            bais.close();
                        }
                    }
                }
                catch (Throwable ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        };
        this.newDocAction = new Action(Messages.TextView_newDocument){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
            }

            public void run() {
                Patient pat = ElexisEventDispatcher.getSelectedPatient();
                if (pat != null) {
                    Konsultation selectedKonsultation;
                    Fall selectedFall = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
                    if (selectedFall == null) {
                        SelectFallDialog sfd = new SelectFallDialog(UiDesk.getTopShell());
                        sfd.open();
                        if (sfd.result != null) {
                            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)sfd.result);
                        } else {
                            MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)Messages.TextView_NoCaseSelected, (String)Messages.TextView_SaveNotPossibleNoCaseAndKonsSelected);
                            return;
                        }
                    }
                    if ((selectedKonsultation = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class)) == null) {
                        Konsultation k = pat.getLetzteKons(false);
                        if (k == null) {
                            k = ((Fall)ElexisEventDispatcher.getSelected(Fall.class)).neueKonsultation();
                            k.setMandant(CoreHub.actMandant);
                        }
                        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)k);
                    }
                    TextView.this.actBrief = null;
                    TextView.this.setName();
                    TextView.this.txt.getPlugin().createEmptyDocument();
                } else {
                    MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)Messages.BriefAuswahlNoPatientSelected, (String)Messages.BriefAuswahlNoPatientSelected);
                }
            }
        };
        this.briefLadenAction.setImageDescriptor(Images.IMG_MAIL.getImageDescriptor());
        this.briefLadenAction.setToolTipText("Brief zum Bearbeiten \u00f6ffnen");
        this.showMenuAction.setToolTipText(Messages.TextView_showMenuBar);
        this.showMenuAction.setImageDescriptor(Images.IMG_MENUBAR.getImageDescriptor());
        this.showMenuAction.setChecked(true);
        this.showToolbarAction.setImageDescriptor(Images.IMG_TOOLBAR.getImageDescriptor());
        this.showToolbarAction.setToolTipText(Messages.TextView_showToolbar);
        this.showToolbarAction.setChecked(true);
    }

    @Override
    public void activation(boolean mode) {
        if (!mode) {
            if (this.actBrief != null) {
                this.actBrief.save(this.txt.getPlugin().storeToByteArray(), this.txt.getPlugin().getMimeType());
            }
        } else {
            this.loadSysTemplateAction.setEnabled(CoreHub.acl.request(AccessControlDefaults.DOCUMENT_SYSTEMPLATE));
            this.saveTemplateAction.setEnabled(CoreHub.acl.request(AccessControlDefaults.DOCUMENT_TEMPLATE));
        }
    }

    @Override
    public void visible(boolean mode) {
    }

    void setName() {
        String n = "";
        if (this.actBrief == null) {
            this.setPartName(Messages.TextView_noLetterSelected);
        } else {
            Person pat = this.actBrief.getPatient();
            if (pat != null) {
                n = String.valueOf(pat.getLabel()) + ": ";
            }
            n = String.valueOf(n) + this.actBrief.getBetreff();
            this.setPartName(n);
        }
        this.log.debug("TextView.setName: " + this.getPartName());
    }

    class SaveHandler
    implements ITextPlugin.ICallback {
        SaveHandler() {
        }

        @Override
        public void save() {
            TextView.this.log.debug("TextView.save");
            if (TextView.this.actBrief != null) {
                TextView.this.actBrief.save(TextView.this.txt.getPlugin().storeToByteArray(), TextView.this.txt.getPlugin().getMimeType());
            }
        }

        @Override
        public boolean saveAs() {
            TextView.this.log.debug("TextView.saveAs");
            InputDialog il = new InputDialog(TextView.this.getViewSite().getShell(), Messages.TextView_saveText, Messages.TextView_enterTitle, "", null);
            if (il.open() == 0) {
                TextView.this.actBrief.setBetreff(il.getValue());
                return TextView.this.actBrief.save(TextView.this.txt.getPlugin().storeToByteArray(), TextView.this.txt.getPlugin().getMimeType());
            }
            return false;
        }
    }
}

