/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.StockService;
import ch.elexis.core.data.status.ElexisStatus;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.dialogs.OrderImportDialog;
import ch.elexis.core.ui.dialogs.StockSelectorDialog;
import ch.elexis.core.ui.editors.KontaktSelektorDialogCellEditor;
import ch.elexis.core.ui.editors.PersistentObjectEditingSupport;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.PersistentObjectDragSource;
import ch.elexis.core.ui.util.PersistentObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.provider.StockEntryLabelProvider;
import ch.elexis.data.Artikel;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Stock;
import ch.elexis.data.StockEntry;
import ch.elexis.scripting.CSVWriter;
import ch.rgw.tools.ExHandler;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StockView
extends ViewPart
implements ISaveablePart2,
IActivationListener {
    public static final String ID = "ch.elexis.core.ui.views.StockView";
    private Logger log = LoggerFactory.getLogger(StockView.class);
    private Text filterText;
    private StockEntryLoader loader;
    private TableViewer viewer;
    private StockEntryLabelProvider labelProvider;
    private ViewMenus viewMenus;
    private IAction refreshAction;
    private IAction exportAction;
    String[] columns = new String[]{Messages.LagerView_stock, Messages.LagerView_pharmacode, Messages.LagerView_gtin, Messages.LagerView_name, Messages.LagerView_vkPreis, Messages.LagerView_minBestand, Messages.LagerView_istBestand, Messages.LagerView_maxBestand, Messages.LagerView_dealer};
    int[] colwidth = new int[]{50, 75, 90, 250, 50, 35, 35, 35, 150};

    private void refreshConsiderFilter() {
        if (!this.refreshUseFilter()) {
            this.loader = new StockEntryLoader((Viewer)this.viewer);
            this.loader.schedule();
        }
    }

    private boolean refreshUseFilter() {
        String search = this.filterText.getText();
        if (search != null && search.length() > 2) {
            if (this.loader != null) {
                this.loader.cancel();
            }
            this.loader = new StockEntryLoader((Viewer)this.viewer, search);
            this.loader.schedule();
            return true;
        }
        return false;
    }

    public void createPartControl(Composite parent) {
        this.labelProvider = new StockEntryLabelProvider();
        parent.setLayout((Layout)new GridLayout(2, false));
        this.filterText = new Text(parent, 2176);
        this.filterText.setMessage("Filter");
        this.filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (!StockView.this.refreshUseFilter() && StockView.this.filterText.getText().isEmpty()) {
                    StockView.this.loader = new StockEntryLoader((Viewer)StockView.this.viewer);
                    StockView.this.loader.schedule();
                }
            }
        });
        ToolBarManager tbm = new ToolBarManager();
        tbm.add((IAction)new Action("", 2){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_FILTER.getImageDescriptor();
            }

            public String getToolTipText() {
                return "Nur zu bestellende anzeigen";
            }

            public void run() {
                StockEntryLoader.setFilterOrderOnly(this.isChecked());
                StockView.this.refreshConsiderFilter();
            }
        });
        tbm.createControl(parent);
        this.viewer = new TableViewer(parent, 268503556);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        int i = 0;
        while (i < this.columns.length) {
            TableViewerColumn tvc = new TableViewerColumn(this.viewer, 0);
            TableColumn tc = tvc.getColumn();
            tc.setText(this.columns[i]);
            tc.setWidth(this.colwidth[i]);
            tc.setData((Object)i);
            tvc.setLabelProvider((CellLabelProvider)new StockEntryLabelProvider.ColumnStockEntryLabelProvider(i, this.labelProvider));
            PersistentObjectEditingSupport poes = null;
            if (i == 5) {
                poes = new PersistentObjectEditingSupport(this.viewer, "MIN", Integer.class, true);
            } else if (i == 6) {
                poes = new PersistentObjectEditingSupport(this.viewer, "CURRENT", Integer.class, true){

                    @Override
                    protected boolean canEdit(Object element) {
                        boolean canEdit = super.canEdit(element);
                        if (canEdit) {
                            StockEntry se = (StockEntry)element;
                            return !se.getStock().isCommissioningSystem();
                        }
                        return true;
                    }
                };
            } else if (i == 7) {
                poes = new PersistentObjectEditingSupport(this.viewer, "MAX", Integer.class, true);
            }
            if (poes != null) {
                tvc.setEditingSupport((EditingSupport)poes);
            }
            if (i == 8) {
                EditingSupport providerEditingSupport = new EditingSupport((ColumnViewer)this.viewer){

                    protected void setValue(Object element, Object value) {
                        StockEntry se = (StockEntry)element;
                        if (se == null) {
                            return;
                        }
                        LockResponse lr = CoreHub.getLocalLockService().acquireLock((IPersistentObject)se);
                        if (!lr.isOk()) {
                            return;
                        }
                        se.setProvider((Object)((Kontakt)value));
                        lr = CoreHub.getLocalLockService().releaseLock((IPersistentObject)se);
                        if (!lr.isOk()) {
                            StockView.this.log.warn("Error releasing lock for [{}]: {}", (Object)se.getId(), (Object)lr.getStatus());
                        }
                        this.getViewer().refresh();
                    }

                    protected Object getValue(Object element) {
                        IStockEntry se = (IStockEntry)element;
                        if (se == null) {
                            return null;
                        }
                        return (Kontakt)se.getProvider();
                    }

                    protected CellEditor getCellEditor(Object element) {
                        return new KontaktSelektorDialogCellEditor((Composite)((TableViewer)this.getViewer()).getTable(), "Lieferant ausw\u00e4hlen", "Bitte selektieren Sie den Lieferant");
                    }

                    protected boolean canEdit(Object element) {
                        StockEntry stockEntry = (StockEntry)element;
                        return stockEntry != null && stockEntry.getArticle() != null;
                    }
                };
                tvc.setEditingSupport(providerEditingSupport);
            }
            ++i;
        }
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this.viewer, new FocusCellHighlighter((ColumnViewer)this.viewer){});
        ColumnViewerEditorActivationStrategy editorActivationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                ViewerCell cell = (ViewerCell)event.getSource();
                return cell.getColumnIndex() > 3 && cell.getColumnIndex() < 7;
            }
        };
        TableViewerEditor.create((TableViewer)this.viewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)editorActivationStrategy, (int)16);
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new CheckInOrderedAction((Viewer)StockView.this.viewer));
                manager.add((IAction)new DeleteStockEntryAction((Viewer)StockView.this.viewer));
                ArticleMachineOutputAction amoa = new ArticleMachineOutputAction((Viewer)StockView.this.viewer);
                if (amoa.isVisible()) {
                    manager.add((IAction)amoa);
                    manager.add((IAction)new FullMachineInventoryAction((Viewer)StockView.this.viewer));
                }
            }
        });
        new PersistentObjectDropTarget(this.viewer.getControl(), new PersistentObjectDropTarget.IReceiver(){

            @Override
            public void dropped(PersistentObject o, DropTargetEvent e) {
                if (o instanceof Artikel) {
                    Stock stock;
                    Artikel art = (Artikel)o;
                    StockSelectorDialog ssd = new StockSelectorDialog(UiDesk.getTopShell(), false);
                    int open = ssd.open();
                    if (open == 0 && ssd.getResult().length > 0 && (stock = (Stock)ssd.getResult()[0]) != null) {
                        CoreHub.getStockService().storeArticleInStock((IStock)stock, art.storeToString());
                        StockView.this.viewer.refresh();
                    }
                }
            }

            @Override
            public boolean accept(PersistentObject o) {
                if (o instanceof Artikel) {
                    Artikel art = (Artikel)o;
                    return !art.isProduct();
                }
                return false;
            }
        });
        new PersistentObjectDragSource((StructuredViewer)this.viewer);
        Menu menu = contextMenu.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.makeActions();
        this.viewMenus = new ViewMenus(this.getViewSite());
        this.viewMenus.createToolbar(this.refreshAction);
        this.viewMenus.createMenu(this.exportAction);
        GlobalEventDispatcher.addActivationListener(this, (IWorkbenchPart)this);
    }

    private void makeActions() {
        this.refreshAction = new Action(Messages.StockView_reload){
            {
                this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
            }

            public void run() {
                StockView.this.refreshConsiderFilter();
            }
        };
        this.exportAction = new Action(Messages.LagerView_exportAction, Images.IMG_EXPORT.getImageDescriptor()){

            public void run() {
                block17: {
                    FileDialog dialog = new FileDialog(UiDesk.getTopShell(), 8192);
                    dialog.setFilterExtensions(new String[]{"*.csv"});
                    dialog.setFilterNames(new String[]{"Comma Separated Values (CSV)"});
                    dialog.setOverwrite(true);
                    dialog.setFileName("lager_export.csv");
                    String pathToSave = dialog.open();
                    if (pathToSave != null) {
                        CSVWriter csv = null;
                        try {
                            try {
                                int errorUnkownArticle = 0;
                                int success = 0;
                                csv = new CSVWriter(new FileWriter(pathToSave));
                                StockView.this.log.debug("csv export started for: " + pathToSave);
                                String[] header = new String[]{"Name", "Pharmacode", "EAN", "Max", "Min", "Aktuell Packung an Lager", "Aktuell an Lager (Anbruch)", " St\u00fcck pro Packung", "St\u00fcck pro Abgabe", "Einkaufspreis", "Verkaufspreis", "Typ nach Liste (SL, SL-Bet\u00e4ubung, P, N, LPPV, Migl)", "Lieferant"};
                                csv.writeNext(header);
                                for (Object o : new Query(StockEntry.class).execute()) {
                                    if (!(o instanceof StockEntry)) continue;
                                    String[] line = new String[header.length];
                                    StockEntry stockEntry = (StockEntry)o;
                                    Artikel artikel = stockEntry.getArticle();
                                    if (artikel != null) {
                                        line[0] = artikel.getLabel();
                                        line[1] = artikel.getPharmaCode();
                                        line[2] = artikel.getEAN();
                                        line[3] = String.valueOf(stockEntry.getMaximumStock());
                                        line[4] = String.valueOf(stockEntry.getMinimumStock());
                                        line[5] = String.valueOf(stockEntry.getCurrentStock());
                                        line[6] = String.valueOf(stockEntry.getFractionUnits());
                                        line[7] = String.valueOf(artikel.getPackungsGroesse());
                                        line[8] = String.valueOf(artikel.getAbgabeEinheit());
                                        line[9] = artikel.getEKPreis().getAmountAsString();
                                        line[10] = artikel.getVKPreis().getAmountAsString();
                                        line[11] = artikel.get("Typ");
                                        Kontakt provider = stockEntry.getProvider();
                                        if (provider != null) {
                                            line[12] = provider.getLabel();
                                        }
                                        csv.writeNext(line);
                                        ++success;
                                        continue;
                                    }
                                    ++errorUnkownArticle;
                                    StockView.this.log.warn("cannot export: id [" + stockEntry.getId() + "] artikelId [" + stockEntry.get("ARTICLE_ID") + "] artikelType [" + stockEntry.get("ARTICLE_TYPE") + "] ");
                                }
                                csv.close();
                                StockView.this.log.debug("csv export finished for: " + pathToSave);
                                StringBuffer msg2 = new StringBuffer();
                                msg2.append("Der Export nach ");
                                msg2.append(pathToSave);
                                msg2.append(" ist abgeschlossen.");
                                msg2.append("\n\n");
                                msg2.append(success);
                                msg2.append(" Artikel wurden erfolgreich exportiert.");
                                if (errorUnkownArticle > 0) {
                                    msg2.append("\n");
                                    msg2.append(errorUnkownArticle);
                                    msg2.append(" Artikel konnten nicht exportiert werden (Unbekannte Artikel Typen).");
                                }
                                SWTHelper.showInfo("Lager export", msg2.toString());
                            }
                            catch (Exception ex) {
                                ExHandler.handle((Throwable)ex);
                                StockView.this.log.error("csv exporter error", (Throwable)ex);
                                SWTHelper.showError("Fehler", ex.getMessage());
                                if (csv == null) break block17;
                                try {
                                    csv.close();
                                }
                                catch (IOException e) {
                                    StockView.this.log.error("cannot close csv exporter", (Throwable)e);
                                }
                            }
                        }
                        finally {
                            if (csv != null) {
                                try {
                                    csv.close();
                                }
                                catch (IOException e) {
                                    StockView.this.log.error("cannot close csv exporter", (Throwable)e);
                                }
                            }
                        }
                    }
                }
            }
        };
    }

    public void setFocus() {
        this.filterText.setFocus();
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener(this, (IWorkbenchPart)this);
        super.dispose();
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    @Override
    public void activation(boolean mode) {
    }

    @Override
    public void visible(boolean mode) {
        List allEntries = new Query(StockEntry.class).execute();
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setInput(Collections.singletonList(new String("Es sind " + allEntries.size() + " Lagereintr\u00e4ge vorhanden")));
        }
    }

    public class ArticleMachineOutputAction
    extends Action {
        private Viewer viewer;

        public ArticleMachineOutputAction(Viewer viewer) {
            this.viewer = viewer;
        }

        public boolean isVisible() {
            Stock stock;
            StockEntry stockEntry = this.fetchSelection();
            if (stockEntry != null && (stock = stockEntry.getStock()) != null) {
                String driverUuid = stock.getDriverUuid();
                return driverUuid != null && driverUuid.length() > 8;
            }
            return false;
        }

        public String getText() {
            return Messages.StockView_OutlayArticle;
        }

        public void run() {
            StockEntry stockEntry = this.fetchSelection();
            IStatus status = CoreHub.getStockCommissioningSystemService().performArticleOutlay((IStockEntry)stockEntry, 1, null);
            if (!status.isOK()) {
                ElexisStatus elStatus = new ElexisStatus(status);
                StatusManager.getManager().handle((IStatus)elStatus, 2);
            }
        }

        private StockEntry fetchSelection() {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof StockEntry) {
                return (StockEntry)selection.getFirstElement();
            }
            return null;
        }
    }

    public class CheckInOrderedAction
    extends Action {
        private Viewer viewer;
        private StockEntry stockEntry;

        public CheckInOrderedAction(Viewer viewer) {
            this.viewer = viewer;
        }

        public boolean isEnabled() {
            this.stockEntry = null;
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof StockEntry) {
                this.stockEntry = (StockEntry)selection.getFirstElement();
                if (this.stockEntry.getArticle() != null) {
                    return CoreHub.getOrderService().findOpenOrderEntryForStockEntry((IStockEntry)this.stockEntry) != null;
                }
            }
            return false;
        }

        public String getText() {
            return Messages.BestellView_CheckInCaption;
        }

        public void run() {
            this.stockEntry = null;
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof StockEntry) {
                this.stockEntry = (StockEntry)selection.getFirstElement();
                if (this.stockEntry.getArticle() != null) {
                    IOrderEntry order = CoreHub.getOrderService().findOpenOrderEntryForStockEntry((IStockEntry)this.stockEntry);
                    OrderImportDialog dialog = new OrderImportDialog(this.viewer.getControl().getShell(), order.getOrder());
                    dialog.open();
                    this.viewer.refresh();
                }
            }
        }
    }

    public class DeleteStockEntryAction
    extends Action {
        private Viewer viewer;
        private StockEntry stockEntry;

        public DeleteStockEntryAction(Viewer viewer) {
            this.viewer = viewer;
        }

        public boolean isEnabled() {
            this.stockEntry = null;
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof StockEntry) {
                this.stockEntry = (StockEntry)selection.getFirstElement();
                if (this.stockEntry != null) {
                    Stock stock = this.stockEntry.getStock();
                    return stock != null && !stock.isCommissioningSystem();
                }
            }
            return false;
        }

        public String getText() {
            return Messages.LagerView_deleteAction;
        }

        public String getToolTipText() {
            return Messages.LagerView_deleteActionToolTip;
        }

        public void run() {
            Artikel article;
            if (this.stockEntry != null && (article = this.stockEntry.getArticle()) != null && MessageDialog.openConfirm((Shell)this.viewer.getControl().getShell(), (String)Messages.LagerView_deleteActionConfirmCaption, (String)MessageFormat.format(Messages.LagerView_deleteConfirmBody, article.getName()))) {
                this.stockEntry.delete();
                this.viewer.refresh();
            }
        }
    }

    public class FullMachineInventoryAction
    extends Action {
        private Viewer viewer;

        public FullMachineInventoryAction(Viewer viewer) {
            this.viewer = viewer;
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_SYNC.getImageDescriptor();
        }

        public String getText() {
            return Messages.StockView_PerformFullInventoryOnCommSystem;
        }

        public void run() {
            StockEntry stockEntry = this.fetchSelection();
            IStatus status = CoreHub.getStockCommissioningSystemService().synchronizeInventory((IStock)stockEntry.getStock(), null, null);
            if (!status.isOK()) {
                ElexisStatus elStatus = new ElexisStatus(status);
                StatusManager.getManager().handle((IStatus)elStatus, 2);
            }
        }

        private StockEntry fetchSelection() {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof StockEntry) {
                return (StockEntry)selection.getFirstElement();
            }
            return null;
        }
    }

    private static class StockEntryLoader
    extends Job {
        private Viewer viewer;
        private static boolean filterOrderOnly = false;
        private String filter;
        private List<StockEntry> loaded;

        public StockEntryLoader(Viewer viewer, String filter) {
            super("Stock loading ...");
            this.viewer = viewer;
            this.filter = filter;
        }

        public static void setFilterOrderOnly(boolean checked) {
            filterOrderOnly = checked;
        }

        public StockEntryLoader(Viewer viewer) {
            super("Stock loading ...");
            this.viewer = viewer;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Stock loading ...", -1);
            this.loaded = new Query(StockEntry.class, null, null, "STOCK_ENTRY", new String[]{"ARTICLE_ID"}).execute();
            if (filterOrderOnly) {
                this.loaded = this.loaded.parallelStream().filter(se -> this.selectOrderOnly((StockEntry)se)).collect(Collectors.toList());
            }
            if (this.filter != null) {
                this.loaded = this.loaded.parallelStream().filter(se -> this.selectFilter((StockEntry)se, this.filter)).collect(Collectors.toList());
            }
            this.loaded.sort((l, r) -> {
                if (l.getArticle() != null && r.getArticle() != null) {
                    return l.getArticle().getLabel().compareTo(r.getArticle().getLabel());
                }
                return 0;
            });
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.done();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    viewer.setInput((Object)loaded);
                }
            });
            return Status.OK_STATUS;
        }

        private boolean selectOrderOnly(StockEntry se) {
            IStockService.Availability availability = StockService.determineAvailability((IStockEntry)se);
            if (availability != null) {
                switch (availability) {
                    case CRITICAL_STOCK: 
                    case OUT_OF_STOCK: {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        private boolean selectFilter(StockEntry se, String filter) {
            if (se.getArticle() != null && se.getArticle().getLabel() != null) {
                return se.getArticle().getLabel().toLowerCase().contains(filter.toLowerCase());
            }
            return false;
        }
    }
}

