/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.interfaces.IOutputter;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.dialogs.MediDetailDialog;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.PersistentObjectDragSource;
import ch.elexis.core.ui.util.PersistentObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.RezeptBlatt;
import ch.elexis.core.ui.views.codesystems.LeistungenView;
import ch.elexis.data.Artikel;
import ch.elexis.data.Brief;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.OutputLog;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import ch.elexis.data.Rezept;
import ch.rgw.tools.ExHandler;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class RezepteView
extends ViewPart
implements IActivationListener,
ISaveablePart2 {
    public static final String ID = "ch.elexis.Rezepte";
    private final FormToolkit tk = UiDesk.getToolkit();
    private Form master;
    TableViewer tv;
    ListViewer lvRpLines;
    private Action newRpAction;
    private Action deleteRpAction;
    private Action addLineAction;
    private Action removeLineAction;
    private Action changeMedicationAction;
    private ViewMenus menus;
    private Action printAction;
    private Patient actPatient;
    private PersistentObjectDropTarget dropTarget;
    private final ElexisEventListener eeli_pat = new ElexisUiEventListenerImpl(Patient.class){

        @Override
        public void runInUi(ElexisEvent ev) {
            if (RezepteView.this.tv != null && RezepteView.this.tv.getControl() != null && !RezepteView.this.tv.getControl().isDisposed()) {
                if (ev.getType() == 16) {
                    Patient newPatient = (Patient)ev.getObject();
                    if (RezepteView.this.actPatient == null || !RezepteView.this.actPatient.equals((Object)newPatient)) {
                        RezepteView.this.actPatient = newPatient;
                        ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent(null, Rezept.class, 32)});
                        RezepteView.this.addLineAction.setEnabled(false);
                        RezepteView.this.printAction.setEnabled(false);
                        RezepteView.this.tv.refresh(true);
                        RezepteView.this.refresh();
                        RezepteView.this.master.setText(RezepteView.this.actPatient.getLabel());
                    }
                } else if (ev.getType() == 32) {
                    RezepteView.this.actPatient = null;
                    ElexisEventDispatcher.clearSelection(Rezept.class);
                    RezepteView.this.refresh();
                }
            }
        }
    };
    private final ElexisEventListener eeli_rp = new ElexisUiEventListenerImpl(Rezept.class, 20){

        @Override
        public void runInUi(ElexisEvent ev) {
            if (RezepteView.this.tv != null && RezepteView.this.tv.getControl() != null && !RezepteView.this.tv.getControl().isDisposed()) {
                if (ev.getType() == 16) {
                    RezepteView.this.actPatient = ((Rezept)ev.getObject()).getPatient();
                    RezepteView.this.refresh();
                } else if (ev.getType() == 4) {
                    RezepteView.this.actPatient = ((Rezept)ev.getObject()).getPatient();
                    RezepteView.this.tv.refresh(true);
                }
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.setTitleImage(Images.IMG_VIEW_RECIPES.getImage());
        parent.setLayout((Layout)new GridLayout());
        this.master = this.tk.createForm(parent);
        this.master.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.master.getBody().setLayout((Layout)new FillLayout());
        SashForm sash = new SashForm(this.master.getBody(), 0);
        this.tv = new TableViewer((Composite)sash, 66048);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Query qbe = new Query(Rezept.class);
                if (RezepteView.this.actPatient != null) {
                    qbe.add("PatientID", "=", RezepteView.this.actPatient.getId());
                    qbe.orderBy(true, new String[]{"Datum", "lastupdate"});
                    List list = qbe.execute();
                    return list.toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Rezept) {
                    Rezept rp = (Rezept)element;
                    return rp.getLabel();
                }
                return element.toString();
            }

            public Image getImage(Object element) {
                OutputLog o;
                String outputterID;
                IOutputter io;
                List outputs = OutputLog.getOutputs((PersistentObject)((PersistentObject)element));
                if (outputs != null && outputs.size() > 0 && (io = OutputLog.getOutputter((String)(outputterID = (o = (OutputLog)outputs.get(0)).getOutputterID()))) != null) {
                    return (Image)io.getSymbol();
                }
                return null;
            }
        });
        this.tv.addSelectionChangedListener((ISelectionChangedListener)GlobalEventDispatcher.getInstance().getDefaultListener());
        this.lvRpLines = new ListViewer((Composite)sash);
        this.makeActions();
        this.menus = new ViewMenus(this.getViewSite());
        this.menus.createMenu(new IAction[]{this.newRpAction, this.addLineAction, this.printAction, this.deleteRpAction});
        this.menus.createViewerContextMenu((StructuredViewer)this.lvRpLines, new IAction[]{this.removeLineAction, this.changeMedicationAction});
        this.getSite().setSelectionProvider((ISelectionProvider)this.lvRpLines);
        IToolBarManager tm = this.getViewSite().getActionBars().getToolBarManager();
        List importers = Extensions.getClasses((List)Extensions.getExtensions((String)"ch.elexis.core.ui.RezeptHook"), (String)"RpToolbarAction", (boolean)false);
        for (IAction ac : importers) {
            tm.add(ac);
        }
        if (importers.size() > 0) {
            tm.add((IContributionItem)new Separator());
        }
        tm.add((IAction)this.newRpAction);
        tm.add((IAction)this.addLineAction);
        tm.add((IAction)this.printAction);
        this.tv.setInput((Object)this.getViewSite());
        PersistentObjectDropTarget.IReceiver dtr = new PersistentObjectDropTarget.IReceiver(){

            @Override
            public boolean accept(PersistentObject o) {
                return true;
            }

            @Override
            public void dropped(PersistentObject o, DropTargetEvent ev) {
                Rezept actR = (Rezept)ElexisEventDispatcher.getSelected(Rezept.class);
                if (actR == null) {
                    SWTHelper.showError(Messages.RezepteView_NoPrescriptionSelected, Messages.RezepteView_PleaseChoosaAPrescription);
                    return;
                }
                if (o instanceof Artikel) {
                    Artikel art = (Artikel)o;
                    Prescription p = new Prescription(art, actR.getPatient(), "", "");
                    actR.addPrescription(p);
                    RezepteView.this.refresh();
                } else if (o instanceof Prescription) {
                    Prescription pre = (Prescription)o;
                    Prescription now = new Prescription(pre.getArtikel(), actR.getPatient(), pre.getDosis(), pre.getBemerkung());
                    actR.addPrescription(now);
                    RezepteView.this.refresh();
                }
            }
        };
        this.dropTarget = new PersistentObjectDropTarget("Rezept", this.lvRpLines.getControl(), dtr);
        this.lvRpLines.setContentProvider((IContentProvider)new RezeptContentProvider());
        this.lvRpLines.setLabelProvider((IBaseLabelProvider)new RezeptLabelProvider());
        this.lvRpLines.getControl().setToolTipText(Messages.RezepteView_DragMedicamentsHere);
        new PersistentObjectDragSource((StructuredViewer)this.lvRpLines);
        this.lvRpLines.setInput((Object)this.getViewSite());
        this.addLineAction.setEnabled(false);
        this.printAction.setEnabled(false);
        GlobalEventDispatcher.addActivationListener(this, (IWorkbenchPart)this);
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                try {
                    RezeptBlatt rp = (RezeptBlatt)RezepteView.this.getViewSite().getPage().showView("ch.elexis.RezeptBlatt");
                    Rezept actR = (Rezept)ElexisEventDispatcher.getSelected(Rezept.class);
                    Brief rpBrief = actR.getBrief();
                    if (rpBrief != null) {
                        rp.loadRezeptFromDatabase(actR, rpBrief);
                    } else {
                        rp.createRezept(actR);
                    }
                }
                catch (Throwable ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        });
    }

    public void setFocus() {
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener(this, (IWorkbenchPart)this);
        this.tv.removeSelectionChangedListener((ISelectionChangedListener)GlobalEventDispatcher.getInstance().getDefaultListener());
    }

    public void refresh() {
        Rezept rp = (Rezept)ElexisEventDispatcher.getSelected(Rezept.class);
        if (rp == null) {
            this.lvRpLines.refresh(true);
            this.addLineAction.setEnabled(false);
            this.printAction.setEnabled(false);
        } else {
            this.lvRpLines.refresh(true);
            this.addLineAction.setEnabled(true);
            this.printAction.setEnabled(true);
            this.master.setText(rp.getPatient().getLabel());
        }
    }

    private void makeActions() {
        this.newRpAction = new Action(Messages.RezepteView_newPrescriptionAction){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText(Messages.RezepteView_newPrescriptonTooltip);
            }

            public void run() {
                Konsultation k;
                Patient act = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
                if (act == null) {
                    MessageBox mb = new MessageBox(RezepteView.this.getViewSite().getShell(), 34);
                    mb.setText(Messages.RezepteView_newPrescriptionError);
                    mb.setMessage(Messages.RezepteView_noPatientSelected);
                    mb.open();
                    return;
                }
                Fall fall = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
                if (fall == null && (k = act.getLetzteKons(false)) == null) {
                    SWTHelper.alert(Messages.RezepteView_noCaseSelected, Messages.RezepteView_pleaseCreateOrChooseCase);
                    return;
                }
                Rezept rezept = new Rezept(act);
                RezepteView.this.tv.refresh();
                RezepteView.this.doSelectNewRezept(rezept);
                RezepteView.this.doAddLine();
            }
        };
        this.deleteRpAction = new Action(Messages.RezepteView_deletePrescriptionActiom){

            public void run() {
                Rezept rp = (Rezept)ElexisEventDispatcher.getSelected(Rezept.class);
                if (MessageDialog.openConfirm((Shell)RezepteView.this.getViewSite().getShell(), (String)Messages.RezepteView_deletePrescriptionActiom, (String)MessageFormat.format(Messages.RezepteView_deletePrescriptionConfirm, rp.getDate()))) {
                    rp.delete();
                    RezepteView.this.tv.refresh();
                }
            }
        };
        this.removeLineAction = new Action(Messages.RezepteView_deleteLineAction){

            public void run() {
                Rezept rp = (Rezept)ElexisEventDispatcher.getSelected(Rezept.class);
                IStructuredSelection sel = (IStructuredSelection)RezepteView.this.lvRpLines.getSelection();
                Prescription p = (Prescription)sel.getFirstElement();
                if (rp != null && p != null) {
                    rp.removePrescription(p);
                    RezepteView.this.lvRpLines.refresh();
                }
            }
        };
        this.addLineAction = new Action(Messages.RezepteView_newLineAction){

            public void run() {
                RezepteView.this.doAddLine();
            }
        };
        this.printAction = new Action(Messages.RezepteView_printAction){

            public void run() {
                try {
                    RezeptBlatt rp = (RezeptBlatt)RezepteView.this.getViewSite().getPage().showView("ch.elexis.RezeptBlatt");
                    Rezept actR = (Rezept)ElexisEventDispatcher.getSelected(Rezept.class);
                    Brief rpBrief = actR.getBrief();
                    if (rpBrief == null) {
                        rp.createRezept(actR);
                    } else {
                        String[] dialogButtonLabels = new String[]{Messages.RezepteView_RecreatePrescription, Messages.RezepteView_ShowPrescription, Messages.RezepteView_PrescriptionCancel};
                        MessageDialog msg = new MessageDialog(null, Messages.RezepteView_CreatePrescription, null, Messages.RezepteView_ReallyWantToRecreatePrescription, 4, dialogButtonLabels, 2);
                        int result = msg.open();
                        switch (result) {
                            case 0: {
                                rp.createRezept(actR);
                                break;
                            }
                            case 1: {
                                rp.loadRezeptFromDatabase(actR, rpBrief);
                                break;
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        };
        this.changeMedicationAction = new RestrictedAction(AccessControlDefaults.MEDICATION_MODIFY, Messages.RezepteView_ChangeLink){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.RezepteView_ChangeTooltip);
            }

            @Override
            public void doRun() {
                Rezept rp = (Rezept)ElexisEventDispatcher.getSelected(Rezept.class);
                IStructuredSelection sel = (IStructuredSelection)RezepteView.this.lvRpLines.getSelection();
                Prescription pr = (Prescription)sel.getFirstElement();
                if (pr != null) {
                    new MediDetailDialog(RezepteView.this.getViewSite().getShell(), pr).open();
                    RezepteView.this.lvRpLines.refresh();
                }
            }
        };
        this.addLineAction.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
        this.printAction.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
        this.deleteRpAction.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
    }

    private void doSelectNewRezept(Rezept rezept) {
        this.tv.getTable().setFocus();
        this.tv.setSelection((ISelection)new StructuredSelection((Object)rezept), true);
    }

    private void doAddLine() {
        try {
            CTabItem[] tabItems;
            LeistungenView lv1 = (LeistungenView)this.getViewSite().getPage().showView("ch.elexis.LeistungenView");
            CodeSelectorHandler.getInstance().setCodeSelectorTarget(this.dropTarget);
            CTabItem[] cTabItemArray = tabItems = lv1.ctab.getItems();
            int n = tabItems.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem tab = cTabItemArray[n2];
                ICodeElement ics = (ICodeElement)tab.getData();
                if (ics instanceof Artikel) {
                    lv1.ctab.setSelection(tab);
                    break;
                }
                ++n2;
            }
        }
        catch (PartInitException ex) {
            ExHandler.handle((Throwable)ex);
        }
    }

    @Override
    public void activation(boolean mode) {
    }

    @Override
    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_rp});
            Rezept actRezept = (Rezept)ElexisEventDispatcher.getSelected(Rezept.class);
            Patient global = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
            if (global != null) {
                if (actRezept == null || !actRezept.getPatient().getId().equals(global.getId())) {
                    this.eeli_pat.catchElexisEvent(new ElexisEvent((IPersistentObject)global, Patient.class, 16));
                } else {
                    this.eeli_rp.catchElexisEvent(new ElexisEvent((IPersistentObject)actRezept, Rezept.class, 16));
                }
                this.addLineAction.setEnabled(actRezept != null);
            }
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_rp});
        }
    }

    public void clearEvent(Class<? extends PersistentObject> template) {
        this.lvRpLines.refresh();
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    private static class RezeptContentProvider
    implements IStructuredContentProvider {
        private RezeptContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Rezept rp = (Rezept)ElexisEventDispatcher.getSelected(Rezept.class);
            if (rp == null) {
                return new Prescription[0];
            }
            List list = rp.getLines();
            return list.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class RezeptLabelProvider
    extends LabelProvider {
        private RezeptLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Prescription) {
                Prescription z = (Prescription)element;
                return z.getLabel();
            }
            return "?";
        }
    }
}

