/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IOutputter;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.LockResponseHelper;
import ch.elexis.core.ui.text.EditLocalDocumentUtil;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Brief;
import ch.elexis.data.Kontakt;
import ch.elexis.data.OutputLog;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.elexis.data.Rezept;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class RezeptBlatt
extends ViewPart
implements ITextPlugin.ICallback,
IActivationListener,
IOutputter {
    public static final String ID = "ch.elexis.RezeptBlatt";
    TextContainer text;
    Brief actBrief;

    public void dispose() {
        if (this.actBrief != null) {
            CoreHub.getLocalLockService().releaseLock((IPersistentObject)this.actBrief);
        }
        GlobalEventDispatcher.removeActivationListener(this, (IWorkbenchPart)this);
        super.dispose();
    }

    private void updateTextLock() {
        if (this.actBrief != null) {
            LockResponse result = CoreHub.getLocalLockService().acquireLock((IPersistentObject)this.actBrief);
            if (result.isOk()) {
                this.text.getPlugin().setParameter(null);
            } else {
                LockResponseHelper.showInfo(result, (IPersistentObject)this.actBrief, null);
                this.text.getPlugin().setParameter(ITextPlugin.Parameter.READ_ONLY);
            }
        }
    }

    public void loadRezeptFromDatabase(Rezept rp, Brief brief) {
        if (this.actBrief != null) {
            CoreHub.getLocalLockService().releaseLock((IPersistentObject)this.actBrief);
        }
        this.actBrief = brief;
        this.updateTextLock();
        this.text.open(brief);
        rp.setBrief(this.actBrief);
        EditLocalDocumentUtil.startEditLocalDocument((IViewPart)this, brief);
    }

    public void createPartControl(Composite parent) {
        this.text = new TextContainer(this.getViewSite());
        this.text.getPlugin().createContainer(parent, this);
        GlobalEventDispatcher.addActivationListener(this, (IWorkbenchPart)this);
    }

    public void setFocus() {
    }

    public boolean createList(Rezept rp, String template, String replace) {
        if (this.actBrief != null) {
            CoreHub.getLocalLockService().releaseLock((IPersistentObject)this.actBrief);
        }
        this.actBrief = this.text.createFromTemplateName(this.text.getAktuelleKons(), template, "Rezept", (Kontakt)((Patient)ElexisEventDispatcher.getSelected(Patient.class)), String.valueOf(template) + " " + rp.getDate());
        this.updateTextLock();
        List lines = rp.getLines();
        String[][] fields = new String[lines.size()][];
        fields = replace.equals(Messages.RezeptBlatt_4) ? this.createRezeptListFields(lines) : this.createTakingListFields(lines);
        int[] wt = new int[]{10, 70, 20};
        rp.setBrief(this.actBrief);
        if (this.text.getPlugin().insertTable(replace, 0, fields, wt)) {
            if (this.text.getPlugin().isDirectOutput()) {
                this.text.getPlugin().print(null, null, true);
                this.getSite().getPage().hideView((IViewPart)this);
            }
            this.text.saveBrief(this.actBrief, "Rezept");
            EditLocalDocumentUtil.startEditLocalDocument((IViewPart)this, this.actBrief);
            return true;
        }
        this.text.saveBrief(this.actBrief, "Rezept");
        return false;
    }

    public boolean createList(Prescription[] prescriptions, String template, String replace) {
        if (this.actBrief != null) {
            CoreHub.getLocalLockService().releaseLock((IPersistentObject)this.actBrief);
        }
        TimeTool now = new TimeTool();
        this.actBrief = this.text.createFromTemplateName(this.text.getAktuelleKons(), template, "Allg.", (Kontakt)((Patient)ElexisEventDispatcher.getSelected(Patient.class)), String.valueOf(template) + " " + now.toString(4));
        this.updateTextLock();
        List<Prescription> lines = Arrays.asList(prescriptions);
        String[][] fields = new String[lines.size()][];
        fields = replace.equals(Messages.RezeptBlatt_4) ? this.createRezeptListFields(lines) : this.createTakingListFields(lines);
        int[] wt = new int[]{10, 70, 20};
        if (this.text.getPlugin().insertTable(replace, 0, fields, wt)) {
            if (this.text.getPlugin().isDirectOutput()) {
                this.text.getPlugin().print(null, null, true);
                this.getSite().getPage().hideView((IViewPart)this);
            }
            this.text.saveBrief(this.actBrief, "Allg.");
            EditLocalDocumentUtil.startEditLocalDocument((IViewPart)this, this.actBrief);
            return true;
        }
        this.text.saveBrief(this.actBrief, "Allg.");
        return false;
    }

    public String[][] createRezeptListFields(List<Prescription> lines) {
        String[][] fields = new String[lines.size()][];
        int i = 0;
        while (i < fields.length) {
            Prescription p = lines.get(i);
            fields[i] = new String[3];
            fields[i][0] = p.get(Messages.RezeptBlatt_number);
            String bem = p.getBemerkung();
            fields[i][1] = StringTool.isNothing((Object)bem) ? p.getSimpleLabel() : String.valueOf(p.getSimpleLabel()) + "\t\r" + bem;
            fields[i][2] = p.getDosis();
            ++i;
        }
        return fields;
    }

    public String[][] createTakingListFields(List<Prescription> lines) {
        String[][] fields = new String[lines.size()][];
        int i = 0;
        while (i < fields.length) {
            Prescription p = lines.get(i);
            fields[i] = new String[3];
            fields[i][0] = p.get(Messages.RezeptBlatt_number);
            String bem = p.getBemerkung();
            String patInfo = p.getDisposalComment();
            fields[i][1] = StringTool.isNothing((Object)bem) ? p.getSimpleLabel() : (patInfo == null || patInfo.isEmpty() ? String.valueOf(p.getSimpleLabel()) + "\t\r" + bem : String.valueOf(p.getSimpleLabel()) + "\t\r" + bem + "\r" + patInfo);
            fields[i][2] = p.getDosis();
            ++i;
        }
        return fields;
    }

    public boolean createRezept(Rezept rp) {
        if (this.createList(rp, "Rezept", Messages.RezeptBlatt_4)) {
            new OutputLog((PersistentObject)rp, (IOutputter)this);
            return true;
        }
        return false;
    }

    public boolean createEinnahmeliste(Patient pat, Prescription[] pres) {
        return this.createList(pres, "Einnahmeliste", Messages.RezeptBlatt_6);
    }

    @Override
    public void save() {
        if (this.actBrief != null) {
            this.actBrief.save(this.text.getPlugin().storeToByteArray(), this.text.getPlugin().getMimeType());
        }
    }

    @Override
    public boolean saveAs() {
        return false;
    }

    @Override
    public void activation(boolean mode) {
        if (!mode) {
            this.save();
        }
    }

    @Override
    public void visible(boolean mode) {
    }

    public String getOutputterDescription() {
        return "Druckerausgabe erstellt";
    }

    public String getOutputterID() {
        return ID;
    }

    public Image getSymbol() {
        return Images.IMG_PRINTER.getImage();
    }
}

