/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.IPatFilter;
import ch.elexis.data.Artikel;
import ch.elexis.data.BezugsKontakt;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.NamedBlob;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import ch.elexis.data.Script;
import ch.elexis.data.Sticker;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.ExHandler;
import java.util.ArrayList;
import java.util.List;

public class PatFilterImpl
implements IPatFilter {
    @Override
    public int accept(Patient p, PersistentObject o) {
        if (o instanceof Kontakt) {
            Query qbe = new Query(BezugsKontakt.class);
            qbe.add("myID", "=", p.getId());
            qbe.add("otherID", "=", o.getId());
            if (qbe.execute().size() > 0) {
                return 1;
            }
            return -1;
        }
        if (o instanceof IVerrechenbar) {
            Fall[] faelle;
            IVerrechenbar iv = (IVerrechenbar)o;
            Fall[] fallArray = faelle = p.getFaelle();
            int n = faelle.length;
            int n2 = 0;
            while (n2 < n) {
                Konsultation[] konsen;
                Fall fall = fallArray[n2];
                Konsultation[] konsultationArray = konsen = fall.getBehandlungen(false);
                int n3 = konsen.length;
                int n4 = 0;
                while (n4 < n3) {
                    Konsultation k = konsultationArray[n4];
                    List lv = k.getLeistungen();
                    for (Verrechnet v : lv) {
                        if (!v.getVerrechenbar().equals(iv)) continue;
                        return 1;
                    }
                    ++n4;
                }
                ++n2;
            }
            return -1;
        }
        if (o instanceof IDiagnose) {
            Fall[] faelle;
            IDiagnose diag = (IDiagnose)o;
            Fall[] fallArray = faelle = p.getFaelle();
            int n = faelle.length;
            int n5 = 0;
            while (n5 < n) {
                Konsultation[] konsen;
                Fall fall = fallArray[n5];
                Konsultation[] konsultationArray = konsen = fall.getBehandlungen(false);
                int n6 = konsen.length;
                int n7 = 0;
                while (n7 < n6) {
                    Konsultation k = konsultationArray[n7];
                    ArrayList id = k.getDiagnosen();
                    if (id.contains(diag)) {
                        return 1;
                    }
                    ++n7;
                }
                ++n5;
            }
            return -1;
        }
        if (o instanceof Artikel) {
            Query qbe = new Query(Prescription.class);
            qbe.add("PatientID", "=", p.getId());
            qbe.add("Artikel", "=", o.storeToString());
            if (qbe.execute().size() > 0) {
                return 1;
            }
            return -1;
        }
        if (o instanceof Prescription) {
            Artikel art = ((Prescription)o).getArtikel();
            Query qbe = new Query(Prescription.class);
            qbe.add("PatientID", "=", p.getId());
            qbe.add("Artikel", "=", art.storeToString());
            if (qbe.execute().size() > 0) {
                return 1;
            }
            return -1;
        }
        if (o instanceof Sticker) {
            ISticker e;
            List etis = p.getStickers();
            if (etis.contains(e = (ISticker)o)) {
                return 1;
            }
            return -1;
        }
        if (o instanceof NamedBlob) {
            NamedBlob nb = (NamedBlob)o;
            String[] val = nb.getString().split("::");
            String test = p.get(val[0]);
            if (test == null) {
                return 0;
            }
            String op = val[1];
            if (op.equals("=")) {
                return test.equalsIgnoreCase(val[2]) ? 1 : -1;
            }
            if (op.equals("LIKE")) {
                return test.toLowerCase().contains(val[2].toLowerCase()) ? 1 : -1;
            }
            if (op.equals("Regexp")) {
                return test.matches(val[2]) ? 1 : -1;
            }
        } else if (o instanceof Script) {
            try {
                Script script = (Script)o;
                script.setVariable("patient", (Object)p);
                Object ret = script.execute(null, new PersistentObject[]{p});
                if (ret instanceof Integer) {
                    return (Integer)ret;
                }
            }
            catch (Exception e) {
                return -2;
            }
        }
        return 0;
    }

    @Override
    public boolean aboutToStart(PersistentObject filter) {
        if (filter instanceof Script) {
            try {
                ((Script)filter).init();
                return true;
            }
            catch (Exception e) {
                ExHandler.handle((Throwable)e);
                SWTHelper.showError("Fehler beim Initialisieren des Scripts", e.getMessage());
            }
        }
        return false;
    }

    @Override
    public boolean finished(PersistentObject filter) {
        if (filter instanceof Script) {
            try {
                ((Script)filter).finished();
                return true;
            }
            catch (Exception e) {
                ExHandler.handle((Throwable)e);
                SWTHelper.showError("Fehler beim Abschluss des Scripts", e.getMessage());
            }
        }
        return false;
    }
}

