/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.data.UiMandant;
import ch.elexis.core.ui.dialogs.AssignStickerDialog;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.events.ElexisUiSyncEventListenerImpl;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.core.ui.locks.LockedAction;
import ch.elexis.core.ui.locks.LockedRestrictedAction;
import ch.elexis.core.ui.text.EnhancedTextField;
import ch.elexis.core.ui.util.FallComparator;
import ch.elexis.core.ui.util.IKonsExtension;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.DiagnosenDisplay;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.VerrechnungsDisplay;
import ch.elexis.core.ui.views.controls.StickerComposite;
import ch.elexis.data.Anwender;
import ch.elexis.data.Artikel;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rechnungssteller;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionedResource;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KonsDetailView
extends ViewPart
implements IActivationListener,
ISaveablePart2,
IUnlockable {
    private static final String NO_CONS_SELECTED = Messages.KonsDetailView_NoConsSelected;
    public static final String ID = "ch.elexis.Konsdetail";
    public static final String CFG_VERTRELATION = "vertrelation";
    public static final String CFG_HORIZRELATION = "horizrelation";
    private Logger log = LoggerFactory.getLogger(KonsDetailView.class);
    Hashtable<String, IKonsExtension> hXrefs;
    EnhancedTextField text;
    private Label lBeh;
    Hyperlink hlMandant;
    ComboViewer comboViewerFall;
    private Konsultation actKons;
    FormToolkit tk;
    Form form;
    Patient actPat;
    Color defaultBackground;
    private DiagnosenDisplay dd;
    private VerrechnungsDisplay vd;
    private Action versionBackAction;
    private LockedAction<Konsultation> saveAction;
    private RestrictedAction purgeAction;
    Action versionFwdAction;
    Action assignStickerAction;
    Action versionDisplayAction;
    int displayedVersion;
    Font emFont;
    Composite cDesc;
    StickerComposite stickerComposite;
    private int[] sashWeights = null;
    private SashForm sash;
    private int[] diagAndChargeSashWeights = null;
    private SashForm diagAndChargeSash;
    private ComboFallSelectionListener comboFallSelectionListener;
    private final ElexisEventListener eeli_pat = new ElexisUiEventListenerImpl(Patient.class, 28){

        @Override
        public void runInUi(ElexisEvent ev) {
            KonsDetailView.this.actPat = null;
            KonsDetailView.this.setPatient((Patient)ev.getObject());
        }
    };
    private final ElexisEventListener eeli_user = new ElexisUiEventListenerImpl(Anwender.class, 64){

        @Override
        public void runInUi(ElexisEvent ev) {
            KonsDetailView.this.adaptMenus();
        }
    };
    private final ElexisEventListener eeli_fall = new ElexisUiEventListenerImpl(Fall.class, 10){

        @Override
        public void runInUi(ElexisEvent ev) {
            KonsDetailView.this.updateFallCombo();
        }
    };
    private final ElexisEventListener eeli_kons_sync = new ElexisUiSyncEventListenerImpl(Konsultation.class, 8192){

        @Override
        public void runInUi(ElexisEvent ev) {
            Konsultation kons = (Konsultation)ev.getObject();
            if (kons.equals((Object)KonsDetailView.this.actKons)) {
                KonsDetailView.this.save();
            }
        }
    };
    private final ElexisEventListener eeli_kons = new ElexisUiEventListenerImpl(Konsultation.class, 20532){

        @Override
        public void runInUi(ElexisEvent ev) {
            Konsultation kons = (Konsultation)ev.getObject();
            Konsultation deselectedKons = null;
            switch (ev.getType()) {
                case 16: {
                    deselectedKons = KonsDetailView.this.actKons;
                    KonsDetailView.this.setKons(kons);
                    KonsDetailView.this.releaseAndRefreshLock((IPersistentObject)deselectedKons, "ch.elexis.core.ui.command.ToggleCurrentKonsultationLockCommand");
                    break;
                }
                case 4: {
                    if (kons == null || !kons.equals((Object)KonsDetailView.this.actKons)) break;
                    KonsDetailView.this.setKons(kons);
                    break;
                }
                case 32: {
                    deselectedKons = KonsDetailView.this.actKons;
                    KonsDetailView.this.setKons(null);
                    KonsDetailView.this.releaseAndRefreshLock((IPersistentObject)deselectedKons, "ch.elexis.core.ui.command.ToggleCurrentKonsultationLockCommand");
                    break;
                }
                case 4096: 
                case 16384: {
                    if (!kons.equals((Object)KonsDetailView.this.actKons)) break;
                    KonsDetailView.this.setUnlocked(ev.getType() == 4096);
                    break;
                }
            }
        }
    };

    private void releaseAndRefreshLock(IPersistentObject object, String commandId) {
        if (object != null && CoreHub.getLocalLockService().isLockedLocal(object)) {
            CoreHub.getLocalLockService().releaseLock(object);
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        commandService.refreshElements(commandId, null);
    }

    public void saveState(IMemento memento) {
        int[] w = this.sash.getWeights();
        memento.putString(CFG_VERTRELATION, String.valueOf(Integer.toString(w[0])) + "," + Integer.toString(w[1]));
        w = this.diagAndChargeSash.getWeights();
        memento.putString(CFG_HORIZRELATION, String.valueOf(Integer.toString(w[0])) + "," + Integer.toString(w[1]));
        super.saveState(memento);
    }

    @Override
    public void setUnlocked(boolean unlocked) {
        IContributionItem[] items;
        boolean hlMandantEnabled = this.actKons != null && this.actKons.isEditable(false) && CoreHub.acl.request(AccessControlDefaults.KONS_REASSIGN) && unlocked;
        this.hlMandant.setEnabled(hlMandantEnabled);
        boolean cbFallEnabled = this.actKons != null && this.actKons.isEditable(false) && unlocked;
        this.comboViewerFall.getCombo().setEnabled(cbFallEnabled);
        this.text.setEditable(unlocked);
        IToolBarManager mgr = ((IViewSite)this.getSite()).getActionBars().getToolBarManager();
        IContributionItem[] iContributionItemArray = items = mgr.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem iContributionItem = iContributionItemArray[n2];
            iContributionItem.update();
            ++n2;
        }
    }

    public void createPartControl(Composite p) {
        int[] nArray;
        int[] nArray2;
        this.setTitleImage(Images.IMG_VIEW_CONSULTATION_DETAIL.getImage());
        this.sash = new SashForm(p, 512);
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createForm((Composite)this.sash);
        this.form.getBody().setLayout((Layout)new GridLayout(1, true));
        this.form.setText(NO_CONS_SELECTED);
        this.stickerComposite = StickerComposite.createWrappedStickerComposite(this.form.getBody(), this.tk);
        this.cDesc = new Composite(this.form.getBody(), 0);
        this.cDesc.setLayout((Layout)new RowLayout(256));
        this.cDesc.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.lBeh = this.tk.createLabel(this.cDesc, NO_CONS_SELECTED);
        this.emFont = UiDesk.getFont("Helvetica", 11, 1);
        this.lBeh.setFont(this.emFont);
        this.defaultBackground = p.getBackground();
        this.hlMandant = this.tk.createHyperlink(this.cDesc, "--", 0);
        this.hlMandant.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Mandant currentMandant = ElexisEventDispatcher.getSelectedMandator();
                KontaktSelektor ksl = new KontaktSelektor(KonsDetailView.this.getSite().getShell(), Mandant.class, Messages.KonsDetailView_SelectMandatorCaption, Messages.KonsDetailView_SelectMandatorBody, new String[]{"Kuerzel", "Bezeichnung1", "Bezeichnung2"});
                if (ksl.open() == 0) {
                    KonsDetailView.this.actKons.setMandant((Mandant)ksl.getSelection());
                    KonsDetailView.this.setKons(KonsDetailView.this.actKons);
                }
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)currentMandant);
            }
        });
        this.hlMandant.setBackground(p.getBackground());
        this.comboViewerFall = new ComboViewer(this.form.getBody(), 4);
        this.comboViewerFall.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewerFall.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Fall)element).getLabel();
            }
        });
        this.comboFallSelectionListener = new ComboFallSelectionListener();
        this.comboViewerFall.addSelectionChangedListener((ISelectionChangedListener)this.comboFallSelectionListener);
        GridData gdFall = new GridData(768);
        this.comboViewerFall.getCombo().setLayoutData((Object)gdFall);
        this.text = new EnhancedTextField(this.form.getBody());
        this.hXrefs = new Hashtable();
        List xrefs = Extensions.getClasses((List)Extensions.getExtensions((String)"ch.elexis.core.ui.KonsExtension"), (String)"KonsExtension", (boolean)false);
        for (IKonsExtension x : xrefs) {
            String provider = x.connect(this.text);
            this.hXrefs.put(provider, x);
        }
        this.text.setXrefHandlers(this.hXrefs);
        List makros = Extensions.getClasses((List)Extensions.getExtensions((String)"ch.elexis.core.ui.KonsExtension"), (String)"KonsMakro", (boolean)false);
        this.text.setExternalMakros(makros);
        GridData gd = new GridData(1808);
        this.text.setLayoutData(gd);
        this.tk.adapt((Composite)this.text);
        this.diagAndChargeSash = new SashForm((Composite)this.sash, 256);
        Composite botleft = this.tk.createComposite((Composite)this.diagAndChargeSash);
        botleft.setLayout((Layout)new GridLayout(1, false));
        Composite botright = this.tk.createComposite((Composite)this.diagAndChargeSash);
        botright.setLayout((Layout)new GridLayout(1, false));
        this.dd = new DiagnosenDisplay(this.getSite().getPage(), botleft, 0);
        this.dd.setLayoutData(SWTHelper.getFillGridData(1, true, 1, true));
        this.vd = new VerrechnungsDisplay(this.getSite().getPage(), botright, 0);
        this.vd.setLayoutData(SWTHelper.getFillGridData(1, true, 1, true));
        this.getSite().registerContextMenu("ch.elexis.Konsdetail.VerrechnungsDisplay", this.vd.getMenuManager(), (ISelectionProvider)this.vd.getViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)this.vd.getViewer());
        if (this.diagAndChargeSashWeights == null) {
            int[] nArray3 = new int[2];
            nArray3[0] = 40;
            nArray2 = nArray3;
            nArray3[1] = 60;
        } else {
            nArray2 = this.diagAndChargeSashWeights;
        }
        this.diagAndChargeSash.setWeights(nArray2);
        this.makeActions();
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createMenu(new IAction[]{this.versionDisplayAction, this.versionFwdAction, this.versionBackAction, GlobalActions.neueKonsAction, GlobalActions.delKonsAction, GlobalActions.redateAction, this.assignStickerAction, this.purgeAction});
        if (this.sashWeights == null) {
            int[] nArray4 = new int[2];
            nArray4[0] = 80;
            nArray = nArray4;
            nArray4[1] = 20;
        } else {
            nArray = this.sashWeights;
        }
        this.sash.setWeights(nArray);
        menu.createToolbar(new IAction[]{GlobalActions.neueKonsAction, this.saveAction});
        GlobalEventDispatcher.addActivationListener(this, (IWorkbenchPart)this);
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_kons, this.eeli_kons_sync, this.eeli_pat, this.eeli_user, this.eeli_fall});
        this.text.connectGlobalActions(this.getViewSite());
        this.adaptMenus();
        this.setKons((Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class));
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        if (memento == null) {
            this.sashWeights = new int[]{80, 20};
            this.diagAndChargeSashWeights = new int[]{40, 60};
        } else {
            String state = memento.getString(CFG_VERTRELATION);
            if (state == null) {
                state = "80,20";
            }
            String[] sw = state.split(",");
            this.sashWeights = new int[]{Integer.parseInt(sw[0]), Integer.parseInt(sw[1])};
            state = memento.getString(CFG_HORIZRELATION);
            if (state == null) {
                state = "40,60";
            }
            sw = state.split(",");
            this.diagAndChargeSashWeights = new int[]{Integer.parseInt(sw[0]), Integer.parseInt(sw[1])};
        }
        super.init(site, memento);
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener(this, (IWorkbenchPart)this);
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_kons, this.eeli_kons_sync, this.eeli_pat, this.eeli_user, this.eeli_fall});
        this.text.disconnectGlobalActions(this.getViewSite());
        super.dispose();
    }

    private synchronized void setPatient(Patient pat) {
        if (pat != null && this.actPat != null && pat.getId().equals(this.actPat.getId()) && !this.form.getText().equals(Messages.KonsDetailView_NoConsSelected)) {
            return;
        }
        if (pat == null) {
            pat = ElexisEventDispatcher.getSelectedPatient();
        }
        this.actPat = pat;
        if (pat != null) {
            this.form.setText(String.valueOf(pat.getPersonalia()) + " " + "(" + pat.getAlter() + ")");
            this.stickerComposite.setPatient(pat);
            this.updateFallCombo();
        }
        this.form.layout();
    }

    private void updateFallCombo() {
        Patient pat = ElexisEventDispatcher.getSelectedPatient();
        if (pat != null && this.comboViewerFall != null) {
            Fall[] faelle = pat.getFaelle();
            Arrays.sort(faelle, new FallComparator());
            this.comboViewerFall.setInput((Object)faelle);
            if (this.actKons != null) {
                this.comboFallSelectionListener.ignoreSelectionEventOnce();
                this.comboViewerFall.setSelection((ISelection)new StructuredSelection((Object)this.actKons.getFall()));
            }
        }
    }

    public void setFocus() {
        this.text.setFocus();
    }

    private synchronized void setKons(Konsultation kons) {
        if (this.actKons != null && this.text.isDirty()) {
            this.actKons.updateEintrag(this.text.getContentsAsXML(), false);
        }
        if (kons != null) {
            Fall act = kons.getFall();
            this.setPatient(act.getPatient());
            this.setKonsText(kons, kons.getHeadVersion());
            this.comboFallSelectionListener.ignoreSelectionEventOnce();
            this.comboViewerFall.setSelection((ISelection)new StructuredSelection((Object)act));
            this.comboViewerFall.getCombo().setEnabled(act.isOpen());
            Mandant m = kons.getMandant();
            this.lBeh.setText(String.valueOf(kons.getDatum()) + " (" + new TimeTool(kons.getDatum()).getDurationToNowString() + ")");
            StringBuilder sb = new StringBuilder();
            if (m == null) {
                sb.append(Messages.KonsDetailView_NotYours);
                this.hlMandant.setBackground(this.hlMandant.getParent().getBackground());
            } else {
                Rechnungssteller rs = m.getRechnungssteller();
                if (rs.getId().equals(m.getId())) {
                    sb.append("(").append(m.getLabel()).append(")");
                } else {
                    sb.append("(").append(m.getLabel()).append("/").append(rs.getLabel()).append(")");
                }
                this.hlMandant.setBackground(UiMandant.getColorForMandator(m));
            }
            this.hlMandant.setText(sb.toString());
            boolean hlMandantEnabled = kons.isEditable(false) && CoreHub.acl.request(AccessControlDefaults.KONS_REASSIGN);
            this.hlMandant.setEnabled(hlMandantEnabled);
            this.dd.setEncounter(kons);
            this.vd.setEncounter(kons);
            this.vd.setEnabled(true);
            this.dd.setEnabled(true);
            if (kons.isEditable(false)) {
                this.text.setEnabled(true);
                this.text.setToolTipText("");
                this.lBeh.setForeground(UiDesk.getColor("schwarz"));
                this.lBeh.setBackground(this.defaultBackground);
            } else {
                this.text.setToolTipText("Konsultation geschlossen oder nicht von Ihnen");
                this.lBeh.setForeground(UiDesk.getColor("grau60"));
                this.lBeh.setBackground(UiDesk.getColor("grau20"));
            }
            if (this.isKonsToday(kons)) {
                this.text.setTextBackground(UiDesk.getColor("weiss"));
            } else {
                this.text.setTextBackground(UiDesk.getColorFromRGB("FAFAFA"));
            }
        } else {
            this.form.setText(NO_CONS_SELECTED);
            this.lBeh.setText("-");
            this.hlMandant.setText("--");
            this.hlMandant.setEnabled(false);
            this.hlMandant.setBackground(this.hlMandant.getParent().getBackground());
            this.dd.clear();
            this.vd.clear();
            this.text.setText("");
            this.text.setEnabled(false);
            this.vd.setEnabled(false);
            this.dd.setEnabled(false);
        }
        this.actKons = kons;
        this.cDesc.layout();
        if (this.actKons == null) {
            this.setUnlocked(false);
        } else {
            this.setUnlocked(CoreHub.getLocalLockService().isLockedLocal((IPersistentObject)this.actKons));
        }
    }

    private boolean isKonsToday(Konsultation kons) {
        TimeTool konsDate = new TimeTool(kons.getDatum());
        return konsDate.toLocalDate().isEqual(LocalDate.now());
    }

    void setKonsText(Konsultation b, int version) {
        String ntext = "";
        if (version >= 0 && version <= b.getHeadVersion()) {
            VersionedResource vr = b.getEintrag();
            VersionedResource.ResourceItem entry = vr.getVersion(version);
            ntext = entry.data;
            StringBuilder sb = new StringBuilder();
            sb.append("rev. ").append(version).append(Messages.KonsDetailView_of).append(new TimeTool(entry.timestamp).toString(0)).append(" (").append(entry.remark).append(")");
            this.versionDisplayAction.setText(sb.toString());
        } else {
            this.versionDisplayAction.setText("");
        }
        this.text.setText(ntext);
        this.text.setKons(b);
        this.displayedVersion = version;
        this.versionBackAction.setEnabled(version != 0);
        this.versionFwdAction.setEnabled(version != b.getHeadVersion());
    }

    private void makeActions() {
        this.versionDisplayAction = new Action(){
            private String versionText;

            public String getText() {
                return this.versionText;
            }

            public void setText(String text) {
                this.versionText = text;
            }

            public boolean isEnabled() {
                return false;
            }
        };
        this.purgeAction = new LockedRestrictedAction<Konsultation>(AccessControlDefaults.AC_PURGE, Messages.KonsDetailView_PurgeOldEntries){

            @Override
            public Konsultation getTargetedObject() {
                return KonsDetailView.this.actKons;
            }

            @Override
            public void doRun(Konsultation element) {
                element.purgeEintrag();
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)element);
            }
        };
        this.versionBackAction = new Action(Messages.KonsDetailView_PreviousEntry){

            public void run() {
                if (KonsDetailView.this.actKons == null) {
                    return;
                }
                if (MessageDialog.openConfirm((Shell)KonsDetailView.this.getViewSite().getShell(), (String)Messages.KonsDetailView_ReplaceKonsTextCaption, (String)Messages.KonsDetailView_ReplaceKonsTextBody)) {
                    KonsDetailView.this.setKonsText(KonsDetailView.this.actKons, KonsDetailView.this.displayedVersion - 1);
                    KonsDetailView.this.text.setDirty(true);
                }
            }
        };
        this.versionFwdAction = new Action(Messages.KonsDetailView_nextEntry){

            public void run() {
                if (KonsDetailView.this.actKons == null) {
                    return;
                }
                if (MessageDialog.openConfirm((Shell)KonsDetailView.this.getViewSite().getShell(), (String)Messages.KonsDetailView_ReplaceKonsTextCaption, (String)Messages.KonsDetailView_ReplaceKonsTextBody2)) {
                    KonsDetailView.this.setKonsText(KonsDetailView.this.actKons, KonsDetailView.this.displayedVersion + 1);
                    KonsDetailView.this.text.setDirty(true);
                }
            }
        };
        this.saveAction = new LockedAction<Konsultation>(Messages.KonsDetailView_SaveEntry){
            {
                this.setImageDescriptor(Images.IMG_DISK.getImageDescriptor());
                this.setToolTipText(Messages.KonsDetailView_SaveExplicit);
            }

            @Override
            public Konsultation getTargetedObject() {
                return KonsDetailView.this.actKons;
            }

            @Override
            public void doRun(Konsultation element) {
                KonsDetailView.this.save();
            }
        };
        this.versionFwdAction.setImageDescriptor(Images.IMG_NEXT.getImageDescriptor());
        this.versionBackAction.setImageDescriptor(Images.IMG_PREVIOUS.getImageDescriptor());
        this.purgeAction.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
        this.assignStickerAction = new Action("Sticker..."){
            {
                this.setToolTipText("Der Konsultation einer Sticker zuweisen");
            }

            public void run() {
                if (KonsDetailView.this.actKons != null) {
                    AssignStickerDialog asd = new AssignStickerDialog(KonsDetailView.this.getViewSite().getShell(), (PersistentObject)KonsDetailView.this.actKons);
                    asd.open();
                }
            }
        };
    }

    public void save() {
        if (this.actKons != null) {
            if (this.text.isDirty()) {
                this.actKons.updateEintrag(this.text.getContentsAsXML(), false);
                this.text.setDirty(false);
            }
            this.setKons(this.actKons);
        } else {
            this.log.warn("Save() actKons == null");
        }
    }

    public void adaptMenus() {
        this.vd.adaptMenus();
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void addToVerechnung(Artikel artikel) {
        this.vd.addPersistentObject((PersistentObject)artikel);
    }

    @Override
    public void activation(boolean mode) {
        if (!mode) {
            if (this.actKons != null && this.text.isDirty()) {
                this.actKons.updateEintrag(this.text.getContentsAsXML(), false);
                this.text.setDirty(false);
            }
        } else if (this.actKons != null && !this.text.isDirty()) {
            this.setKonsText(this.actKons, this.actKons.getHeadVersion());
        }
    }

    @Override
    public void visible(boolean mode) {
        if (mode) {
            this.adaptMenus();
        }
    }

    private class ComboFallSelectionListener
    implements ISelectionChangedListener {
        private boolean ignoreEventSelectionChanged;

        private ComboFallSelectionListener() {
        }

        public void ignoreSelectionEventOnce() {
            this.ignoreEventSelectionChanged = true;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection;
            if (!this.ignoreEventSelectionChanged && (selection = event.getSelection()) instanceof StructuredSelection && !selection.isEmpty()) {
                Fall nFall = (Fall)((StructuredSelection)selection).getFirstElement();
                Fall actFall = null;
                String fallId = "";
                String fallLabel = "Current Case NOT found!!";
                if (KonsDetailView.this.actKons != null) {
                    actFall = KonsDetailView.this.actKons.getFall();
                    fallId = actFall.getId();
                    fallLabel = actFall.getLabel();
                }
                if (!nFall.getId().equals(fallId)) {
                    if (!nFall.isOpen()) {
                        SWTHelper.alert(Messages.KonsDetailView_CaseClosedCaption, Messages.KonsDetailView_CaseClosedBody);
                    } else {
                        MessageDialog msd = new MessageDialog(KonsDetailView.this.getViewSite().getShell(), Messages.KonsDetailView_ChangeCaseCaption, Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize), MessageFormat.format(Messages.KonsDetailView_ConfirmChangeConsToCase, fallLabel, nFall.getLabel()), 3, new String[]{Messages.KonsDetailView_Yes, Messages.KonsDetailView_No}, 0);
                        if (msd.open() == 0) {
                            KonsDetailView.this.actKons.transferToFall(nFall, false, false);
                        } else {
                            this.ignoreSelectionEventOnce();
                            KonsDetailView.this.comboViewerFall.setSelection((ISelection)new StructuredSelection((Object)actFall));
                        }
                    }
                }
            }
            this.ignoreEventSelectionChanged = false;
        }
    }
}

