/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.BackgroundJob;
import ch.elexis.core.ui.actions.HistoryLoader;
import ch.elexis.core.ui.actions.KonsFilter;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.controls.PagingComposite;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import java.util.ArrayList;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public class HistoryDisplay
extends Composite
implements BackgroundJob.BackgroundJobListener,
ElexisEventListener {
    FormText text;
    ArrayList<Konsultation> lKons;
    private HistoryLoader loader;
    private final ScrolledComposite scrolledComposite;
    boolean multiline = false;
    private static final int PAGING_FETCHSIZE = 20;
    private PagingComposite pagingComposite;
    private Patient actPatient;
    private final ElexisEvent eetemplate = new ElexisEvent(null, null, 64);

    public HistoryDisplay(Composite parent, IViewSite site) {
        this(parent, site, false);
    }

    public HistoryDisplay(Composite parent, IViewSite site, boolean multiline) {
        super(parent, 0);
        this.setLayout((Layout)SWTHelper.createGridLayout(true, 1));
        this.setLayoutData(new GridData(0x1000000, 128, true, true));
        this.pagingComposite = new PagingComposite(this, 0){

            @Override
            public void runPaging() {
                HistoryDisplay.this.start();
            }
        };
        this.scrolledComposite = new ScrolledComposite((Composite)this, 2560);
        this.scrolledComposite.setLayout((Layout)SWTHelper.createGridLayout(true, 1));
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.multiline = multiline;
        this.lKons = new ArrayList(20);
        this.text = UiDesk.getToolkit().createFormText((Composite)this.scrolledComposite, false);
        this.text.setWhitespaceNormalized(true);
        this.text.setColor("blau", UiDesk.getColorRegistry().get("blau"));
        this.text.setColor("gruen", UiDesk.getColorRegistry().get("hellgrau"));
        this.text.setColor("dunkelgrau", UiDesk.getColorRegistry().get("dunkelgrau"));
        this.text.setFont(UiDesk.getFont("anwender/stdfont"));
        this.scrolledComposite.setContent((Control)this.text);
        this.text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String id = (String)e.getHref();
                Konsultation k = Konsultation.load((String)id);
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)k);
            }
        });
        this.text.setText(Messages.HistoryDisplay_NoPatientSelected, false, false);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                HistoryDisplay.this.text.setSize(HistoryDisplay.this.text.computeSize(((HistoryDisplay)HistoryDisplay.this).scrolledComposite.getSize().x - 15, -1));
            }
        });
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this});
    }

    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this});
        this.scrolledComposite.dispose();
    }

    public void setFilter(KonsFilter f) {
        this.stop();
        this.loader.setFilter(f);
    }

    public void start() {
        this.start(null);
    }

    public void start(KonsFilter f) {
        this.stop();
        if (f == null) {
            this.loader = new HistoryLoader(new StringBuilder(), this.lKons, this.multiline, this.pagingComposite.getCurrentPage(), this.pagingComposite.getFetchSize());
        } else {
            this.pagingComposite.reset();
            this.loader = new HistoryLoader(new StringBuilder(), this.lKons, this.multiline);
        }
        this.loader.setFilter(f);
        this.loader.addListener(this);
        this.loader.schedule();
    }

    public void stop() {
        if (this.loader != null) {
            this.loader.removeListener(this);
            this.loader.cancel();
        }
    }

    public void load(Fall fall, boolean clear) {
        if (clear) {
            this.lKons.clear();
        }
        if (fall != null) {
            Konsultation[] kons;
            Konsultation[] konsultationArray = kons = fall.getBehandlungen(true);
            int n = kons.length;
            int n2 = 0;
            while (n2 < n) {
                Konsultation k = konsultationArray[n2];
                this.lKons.add(k);
                ++n2;
            }
        }
    }

    public void load(Patient pat, @Nullable ElexisEvent ev) {
        int page = 1;
        if (this.actPatient != null && this.actPatient.equals((Object)pat)) {
            page = this.pagingComposite.getCurrentPage();
        }
        if (ev == null || ev.getObject() instanceof Patient) {
            UiDesk.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!HistoryDisplay.this.isDisposed()) {
                        HistoryDisplay.this.scrolledComposite.setOrigin(0, 0);
                        if (HistoryDisplay.this.lKons.size() > 0) {
                            HistoryDisplay.this.text.setText("wird geladen...", false, false);
                            HistoryDisplay.this.text.setSize(HistoryDisplay.this.text.computeSize(((HistoryDisplay)HistoryDisplay.this).scrolledComposite.getSize().x - 10, -1));
                        }
                    }
                }
            });
        }
        if (pat != null) {
            Fall[] faelle;
            this.lKons.clear();
            Fall[] fallArray = faelle = pat.getFaelle();
            int n = faelle.length;
            int n2 = 0;
            while (n2 < n) {
                Fall f = fallArray[n2];
                this.load(f, false);
                ++n2;
            }
            this.pagingComposite.setup(page, this.lKons.size(), 20);
        }
        this.actPatient = pat;
    }

    @Override
    public void jobFinished(BackgroundJob j) {
        UiDesk.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                String s = (String)HistoryDisplay.this.loader.getData();
                if (!HistoryDisplay.this.isDisposed()) {
                    if (s != null) {
                        int idxFrom = s.indexOf("<form>");
                        int idxTo = s.indexOf("</form>");
                        if (idxFrom != -1 && idxTo != -1) {
                            s = s.substring(idxFrom + 6, s.indexOf("</form>"));
                            HistoryDisplay.this.text.setText("<form>" + this.getDateFromToText() + s + "</form>", true, true);
                        }
                    } else {
                        HistoryDisplay.this.text.setText(ElexisEventDispatcher.getSelectedPatient() != null ? "" : Messages.HistoryDisplay_NoPatientSelected, false, false);
                    }
                    HistoryDisplay.this.text.setSize(HistoryDisplay.this.text.computeSize(((HistoryDisplay)HistoryDisplay.this).scrolledComposite.getSize().x - 10, -1));
                }
            }

            public String getDateFromToText() {
                if (HistoryDisplay.this.loader.getlKons() != null && HistoryDisplay.this.loader.getlKons().size() > 0) {
                    Konsultation firstKons = HistoryDisplay.this.loader.getlKons().get(HistoryDisplay.this.loader.getlKons().size() - 1);
                    Konsultation lastKons = HistoryDisplay.this.loader.getlKons().get(0);
                    String fromDate = firstKons != null ? firstKons.getDatum() : "-";
                    String toDate = lastKons != null ? lastKons.getDatum() : "-";
                    return "<p><span color=\"dunkelgrau\">von " + fromDate + " bis " + toDate + "</span></p>";
                }
                return "";
            }
        });
    }

    public void catchElexisEvent(ElexisEvent ev) {
        UiDesk.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (HistoryDisplay.this.text != null && !HistoryDisplay.this.text.isDisposed()) {
                    HistoryDisplay.this.text.setFont(UiDesk.getFont("anwender/stdfont"));
                }
            }
        });
    }

    public ElexisEvent getElexisEventFilter() {
        return this.eetemplate;
    }
}

