/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.actions.Messages;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.PersistentObjectDragSource;
import ch.elexis.data.Leistungsblock;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.VerrechenbarFavorites;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class FavoritenComposite
extends Composite {
    private TableViewer tv;
    private Transfer[] types = new Transfer[]{TextTransfer.getInstance()};

    public FavoritenComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        CLabel lblHeader = new CLabel((Composite)this, 0);
        lblHeader.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblHeader.setText("Favoriten");
        lblHeader.setImage(Images.IMG_STAR.getImage(ImageSize._75x66_TitleDialogIconSize));
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcl_composite = new TableColumnLayout();
        composite.setLayout((Layout)tcl_composite);
        this.tv = new TableViewer(composite, 67584);
        final Table table = this.tv.getTable();
        table.setHeaderVisible(true);
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                int clientWidth = table.getClientArea().width;
                event.height = event.gc.getFontMetrics().getHeight() * 2 + 2;
                event.width = clientWidth * 2;
            }
        });
        table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                VerrechenbarFavorites.Favorite fav = (VerrechenbarFavorites.Favorite)item.getData();
                IPersistentObject cfs = fav.getPersistentObject();
                String simpleName = "?";
                String label = "?";
                if (cfs != null) {
                    simpleName = cfs.getClass().getSimpleName();
                    label = cfs.getLabel();
                }
                int yOffset = 0;
                Font defaultFont = event.gc.getFont();
                FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)defaultFont).setStyle(1);
                Font boldFont = boldDescriptor.createFont((Device)event.display);
                switch (event.index) {
                    case 0: {
                        event.gc.setFont(defaultFont);
                        event.gc.drawText(fav.getMacroString(), event.x + 3, event.y + yOffset, true);
                        break;
                    }
                    case 1: {
                        event.gc.setFont(boldFont);
                        event.gc.drawText(simpleName, event.x + 3, event.y + yOffset, true);
                        event.gc.setFont(defaultFont);
                        event.gc.drawText(label, event.x + 3, event.y + event.gc.getFontMetrics().getHeight(), true);
                        break;
                    }
                }
            }
        });
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection ss;
                ICodeSelectorTarget target = CodeSelectorHandler.getInstance().getCodeSelectorTarget();
                if (target != null && !(ss = (StructuredSelection)FavoritenComposite.this.tv.getSelection()).isEmpty()) {
                    VerrechenbarFavorites.Favorite fav = (VerrechenbarFavorites.Favorite)ss.getFirstElement();
                    IPersistentObject po = fav.getPersistentObject();
                    if (po instanceof Leistungsblock) {
                        Leistungsblock lb = (Leistungsblock)po;
                        for (ICodeElement iCodeElement : lb.getElements()) {
                            target.codeSelected((PersistentObject)iCodeElement);
                        }
                    } else {
                        target.codeSelected((PersistentObject)po);
                    }
                }
            }
        });
        TableViewerColumn tvcMacro = new TableViewerColumn(this.tv, 0);
        TableColumn tblclmnMakro = tvcMacro.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnMakro, (ColumnLayoutData)new ColumnPixelData(50, true, true));
        tblclmnMakro.setText("Makro");
        tvcMacro.setEditingSupport(new EditingSupport(tvcMacro.getViewer(), table){
            TextCellEditor editor;
            {
                this.editor = new TextCellEditor((Composite)table);
            }

            protected void setValue(Object element, Object value) {
                VerrechenbarFavorites.Favorite fav = (VerrechenbarFavorites.Favorite)element;
                fav.setMacroString((String)value);
                VerrechenbarFavorites.storeFavorites();
            }

            protected Object getValue(Object element) {
                VerrechenbarFavorites.Favorite fav = (VerrechenbarFavorites.Favorite)element;
                return fav.getMacroString();
            }

            protected CellEditor getCellEditor(Object element) {
                return this.editor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        TableViewerColumn tvcElement = new TableViewerColumn(this.tv, 0);
        TableColumn tblclmnNewColumn = tvcElement.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnNewColumn, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        tblclmnNewColumn.setText("Element");
        MenuManager mgr = new MenuManager();
        mgr.add((IAction)new Action(){
            {
                this.setText(Messages.ToggleVerrechenbarFavoriteAction_DeFavorize);
            }

            public void run() {
                StructuredSelection selection = (StructuredSelection)FavoritenComposite.this.tv.getSelection();
                VerrechenbarFavorites.Favorite fav = (VerrechenbarFavorites.Favorite)selection.getFirstElement();
                VerrechenbarFavorites.setFavorite((IPersistentObject)fav.getPersistentObject(), (boolean)false);
                FavoritenComposite.this.tv.refresh();
            }
        });
        Menu menu = mgr.createContextMenu(this.tv.getControl());
        table.setMenu(menu);
        DragSource mine = new DragSource(this.tv.getControl(), 1);
        mine.setTransfer(this.types);
        mine.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                StructuredSelection ss = (StructuredSelection)FavoritenComposite.this.tv.getSelection();
                if (ss.isEmpty()) {
                    event.data = null;
                } else {
                    VerrechenbarFavorites.Favorite fav = (VerrechenbarFavorites.Favorite)ss.getFirstElement();
                    if (fav.getPersistentObject() instanceof Leistungsblock) {
                        Leistungsblock lb = (Leistungsblock)fav.getPersistentObject();
                        if (lb != null) {
                            event.data = lb.storeToString();
                        }
                    } else {
                        event.data = fav.getStoreToString();
                    }
                }
            }

            public void dragStart(DragSourceEvent event) {
                StructuredSelection ss = (StructuredSelection)FavoritenComposite.this.tv.getSelection();
                if (ss.isEmpty()) {
                    PersistentObjectDragSource.setDraggedObject(null);
                    event.doit = false;
                } else {
                    VerrechenbarFavorites.Favorite fav = (VerrechenbarFavorites.Favorite)ss.getFirstElement();
                    if (fav.getPersistentObject() instanceof Leistungsblock) {
                        Leistungsblock lb = (Leistungsblock)fav.getPersistentObject();
                        PersistentObjectDragSource.setDraggedObject((PersistentObject)lb);
                    } else {
                        PersistentObjectDragSource.setDraggedObject((PersistentObject)fav.getPersistentObject());
                    }
                    event.doit = true;
                }
            }
        });
        this.tv.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tv.setLabelProvider((IBaseLabelProvider)new ColorizedLabelProvider());
        this.tv.setInput((Object)VerrechenbarFavorites.getFavorites());
    }

    protected void checkSubclass() {
    }

    public void update() {
        if (this.tv != null) {
            this.tv.setInput((Object)VerrechenbarFavorites.getFavorites());
        }
    }

    private class ColorizedLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ColorizedLabelProvider() {
        }

        public String getText(Object element) {
            return "";
        }

        public Color getBackground(Object element) {
            VerrechenbarFavorites.Favorite fav = (VerrechenbarFavorites.Favorite)element;
            ICodeElement v = (ICodeElement)fav.getPersistentObject();
            if (v == null) {
                return null;
            }
            String codeSystemName = v.getCodeSystemName();
            if (codeSystemName == null) {
                return null;
            }
            String rgbColor = CoreHub.globalCfg.get("billing/color/" + codeSystemName, "ffffff");
            return UiDesk.getColorFromRGB(rgbColor);
        }

        public Color getForeground(Object element) {
            return null;
        }
    }
}

