/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.ObjectFilterRegistry;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.FallDetailView;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.provider.FaelleContentProvider;
import ch.elexis.core.ui.views.provider.FaelleLabelProvider;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.rgw.tools.ExHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class FaelleView
extends ViewPart
implements IRefreshable {
    public static final String ID = "ch.elexis.schoebufaelle";
    TableViewer tv;
    ViewMenus menus;
    private IAction konsFilterAction;
    private IAction filterClosedAction;
    private final FallKonsFilter filter = new FallKonsFilter();
    private Patient actPatient;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this);
    private final ElexisUiEventListenerImpl eeli_pat = new ElexisUiEventListenerImpl(Patient.class){

        @Override
        public void runInUi(ElexisEvent ev) {
            if (this.isActiveControl(FaelleView.this.tv.getControl()) && FaelleView.this.actPatient != ev.getObject()) {
                FaelleView.this.actPatient = (Patient)ev.getObject();
                FaelleView.this.tv.refresh();
                Fall currentFall = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
                if (currentFall != null) {
                    FaelleView.this.tv.setSelection((ISelection)new StructuredSelection((Object)currentFall));
                }
            }
        }
    };
    private final ElexisUiEventListenerImpl eeli_fall = new ElexisUiEventListenerImpl(Fall.class, 31){

        @Override
        public void runInUi(ElexisEvent ev) {
            if (this.isActiveControl(FaelleView.this.tv.getControl())) {
                if (ev.getType() == 16) {
                    FaelleView.this.tv.refresh(true);
                    Fall currentFall = (Fall)ev.getObject();
                    if (currentFall != null) {
                        FaelleView.this.tv.setSelection((ISelection)new StructuredSelection((Object)currentFall));
                    }
                    if (FaelleView.this.konsFilterAction.isChecked()) {
                        FaelleView.this.filter.setFall((Fall)ev.getObject());
                    }
                } else {
                    FaelleView.this.tv.refresh(true);
                }
            }
        }
    };

    public FaelleView() {
        this.makeActions();
    }

    public void createPartControl(Composite parent) {
        this.setPartName(Messages.FaelleView_partName);
        parent.setLayout((Layout)new GridLayout());
        this.tv = new TableViewer(parent);
        this.tv.getControl().setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.tv.setContentProvider((IContentProvider)new FaelleContentProvider());
        this.tv.setLabelProvider((IBaseLabelProvider)new FaelleLabelProvider());
        this.tv.addSelectionChangedListener((ISelectionChangedListener)GlobalEventDispatcher.getInstance().getDefaultListener());
        this.menus = new ViewMenus(this.getViewSite());
        this.menus.createToolbar(GlobalActions.neuerFallAction, this.konsFilterAction, this.filterClosedAction);
        this.menus.createViewerContextMenu((StructuredViewer)this.tv, new IAction[]{GlobalActions.openFallaction, GlobalActions.closeFallAction, null, GlobalActions.delFallAction, GlobalActions.reopenFallAction, GlobalActions.makeBillAction});
        this.tv.setInput((Object)this.getViewSite());
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                try {
                    FallDetailView fallDetailView = (FallDetailView)FaelleView.this.getSite().getPage().showView("ch.elexis.FallDetailView");
                }
                catch (PartInitException e) {
                    ExHandler.handle((Throwable)e);
                }
            }
        });
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_fall, this.eeli_pat});
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_fall, this.eeli_pat});
        super.dispose();
    }

    public void setFocus() {
        this.tv.getControl().setFocus();
        this.refresh();
    }

    @Override
    public void refresh() {
        this.eeli_pat.catchElexisEvent(ElexisEvent.createPatientEvent());
    }

    private void makeActions() {
        this.konsFilterAction = new Action(Messages.FaelleView_FilterConsultations, 2){
            {
                this.setToolTipText(Messages.FaelleView_ShowOnlyConsOfThisCase);
                this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
            }

            public void run() {
                if (!this.isChecked()) {
                    ObjectFilterRegistry.getInstance().unregisterObjectFilter(Konsultation.class, FaelleView.this.filter);
                } else {
                    ObjectFilterRegistry.getInstance().registerObjectFilter(Konsultation.class, FaelleView.this.filter);
                    FaelleView.this.filter.setFall((Fall)ElexisEventDispatcher.getSelected(Fall.class));
                }
            }
        };
        this.filterClosedAction = new Action("", 2){
            private ViewerFilter closedFilter;
            {
                this.setToolTipText(Messages.FaelleView_ShowOnlyOpenCase);
                this.setImageDescriptor(Images.IMG_DOCUMENT_WRITE.getImageDescriptor());
                this.closedFilter = new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (element instanceof Fall) {
                            Fall fall = (Fall)element;
                            return fall.isOpen();
                        }
                        return false;
                    }
                };
            }

            public void run() {
                if (!this.isChecked()) {
                    FaelleView.this.tv.removeFilter(this.closedFilter);
                } else {
                    FaelleView.this.tv.addFilter(this.closedFilter);
                }
            }
        };
    }

    class FallKonsFilter
    implements ObjectFilterRegistry.IObjectFilterProvider,
    IFilter {
        Fall mine;
        boolean bDaempfung;

        FallKonsFilter() {
        }

        void setFall(Fall fall) {
            this.mine = fall;
            ElexisEventDispatcher.reload(Konsultation.class);
        }

        @Override
        public void activate() {
            this.bDaempfung = true;
            FaelleView.this.konsFilterAction.setChecked(true);
            this.bDaempfung = false;
        }

        @Override
        public void changed() {
        }

        @Override
        public void deactivate() {
            this.bDaempfung = true;
            FaelleView.this.konsFilterAction.setChecked(false);
            this.bDaempfung = false;
        }

        @Override
        public IFilter getFilter() {
            return this;
        }

        @Override
        public String getId() {
            return "ch.elexis.FallFilter";
        }

        public boolean select(Object toTest) {
            Konsultation k;
            if (this.mine == null) {
                return true;
            }
            return toTest instanceof Konsultation && (k = (Konsultation)toTest).getFall().equals((Object)this.mine);
        }
    }
}

