/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.dialogs.DailyOrderDialog;
import ch.elexis.core.ui.dialogs.NeueBestellungDialog;
import ch.elexis.core.ui.dialogs.OrderImportDialog;
import ch.elexis.core.ui.dialogs.SelectBestellungDialog;
import ch.elexis.core.ui.editors.KontaktSelektorDialogCellEditor;
import ch.elexis.core.ui.editors.PersistentObjectEditingSupport;
import ch.elexis.core.ui.exchange.IDataSender;
import ch.elexis.core.ui.exchange.XChangeException;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.TableViewerSorter;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.BestellBlatt;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Artikel;
import ch.elexis.data.Bestellung;
import ch.elexis.data.BestellungEntry;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Stock;
import ch.elexis.data.StockEntry;
import ch.rgw.tools.ExHandler;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.LoggerFactory;

public class BestellView
extends ViewPart
implements ISaveablePart2 {
    public static final String ID = "ch.elexis.BestellenView";
    private Form form;
    private FormToolkit tk = UiDesk.getToolkit();
    private TableViewer tv;
    private Bestellung actBestellung;
    private ViewMenus viewmenus;
    private IAction removeAction;
    private IAction dailyWizardAction;
    private IAction wizardAction;
    private IAction loadAction;
    private IAction printAction;
    private IAction sendAction;
    private IAction newAction;
    private IAction exportClipboardAction;
    private IAction checkInAction;
    private BestellungLabelProvider blp;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.form = this.tk.createForm(parent);
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        Table table = new Table(body, 66050);
        table.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        this.tv = new TableViewer(table);
        TableViewerColumn tvcNumber = new TableViewerColumn(this.tv, 0x1000000);
        tvcNumber.getColumn().setText(Messages.BestellView_Number);
        tvcNumber.getColumn().setWidth(40);
        PersistentObjectEditingSupport poes = new PersistentObjectEditingSupport(this.tv, "COUNT");
        tvcNumber.setEditingSupport((EditingSupport)poes);
        TableViewerColumn tvcArticle = new TableViewerColumn(this.tv, 16384);
        tvcArticle.getColumn().setText(Messages.BestellView_Article);
        tvcArticle.getColumn().setWidth(280);
        TableViewerColumn tvcDealer = new TableViewerColumn(this.tv, 16384);
        tvcDealer.getColumn().setText(Messages.BestellView_Dealer);
        tvcDealer.getColumn().setWidth(250);
        tvcDealer.setEditingSupport(new EditingSupport((ColumnViewer)this.tv){

            protected void setValue(Object element, Object value) {
                BestellungEntry se = (BestellungEntry)element;
                if (se == null) {
                    return;
                }
                se.setProvider((Kontakt)value);
                this.getViewer().refresh();
            }

            protected Object getValue(Object element) {
                BestellungEntry se = (BestellungEntry)element;
                if (se == null) {
                    return null;
                }
                return se.getProvider();
            }

            protected CellEditor getCellEditor(Object element) {
                return new KontaktSelektorDialogCellEditor((Composite)((TableViewer)this.getViewer()).getTable(), "Lieferant ausw\u00e4hlen", "Bitte selektieren Sie den Lieferant");
            }

            protected boolean canEdit(Object element) {
                BestellungEntry be = (BestellungEntry)element;
                return be != null;
            }
        });
        TableViewerColumn tvc3 = new TableViewerColumn(this.tv, 16384);
        tvc3.getColumn().setText("Lager");
        tvc3.getColumn().setWidth(50);
        this.tv.setContentProvider((IContentProvider)new BestellungContentProvider());
        this.blp = new BestellungLabelProvider();
        this.tv.setLabelProvider((IBaseLabelProvider)this.blp);
        new TableViewerSorter(this.tv);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        this.tv.addDropSupport(1, types, (DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void drop(DropTargetEvent event) {
                String drp = (String)event.data;
                String[] dl = drp.split(",");
                if (BestellView.this.actBestellung == null) {
                    NeueBestellungDialog nbDlg = new NeueBestellungDialog(BestellView.this.getViewSite().getShell(), Messages.BestellView_CreateNewOrder, Messages.BestellView_EnterOrderTitle);
                    if (nbDlg.open() == 0) {
                        BestellView.this.setBestellung(new Bestellung(nbDlg.getTitle(), CoreHub.actUser));
                    } else {
                        return;
                    }
                }
                ArrayList<StockEntry> stockEntriesToOrder = new ArrayList<StockEntry>();
                String[] stringArray = dl;
                int n = dl.length;
                int n2 = 0;
                while (n2 < n) {
                    String obj = stringArray[n2];
                    PersistentObject dropped = CoreHub.poFactory.createFromString(obj);
                    if (dropped instanceof StockEntry) {
                        stockEntriesToOrder.add((StockEntry)dropped);
                    } else if (dropped instanceof Artikel) {
                        IStockEntry se;
                        Artikel art = (Artikel)dropped;
                        if (art.isProduct()) {
                            return;
                        }
                        if (CoreHub.getStockService() != null && (se = CoreHub.getStockService().findPreferredStockEntryForArticle(obj, null)) != null) {
                            stockEntriesToOrder.add((StockEntry)se);
                        } else {
                            BestellView.this.actBestellung.addBestellungEntry((Artikel)dropped, null, null, 1);
                        }
                    }
                    ++n2;
                }
                for (StockEntry se : stockEntriesToOrder) {
                    BestellView.this.actBestellung.addBestellungEntry(se.getArticle(), se.getStock(), se.getProvider(), 1);
                }
                BestellView.this.tv.refresh();
            }
        });
        this.makeActions();
        this.viewmenus = new ViewMenus(this.getViewSite());
        this.viewmenus.createToolbar(this.newAction, this.dailyWizardAction, this.wizardAction, this.loadAction, this.printAction, this.sendAction);
        this.viewmenus.createMenu(this.newAction, this.dailyWizardAction, this.wizardAction, this.loadAction, this.printAction, this.sendAction, this.exportClipboardAction);
        this.viewmenus.createViewerContextMenu((StructuredViewer)this.tv, this.removeAction);
        this.form.getToolBarManager().add(this.checkInAction);
        this.form.updateToolBar();
        this.setBestellung(null);
        this.tv.setInput((Object)this.getViewSite());
    }

    private void setBestellung(Bestellung b) {
        this.actBestellung = b;
        if (b != null && !this.form.isDisposed()) {
            this.form.setText(b.getLabel());
            this.tv.refresh();
            this.updateCheckIn();
        } else {
            this.checkInAction.setEnabled(false);
            this.checkInAction.setToolTipText(Messages.BestellView_NoOrder);
        }
    }

    private void updateCheckIn() {
        if (this.actBestellung.isDone()) {
            this.checkInAction.setEnabled(false);
            this.checkInAction.setToolTipText(Messages.BestellView_OrderIsClosed);
        } else {
            this.checkInAction.setEnabled(true);
            this.checkInAction.setToolTipText(Messages.BestellView_CheckInCaption);
        }
    }

    public void setFocus() {
    }

    private List<BestellungEntry> prepareOrderList(Kontakt receiver) {
        ArrayList<BestellungEntry> best = new ArrayList<BestellungEntry>();
        List list = this.actBestellung.getEntries();
        for (BestellungEntry bestellungEntry : list) {
            if (receiver == null && !(receiver = bestellungEntry.getProvider()).exists()) {
                receiver = null;
                continue;
            }
            if (bestellungEntry.getProvider() == null || !bestellungEntry.getProvider().getId().equals(receiver.getId())) continue;
            best.add(bestellungEntry);
        }
        best.sort((left, right) -> {
            String s1 = left.getArticle().getName();
            String s2 = right.getArticle().getName();
            return s1.compareTo(s2);
        });
        return best;
    }

    private void makeActions() {
        this.removeAction = new Action(Messages.BestellView_RemoveArticle){

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)BestellView.this.tv.getSelection();
                if (sel != null && !sel.isEmpty() && BestellView.this.actBestellung != null) {
                    List selections = sel.toList();
                    for (BestellungEntry entry : selections) {
                        BestellView.this.actBestellung.removeEntry(entry);
                    }
                    BestellView.this.tv.refresh();
                }
            }
        };
        this.dailyWizardAction = new Action(Messages.BestellView_AutomaticDailyOrder){
            {
                this.setToolTipText(Messages.BestellView_CreateAutomaticDailyOrder);
                this.setImageDescriptor(Images.IMG_WIZ_DAY.getImageDescriptor());
            }

            public void run() {
                if (BestellView.this.actBestellung == null) {
                    BestellView.this.setBestellung(new Bestellung(Messages.BestellView_AutomaticDaily, CoreHub.actUser));
                } else if (!BestellView.this.actBestellung.getTime().toLocalDate().equals(LocalDate.now()) && MessageDialog.openQuestion((Shell)BestellView.this.getSite().getShell(), (String)Messages.BestellView_Title, (String)Messages.BestellView_WizardAskNewOrder)) {
                    BestellView.this.setBestellung(new Bestellung(Messages.BestellView_Automatic, CoreHub.actUser));
                }
                DailyOrderDialog doDlg = new DailyOrderDialog(UiDesk.getTopShell(), BestellView.this.actBestellung);
                doDlg.open();
                BestellView.this.updateCheckIn();
                BestellView.this.tv.refresh(true);
            }
        };
        this.wizardAction = new Action(Messages.BestellView_AutomaticOrder){
            {
                this.setToolTipText(Messages.BestellView_CreateAutomaticOrder);
                this.setImageDescriptor(Images.IMG_WIZARD.getImageDescriptor());
            }

            public void run() {
                if (BestellView.this.actBestellung == null) {
                    BestellView.this.setBestellung(new Bestellung(Messages.BestellView_Automatic, CoreHub.actUser));
                } else if (!BestellView.this.actBestellung.getTime().toLocalDate().equals(LocalDate.now()) && MessageDialog.openQuestion((Shell)BestellView.this.getSite().getShell(), (String)Messages.BestellView_Title, (String)Messages.BestellView_WizardAskNewOrder)) {
                    BestellView.this.setBestellung(new Bestellung(Messages.BestellView_Automatic, CoreHub.actUser));
                }
                int trigger = CoreHub.globalCfg.get("inventory/order_trigger", 0);
                boolean isInventoryBelow = trigger == 0;
                boolean excludeAlreadyOrderedItems = CoreHub.globalCfg.get("inventory/order_exclude_already_ordered_items", false);
                Query qbe = new Query(StockEntry.class, null, null, "STOCK_ENTRY", new String[]{"CURRENT", "MAX"});
                qbe.add("CURRENT", isInventoryBelow ? "<" : "<=", "MIN");
                List stockEntries = qbe.execute();
                for (StockEntry se : stockEntries) {
                    if (se.getArticle() != null) {
                        IOrderEntry open;
                        if (excludeAlreadyOrderedItems && (open = CoreHub.getOrderService().findOpenOrderEntryForStockEntry((IStockEntry)se)) != null) continue;
                        CoreHub.getOrderService().addRefillForStockEntryToOrder((IStockEntry)se, (IOrder)BestellView.this.actBestellung);
                        continue;
                    }
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Could not resolve article " + se.get("ARTICLE_TYPE") + se.get("ARTICLE_ID") + " of stock entry " + se.getId());
                }
                BestellView.this.updateCheckIn();
                BestellView.this.tv.refresh(true);
            }
        };
        this.newAction = new Action(Messages.BestellView_CreateNewOrder){

            public void run() {
                NeueBestellungDialog nbDlg = new NeueBestellungDialog(BestellView.this.getViewSite().getShell(), Messages.BestellView_CreateNewOrder, Messages.BestellView_EnterOrderTitle);
                if (nbDlg.open() != 0) {
                    return;
                }
                BestellView.this.setBestellung(new Bestellung(nbDlg.getTitle(), CoreHub.actUser));
                BestellView.this.tv.refresh();
            }
        };
        this.printAction = new Action(Messages.BestellView_PrintOrder){

            public void run() {
                if (BestellView.this.actBestellung != null) {
                    Kontakt receiver = null;
                    List best = BestellView.this.prepareOrderList(receiver);
                    try {
                        BestellBlatt bb = (BestellBlatt)BestellView.this.getViewSite().getPage().showView("ch.elexis.BestellBlatt");
                        bb.createOrder(receiver, best);
                        BestellView.this.tv.refresh();
                        Bestellung.markAsOrdered((List)best);
                    }
                    catch (PartInitException e) {
                        ExHandler.handle((Throwable)e);
                    }
                }
            }
        };
        this.sendAction = new Action(Messages.BestellView_SendOrder){

            public void run() {
                if (BestellView.this.actBestellung == null) {
                    return;
                }
                ArrayList<BestellungEntry> orderableItems = new ArrayList<BestellungEntry>();
                ArrayList<BestellungEntry> noSupplierItems = new ArrayList<BestellungEntry>();
                for (BestellungEntry item : BestellView.this.actBestellung.getEntries()) {
                    Kontakt supplier = item.getProvider();
                    if (supplier != null && supplier.exists()) {
                        orderableItems.add(item);
                        continue;
                    }
                    noSupplierItems.add(item);
                }
                boolean runOrder = true;
                if (!noSupplierItems.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (BestellungEntry noSupItem : noSupplierItems) {
                        sb.append(noSupItem.getArticle().getLabel());
                        sb.append("\n");
                    }
                    runOrder = SWTHelper.askYesNo(Messages.BestellView_NoSupplierArticle, MessageFormat.format(Messages.BestellView_NoSupplierArticleMsg, sb.toString()));
                }
                if (runOrder) {
                    List list = Extensions.getExtensions((String)"ch.elexis.core.ui.Transporter");
                    for (IConfigurationElement ic : list) {
                        String handler = ic.getAttribute("type");
                        if (handler == null || !handler.contains(Bestellung.class.getName())) continue;
                        try {
                            IDataSender sender = (IDataSender)ic.createExecutableExtension("ExporterClass");
                            sender.store(BestellView.this.actBestellung);
                            sender.finalizeExport();
                            SWTHelper.showInfo(Messages.BestellView_OrderSentCaption, Messages.BestellView_OrderSentBody);
                            BestellView.this.tv.refresh();
                            Bestellung.markAsOrdered(orderableItems);
                        }
                        catch (CoreException ex) {
                            ExHandler.handle((Throwable)ex);
                        }
                        catch (XChangeException xx) {
                            SWTHelper.showError(Messages.BestellView_OrderNotPossible, String.valueOf(Messages.BestellView_NoAutomaticOrderAvailable) + xx.getLocalizedMessage());
                        }
                    }
                }
            }
        };
        this.loadAction = new Action(Messages.BestellView_OpenOrder){

            public void run() {
                SelectBestellungDialog dlg = new SelectBestellungDialog(BestellView.this.getViewSite().getShell());
                dlg.setMessage(Messages.BestellView_SelectOrder);
                dlg.setTitle(Messages.BestellView_ReadOrder);
                if (dlg.open() == 0 && dlg.getResult().length > 0) {
                    Bestellung res = (Bestellung)dlg.getResult()[0];
                    BestellView.this.setBestellung(res);
                }
            }
        };
        this.printAction.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
        this.printAction.setToolTipText(Messages.BestellView_PrintOrder);
        this.newAction.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
        this.newAction.setToolTipText(Messages.BestellView_CreateNewOrder);
        this.sendAction.setImageDescriptor(Images.IMG_NETWORK.getImageDescriptor());
        this.sendAction.setToolTipText(Messages.BestellView_transmitOrder);
        this.loadAction.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
        this.loadAction.setToolTipText(Messages.BestellView_loadEarlierOrder);
        this.exportClipboardAction = new Action(Messages.BestellView_copyToClipboard){
            {
                this.setToolTipText(Messages.BestellView_copyToClipBioardForGalexis);
            }

            public void run() {
                if (BestellView.this.actBestellung != null) {
                    Kontakt receiver = null;
                    List best = BestellView.this.prepareOrderList(receiver);
                    StringBuffer export = new StringBuffer();
                    for (BestellungEntry item : best) {
                        String pharmaCode = item.getArticle().getPharmaCode();
                        int num = item.getCount();
                        String name = item.getArticle().getName();
                        String line = String.valueOf(pharmaCode) + ", " + num + ", " + name;
                        export.append(line);
                        export.append(System.getProperty("line.separator"));
                    }
                    String clipboardText = export.toString();
                    Clipboard clipboard = new Clipboard(UiDesk.getDisplay());
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    Transfer[] transfers = new Transfer[]{textTransfer};
                    Object[] data = new Object[]{clipboardText};
                    clipboard.setContents(data, transfers);
                    clipboard.dispose();
                }
            }
        };
        this.checkInAction = new Action(Messages.BestellView_CheckInCaption){
            {
                this.setImageDescriptor(Images.IMG_TICK.getImageDescriptor());
                this.setToolTipText(Messages.BestellView_CheckInBody);
            }

            public void run() {
                if (BestellView.this.actBestellung != null && BestellView.this.actBestellung.exists()) {
                    OrderImportDialog dialog = new OrderImportDialog(BestellView.this.getSite().getShell(), (IOrder)BestellView.this.actBestellung);
                    dialog.open();
                    BestellView.this.updateCheckIn();
                } else {
                    SWTHelper.alert(Messages.BestellView_NoOrder, Messages.BestellView_NoOrderLoaded);
                }
            }
        };
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void addItemsToOrder(List<Artikel> articlesToOrder) {
        if (this.actBestellung == null) {
            NeueBestellungDialog nbDlg = new NeueBestellungDialog(this.getViewSite().getShell(), Messages.BestellView_CreateNewOrder, Messages.BestellView_EnterOrderTitle);
            if (nbDlg.open() == 0) {
                this.setBestellung(new Bestellung(nbDlg.getTitle(), CoreHub.actUser));
            } else {
                return;
            }
        }
        for (Artikel arti : articlesToOrder) {
            this.actBestellung.addBestellungEntry(arti, null, null, 1);
        }
        if (this.tv != null && !this.tv.getControl().isDisposed()) {
            this.tv.refresh();
        }
    }

    public Bestellung getActBestellung() {
        return this.actBestellung;
    }

    public static Kontakt resolveDefaultSupplier(String cfgSupplier, String selDialogTitle) {
        Kontakt supplier = null;
        if (cfgSupplier != null && !cfgSupplier.isEmpty()) {
            supplier = Kontakt.load((String)cfgSupplier);
        }
        if (supplier == null || !supplier.exists()) {
            MessageDialog.openWarning((Shell)UiDesk.getTopShell(), (String)selDialogTitle, (String)Messages.BestellView_CantOrderNoSupplier);
        }
        return supplier;
    }

    private class BestellungContentProvider
    implements IStructuredContentProvider,
    TableViewerSorter.IColumnContentProvider {
        private BestellungContentProvider() {
        }

        @Override
        public Comparable<?> getValue(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((BestellungEntry)element).getCount();
            }
            return BestellView.this.blp.getColumnText(element, columnIndex);
        }

        public Object[] getElements(Object inputElement) {
            if (BestellView.this.actBestellung != null) {
                return BestellView.this.actBestellung.getEntries().toArray();
            }
            return new Object[0];
        }
    }

    private class BestellungLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private BestellungLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            BestellungEntry be = (BestellungEntry)element;
            switch (columnIndex) {
                case 0: {
                    return Integer.toString(be.getCount());
                }
                case 1: {
                    return be.getArticle().getLabel();
                }
                case 2: {
                    Kontakt k = be.getProvider();
                    return k != null ? k.getLabel() : Messages.BestellView_Unknown;
                }
                case 3: {
                    Stock s = be.getStock();
                    return s != null ? s.getCode() : "";
                }
            }
            return "?";
        }
    }
}

