/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.BestellungEntry;
import ch.elexis.data.Brief;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Person;
import ch.rgw.tools.Money;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.ViewPart;

public class BestellBlatt
extends ViewPart
implements ITextPlugin.ICallback {
    public static final String ID = "ch.elexis.BestellBlatt";
    TextContainer text;
    Brief actBest;
    private static final String ERRMSG_CAPTION = Messages.BestellBlatt_CouldNotCreateOrder;
    private static final String ERRMSG_BODY = Messages.BestellBlatt_CouldNotCreateOrderBody;

    public void createPartControl(Composite parent) {
        this.setTitleImage(Images.IMG_PRINTER.getImage());
        this.text = new TextContainer(this.getViewSite());
        this.text.getPlugin().createContainer(parent, this);
    }

    public void createOrder(Kontakt adressat, List<BestellungEntry> bestellungEntries) {
        String[][] tbl = new String[bestellungEntries.size() + 2][];
        int i = 1;
        Money sum = new Money();
        tbl[0] = new String[]{Messages.BestellBlatt_Number, Messages.BestellBlatt_Pharmacode, Messages.BestellBlatt_Name, Messages.BestellBlatt_UnitPrice, Messages.BestellBlatt_LinePrice};
        for (BestellungEntry be : bestellungEntries) {
            String[] row = new String[5];
            row[0] = Integer.toString(be.getCount());
            row[1] = be.getArticle().getPharmaCode();
            row[2] = be.getArticle().getName();
            row[3] = be.getArticle().getEKPreis().getAmountAsString();
            Money amount = be.getArticle().getEKPreis().multiply((double)be.getCount());
            row[4] = amount.getAmountAsString();
            sum.addMoney(amount);
            tbl[i++] = row;
        }
        tbl[i] = new String[]{Messages.BestellBlatt_Sum, "", "", "", sum.getAmountAsString()};
        this.actBest = this.text.createFromTemplateName(null, "Bestellung", "Bestellung", adressat, null);
        if (this.actBest == null) {
            SWTHelper.showError(ERRMSG_CAPTION, String.valueOf(ERRMSG_BODY) + "'" + "Bestellung" + "'");
        } else {
            this.actBest.setPatient((Person)CoreHub.actUser);
            this.text.getPlugin().insertTable("[Bestellung]", 3, tbl, null);
            if (this.text.getPlugin().isDirectOutput()) {
                this.text.getPlugin().print(null, null, true);
                this.getSite().getPage().hideView((IViewPart)this);
            }
        }
    }

    public void setFocus() {
    }

    @Override
    public void save() {
        if (this.actBest != null) {
            this.actBest.save(this.text.getPlugin().storeToByteArray(), this.text.getPlugin().getMimeType());
        }
    }

    @Override
    public boolean saveAs() {
        return false;
    }
}

