/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.dialogs.EditAUFDialog;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.views.AUFZeugnis;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.AUF;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class AUF2
extends ViewPart
implements IActivationListener {
    public static final String ID = "ch.elexis.auf";
    TableViewer tv;
    private Action newAUF;
    private Action delAUF;
    private Action modAUF;
    private Action printAUF;
    private ElexisEventListener eli_auf = new ElexisUiEventListenerImpl(AUF.class){

        @Override
        public void runInUi(ElexisEvent ev) {
            boolean bSelect = ev.getType() == 16;
            AUF2.this.modAUF.setEnabled(bSelect);
            AUF2.this.delAUF.setEnabled(bSelect);
        }
    };
    private ElexisEventListener eli_pat = new ElexisUiEventListenerImpl(Patient.class){

        @Override
        public void runInUi(ElexisEvent ev) {
            if (ev.getType() == 16) {
                AUF2.this.tv.refresh();
                ElexisEventDispatcher.clearSelection(AUF.class);
                AUF2.this.newAUF.setEnabled(true);
            } else {
                AUF2.this.newAUF.setEnabled(false);
                AUF2.this.modAUF.setEnabled(false);
                AUF2.this.delAUF.setEnabled(false);
            }
        }
    };

    public AUF2() {
        this.setTitleImage(Images.IMG_VIEW_WORK_INCAPABLE.getImage());
    }

    public void createPartControl(Composite parent) {
        this.setPartName(Messages.AUF2_certificate);
        this.tv = new TableViewer(parent);
        this.tv.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider());
        this.tv.setContentProvider((IContentProvider)new AUFContentProvider());
        this.makeActions();
        ViewMenus menus = new ViewMenus(this.getViewSite());
        menus.createMenu(new IAction[]{this.newAUF, this.delAUF, this.modAUF, this.printAUF});
        menus.createToolbar(new IAction[]{this.newAUF, this.delAUF, this.printAUF});
        this.tv.setUseHashlookup(true);
        GlobalEventDispatcher.addActivationListener(this, (IWorkbenchPart)this);
        this.tv.addSelectionChangedListener((ISelectionChangedListener)GlobalEventDispatcher.getInstance().getDefaultListener());
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AUF2.this.modAUF.run();
            }
        });
        this.tv.setInput((Object)this.getViewSite());
        Transfer[] dragTransferTypes = new Transfer[]{TextTransfer.getInstance()};
        this.tv.addDragSupport(1, dragTransferTypes, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)AUF2.this.tv.getSelection();
                StringBuilder sb = new StringBuilder();
                if (selection != null && !selection.isEmpty()) {
                    AUF auf = (AUF)selection.getFirstElement();
                    sb.append(auf.storeToString()).append(",");
                }
                event.data = sb.toString().replace(",$", "");
            }
        });
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener(this, (IWorkbenchPart)this);
    }

    public void setFocus() {
    }

    private void makeActions() {
        this.newAUF = new Action(Messages.AUF2_new){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText(Messages.AUF2_createNewCert);
            }

            public void run() {
                Patient pat = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
                if (pat == null) {
                    SWTHelper.showError(Messages.AUF2_NoPatientSelected, Messages.AUF2_PleaseDoSelectPatient);
                    return;
                }
                Konsultation kons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
                Fall fall = null;
                if (kons != null) {
                    fall = kons.getFall();
                    if (fall == null) {
                        SWTHelper.showError(Messages.AUF2_noCaseSelected, Messages.AUF2_selectCase);
                        return;
                    }
                    if (!fall.getPatient().equals((Object)pat)) {
                        kons = null;
                    }
                }
                if (kons == null) {
                    kons = pat.getLetzteKons(false);
                    if (kons == null) {
                        SWTHelper.showError(Messages.AUF2_noCaseSelected, Messages.AUF2_selectCase);
                        return;
                    }
                    fall = kons.getFall();
                }
                new EditAUFDialog(AUF2.this.getViewSite().getShell(), null, fall).open();
                AUF2.this.tv.refresh(false);
            }
        };
        this.delAUF = new Action(Messages.AUF2_delete){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.AUF2_deleteCertificate);
            }

            public void run() {
                AUF sel = AUF2.this.getSelectedAUF();
                if (sel != null && MessageDialog.openConfirm((Shell)AUF2.this.getViewSite().getShell(), (String)Messages.AUF2_deleteReally, (String)Messages.AUF2_doyoywantdeletereally)) {
                    sel.delete();
                    AUF2.this.tv.refresh(false);
                }
            }
        };
        this.modAUF = new Action(Messages.AUF2_edit){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.AUF2_editCertificate);
            }

            public void run() {
                AUF sel = AUF2.this.getSelectedAUF();
                if (sel != null) {
                    new EditAUFDialog(AUF2.this.getViewSite().getShell(), sel, sel.getFall()).open();
                    AUF2.this.tv.refresh(true);
                }
            }
        };
        this.printAUF = new Action(Messages.AUF2_print){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText(Messages.AUF2_createPrint);
            }

            public void run() {
                try {
                    AUFZeugnis az = (AUFZeugnis)AUF2.this.getViewSite().getPage().showView("ch.elexis.AUFView");
                    AUF actAUF = (AUF)ElexisEventDispatcher.getSelected(AUF.class);
                    az.createAUZ(actAUF);
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        };
    }

    private AUF getSelectedAUF() {
        IStructuredSelection sel = (IStructuredSelection)this.tv.getSelection();
        if (sel == null || sel.isEmpty()) {
            return null;
        }
        return (AUF)sel.getFirstElement();
    }

    @Override
    public void activation(boolean mode) {
    }

    @Override
    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eli_auf, this.eli_pat});
            this.eli_pat.catchElexisEvent(new ElexisEvent(ElexisEventDispatcher.getSelected(Patient.class), null, 16));
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eli_auf, this.eli_pat});
        }
    }

    class AUFContentProvider
    implements IStructuredContentProvider {
        AUFContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Patient pat = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
            if (pat == null) {
                return new Object[0];
            }
            Query qbe = new Query(AUF.class);
            qbe.add("PatientID", "=", pat.getId());
            qbe.orderBy(true, new String[]{"von", "bis"});
            List list = qbe.execute();
            return list.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

