/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util.viewers;

import ch.elexis.admin.ACE;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.actions.AbstractDataLoaderJob;
import ch.elexis.core.ui.actions.BackgroundJob;
import ch.elexis.core.ui.actions.JobPool;
import ch.elexis.core.ui.util.Messages;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import java.util.HashMap;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class LazyContentProvider
implements ViewerConfigurer.ICommonViewerContentProvider,
ILazyContentProvider,
BackgroundJob.BackgroundJobListener,
AbstractDataLoaderJob.FilterProvider {
    AbstractDataLoaderJob dataloader;
    CommonViewer tableviewer;
    ACE required;

    public LazyContentProvider(CommonViewer viewer, AbstractDataLoaderJob job, ACE rights) {
        this.dataloader = job;
        job.addListener(this);
        job.addFilterProvider(this);
        this.tableviewer = viewer;
        this.required = rights;
    }

    public void dispose() {
        this.dataloader.removeListener(this);
        this.dataloader.removeFilterProvider(this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void updateElement(int index) {
        if (!CoreHub.acl.request(this.required)) {
            ((TableViewer)this.tableviewer.getViewerWidget()).replace((Object)" --- ", index);
            return;
        }
        if (this.dataloader.isValid()) {
            Object[] res = (Object[])this.dataloader.getData();
            Object nval = Messages.LazyContentProvider_noData;
            if (index < res.length) {
                nval = res[index];
            }
            ((TableViewer)this.tableviewer.getViewerWidget()).replace(nval, index);
        } else {
            JobPool pool = JobPool.getJobPool();
            if (pool.getJob(this.dataloader.getJobname()) == null) {
                pool.addJob(this.dataloader);
            }
            pool.activate(this.dataloader.getJobname(), 20);
        }
    }

    @Override
    public void jobFinished(BackgroundJob j) {
        int size = 0;
        if (j != null && j.getData() != null) {
            size = ((Object[])j.getData()).length;
        }
        ((TableViewer)this.tableviewer.getViewerWidget()).getTable().setItemCount(size == 0 ? 1 : size);
        this.tableviewer.notify(CommonViewer.Message.update);
    }

    @Override
    public void startListening() {
        this.tableviewer.getConfigurer().controlFieldProvider.addChangeListener(this);
    }

    @Override
    public void stopListening() {
        this.tableviewer.getConfigurer().controlFieldProvider.removeChangeListener(this);
    }

    @Override
    public void applyFilter() {
        ViewerConfigurer vc;
        Query qbe = this.dataloader.getQuery();
        if (qbe != null && (vc = this.tableviewer.getConfigurer()) != null) {
            ViewerConfigurer.ControlFieldProvider cfp = vc.getControlFieldProvider();
            cfp.setQuery((Query<? extends PersistentObject>)qbe);
        }
    }

    @Override
    public void changed(HashMap<String, String> vals) {
        this.dataloader.invalidate();
        if (this.tableviewer.getConfigurer().getControlFieldProvider().isEmpty()) {
            this.tableviewer.notify(CommonViewer.Message.empty);
        } else {
            this.tableviewer.notify(CommonViewer.Message.notempty);
        }
        JobPool.getJobPool().activate(this.dataloader.getJobname(), 20);
    }

    @Override
    public void reorder(String field) {
        this.dataloader.setOrder(field);
        this.changed(null);
    }

    @Override
    public void selected() {
    }

    public Object[] getElements(Object inputElement) {
        return (Object[])this.dataloader.getData();
    }

    @Override
    public void init() {
    }
}

