/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util.viewers;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.text.ElexisText;
import ch.elexis.core.ui.util.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.Tree;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class DefaultControlFieldProvider
implements ViewerConfigurer.ControlFieldProvider {
    protected String[] dbFields;
    protected String[] fields;
    protected String[] lastFiltered;
    protected ElexisText[] selectors;
    protected final ModListener ml;
    protected final SelListener sl;
    protected boolean modified;
    protected final List<ViewerConfigurer.ControlFieldListener> listeners;
    private final FormToolkit tk;
    protected CommonViewer myViewer;
    protected int focusField;
    boolean bCeaseFire;
    private Composite inner;

    public DefaultControlFieldProvider(CommonViewer viewer, String[] flds) {
        this.myViewer = viewer;
        this.updateFields(flds, false);
        this.ml = new ModListener();
        this.sl = new SelListener();
        this.listeners = new LinkedList<ViewerConfigurer.ControlFieldListener>();
        this.tk = UiDesk.getToolkit();
    }

    public void updateFields(String[] flds, boolean redraw) {
        this.fields = new String[flds.length];
        this.dbFields = new String[this.fields.length];
        this.focusField = 0;
        this.lastFiltered = new String[this.fields.length];
        int i = 0;
        while (i < flds.length) {
            this.lastFiltered[i] = "";
            if (flds[i].indexOf(61) != -1) {
                String[] s = flds[i].split("=");
                this.fields[i] = s[1];
                this.dbFields[i] = s[0];
            } else {
                this.fields[i] = this.dbFields[i] = flds[i];
            }
            ++i;
        }
        if (redraw) {
            Control[] children;
            this.inner.setRedraw(false);
            Control[] controlArray = children = this.inner.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            GridLayout lRet = new GridLayout(this.fields.length, true);
            this.inner.setLayout((Layout)lRet);
            this.populateInnerComposite();
            this.inner.setRedraw(true);
        }
    }

    private String getDbFieldForField(String text) {
        if (this.fields != null) {
            int i = 0;
            while (i < this.fields.length) {
                if (this.fields[i] != null && this.fields[i].equals(text) && this.dbFields.length >= i && this.dbFields[i] != null) {
                    return this.dbFields[i];
                }
                ++i;
            }
        }
        return text;
    }

    private void populateInnerComposite() {
        String[] stringArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            String l = stringArray[n2];
            Hyperlink hl = this.tk.createHyperlink(this.inner, l, 0);
            hl.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    Hyperlink h = (Hyperlink)e.getSource();
                    String dbField = DefaultControlFieldProvider.this.getDbFieldForField(h.getText());
                    DefaultControlFieldProvider.this.fireSortEvent(dbField);
                }
            });
            hl.setBackground(this.inner.getBackground());
            ++n2;
        }
        this.createSelectors(this.fields.length);
        int i = 0;
        while (i < this.selectors.length) {
            this.selectors[i] = new ElexisText(this.tk.createText(this.inner, "", 2048));
            this.selectors[i].addModifyListener(this.ml);
            this.selectors[i].addSelectionListener(this.sl);
            this.selectors[i].setToolTipText(Messages.DefaultControlFieldProvider_enterFilter);
            this.selectors[i].setLayoutData(SWTHelper.getFillGridData(1, true, 1, false));
            SWTHelper.setSelectOnFocus((Text)this.selectors[i].getWidget());
            ++i;
        }
    }

    @Override
    public Composite createControl(Composite parent) {
        Composite ret = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        ret.setLayout((Layout)layout);
        ret.setBackground(parent.getBackground());
        ImageHyperlink hClr = this.tk.createImageHyperlink(ret, 0);
        hClr.setImage(Images.IMG_CLEAR.getImage());
        hClr.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DefaultControlFieldProvider.this.clearValues();
            }
        });
        hClr.setBackground(parent.getBackground());
        this.inner = new Composite(ret, 0);
        GridLayout lRet = new GridLayout(this.fields.length, true);
        this.inner.setLayout((Layout)lRet);
        this.inner.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.populateInnerComposite();
        return ret;
    }

    protected void createSelectors(int length) {
        this.selectors = new ElexisText[this.fields.length];
    }

    public void setFocusField(int index) {
        if (index >= this.fields.length) {
            throw new IndexOutOfBoundsException("Invalid field index");
        }
        this.focusField = index;
    }

    public void setFocusField(String name) {
        int i = 0;
        while (i < this.dbFields.length) {
            if (this.dbFields[i].equals(name)) {
                this.focusField = i;
            }
            ++i;
        }
    }

    @Override
    public void setFocus() {
        this.selectors[this.focusField].setFocus();
    }

    public boolean isModified() {
        return this.modified;
    }

    public String[] getDBFields() {
        return this.dbFields;
    }

    @Override
    public void fireChangedEvent() {
        if (!this.bCeaseFire) {
            UiDesk.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    HashMap<String, String> hm = new HashMap<String, String>();
                    int i = 0;
                    while (i < DefaultControlFieldProvider.this.dbFields.length) {
                        hm.put(DefaultControlFieldProvider.this.dbFields[i], DefaultControlFieldProvider.this.lastFiltered[i]);
                        ++i;
                    }
                    for (ViewerConfigurer.ControlFieldListener lis : DefaultControlFieldProvider.this.listeners) {
                        lis.changed(hm);
                    }
                }
            });
        }
    }

    @Override
    public void fireSortEvent(String text) {
        if (!this.bCeaseFire) {
            for (ViewerConfigurer.ControlFieldListener ls : this.listeners) {
                ls.reorder(text);
            }
        }
    }

    public void fireSelectedEvent() {
        if (!this.bCeaseFire) {
            for (ViewerConfigurer.ControlFieldListener ls : this.listeners) {
                ls.selected();
            }
        }
    }

    @Override
    public void addChangeListener(ViewerConfigurer.ControlFieldListener cl) {
        this.listeners.add(cl);
    }

    @Override
    public void removeChangeListener(ViewerConfigurer.ControlFieldListener cl) {
        this.listeners.remove(cl);
    }

    @Override
    public String[] getValues() {
        return this.lastFiltered;
    }

    public Composite getParent() {
        return this.inner;
    }

    @Override
    public void clearValues() {
        this.myViewer.getViewerWidget().setSelection(null);
        if (!this.isEmpty()) {
            this.bCeaseFire = true;
            int i = 0;
            while (i < this.selectors.length) {
                this.selectors[i].setText("");
                this.lastFiltered[i] = "";
                ++i;
            }
            this.modified = false;
            this.bCeaseFire = false;
            this.fireChangedEvent();
        }
    }

    public void setValue(int index, String value) {
        if (index > this.lastFiltered.length) {
            return;
        }
        this.bCeaseFire = true;
        this.selectors[index].setText(value);
        this.lastFiltered[index] = value;
        this.modified = true;
        this.bCeaseFire = false;
    }

    public void setQuery(Query q) {
        boolean ch = false;
        int i = 0;
        while (i < this.dbFields.length) {
            if (!this.lastFiltered[i].equals("")) {
                q.add(this.dbFields[i], "LIKE", String.valueOf(this.lastFiltered[i]) + "%", true);
                q.and();
                ch = true;
            }
            ++i;
        }
        if (ch) {
            q.insertTrue();
        }
    }

    @Override
    public IFilter createFilter() {
        return new DefaultFilter();
    }

    @Override
    public boolean isEmpty() {
        String[] stringArray = this.lastFiltered;
        int n = this.lastFiltered.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!s.equals("")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void ceaseFire(boolean bCeaseFire) {
        this.bCeaseFire = bCeaseFire;
    }

    public CommonViewer getCommonViewer() {
        return this.myViewer;
    }

    private class DefaultFilter
    extends ViewerFilter
    implements IFilter {
        private DefaultFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return this.select(element);
        }

        public boolean select(Object element) {
            PersistentObject po = null;
            if (element instanceof Tree) {
                po = (PersistentObject)((Tree)element).contents;
            } else if (element instanceof PersistentObject) {
                po = (PersistentObject)element;
            } else {
                return false;
            }
            if (po.isMatching(DefaultControlFieldProvider.this.dbFields, 1, DefaultControlFieldProvider.this.lastFiltered)) {
                return true;
            }
            if (element instanceof Tree) {
                Tree p = ((Tree)element).getParent();
                if (p == null) {
                    return false;
                }
                return this.select(p);
            }
            return false;
        }
    }

    class ModListener
    implements ModifyListener {
        ModListener() {
        }

        public void modifyText(ModifyEvent e) {
            DefaultControlFieldProvider.this.modified = true;
            Text t = (Text)e.getSource();
            String s = t.getText();
            if (!"".equals(s) && s.length() == 1) {
                return;
            }
            int i = 0;
            while (i < DefaultControlFieldProvider.this.lastFiltered.length) {
                DefaultControlFieldProvider.this.lastFiltered[i] = DefaultControlFieldProvider.this.selectors[i].getText();
                ++i;
            }
            DefaultControlFieldProvider.this.fireChangedEvent();
        }
    }

    class SelListener
    implements SelectionListener {
        SelListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            DefaultControlFieldProvider.this.fireSelectedEvent();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

