/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util.viewers;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.PersistentObjectDragSource;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.Tree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;

public class CommonViewer
implements ISelectionChangedListener,
IDoubleClickListener {
    protected ViewerConfigurer vc;
    protected StructuredViewer viewer;
    protected Button bNew;
    private IAction createObjectAction;
    private Composite parent;
    private ISelectionChangedListener selChangeListener;
    private HashSet<DoubleClickListener> dlListeners;
    private MenuManager mgr;
    private Composite composite;
    private String viewName = "unknown";

    public Composite getParent() {
        return this.parent;
    }

    public void setViewName(String s) {
        this.viewName = s;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setObjectCreateAction(IViewSite site, IAction action) {
        site.getActionBars().getToolBarManager().add(action);
        action.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
        this.createObjectAction = action;
    }

    public void create(ViewerConfigurer c, Composite parent, int style, Object input) {
        ViewerConfigurer.ControlFieldProvider cfp;
        this.vc = c;
        this.parent = parent;
        Composite ret = new Composite(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        ret.setLayout((Layout)layout);
        if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData(1808);
            ret.setLayoutData((Object)gd);
        }
        if ((cfp = this.vc.getControlFieldProvider()) != null) {
            ret.setData("TEST_COMP_NAME", (Object)("cv_ret_" + this.viewName));
            Composite ctlf = this.vc.getControlFieldProvider().createControl(ret);
            ctlf.setData("TEST_COMP_NAME", (Object)("cv_ctlf_" + this.viewName));
            ctlf.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        }
        this.viewer = this.vc.getWidgetProvider().createViewer(ret);
        GridData gdView = new GridData(1808);
        gdView.verticalAlignment = 4;
        this.viewer.setUseHashlookup(true);
        this.viewer.getControl().setLayoutData((Object)gdView);
        this.viewer.setContentProvider((IContentProvider)this.vc.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.vc.getLabelProvider());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.vc.getDoubleClickListener() != null) {
            this.viewer.addDoubleClickListener(this.vc.getDoubleClickListener());
        }
        this.bNew = this.vc.getButtonProvider().createButton(ret);
        if (this.bNew != null) {
            if (this.viewName != null) {
                this.bNew.setData("TEST_COMP_NAME", (Object)("cv_bNew_" + this.viewName + "_btn"));
            }
            GridData gdNew = new GridData(768);
            this.bNew.setLayoutData((Object)gdNew);
            if (!this.vc.getButtonProvider().isAlwaysEnabled()) {
                this.bNew.setEnabled(false);
            }
        }
        if (c.iSelectionRenderer != null) {
            new PersistentObjectDragSource(this.viewer.getControl(), c.iSelectionRenderer);
        } else {
            new PersistentObjectDragSource(this.viewer.getControl(), new PersistentObjectDragSource.ISelectionRenderer(){

                @Override
                public List<PersistentObject> getSelection() {
                    Object[] sel = CommonViewer.this.getSelection();
                    ArrayList<PersistentObject> ret = new ArrayList<PersistentObject>(sel.length);
                    Object[] objectArray = sel;
                    int n = sel.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object b;
                        Object o = objectArray[n2];
                        if (o instanceof PersistentObject) {
                            ret.add((PersistentObject)o);
                        } else if (o instanceof Tree && (b = ((Tree)o).contents) instanceof PersistentObject) {
                            ret.add((PersistentObject)b);
                        }
                        ++n2;
                    }
                    return ret;
                }
            });
        }
        if (this.mgr != null) {
            this.viewer.getControl().setMenu(this.mgr.createContextMenu(this.viewer.getControl()));
        }
        this.vc.getContentProvider().init();
        this.viewer.setInput(input);
        this.viewer.getControl().pack();
        this.composite = ret;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public Object[] getSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        if (sel != null) {
            return sel.toArray();
        }
        return null;
    }

    public void setSelection(Object o, boolean fireEvents) {
        if (!fireEvents) {
            this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.viewer.setSelection((ISelection)new StructuredSelection(o), true);
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            this.viewer.setSelection((ISelection)new StructuredSelection(o), true);
        }
    }

    public StructuredViewer getViewerWidget() {
        return this.viewer;
    }

    public Object getViewerWidgetFirstSelection() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (selection == null || selection.size() == 0) {
            return null;
        }
        return selection.getFirstElement();
    }

    public ViewerConfigurer getConfigurer() {
        return this.vc;
    }

    public void notify(Message m) {
        this.notify(m, null);
    }

    public void notify(final Message m, final Object object) {
        if (this.viewer == null || this.viewer.getControl() == null || this.viewer.getControl().isDisposed()) {
            return;
        }
        UiDesk.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                switch (m) {
                    case update: {
                        if (CommonViewer.this.viewer.getControl().isDisposed()) break;
                        CommonViewer.this.viewer.refresh(true);
                        break;
                    }
                    case updateSingle: {
                        if (CommonViewer.this.viewer.getControl().isDisposed() || object == null) break;
                        CommonViewer.this.viewer.refresh(object, true);
                        break;
                    }
                    case update_keeplabels: {
                        if (CommonViewer.this.viewer.getControl().isDisposed()) break;
                        CommonViewer.this.viewer.refresh(false);
                        break;
                    }
                    case empty: {
                        if (CommonViewer.this.bNew != null && !CommonViewer.this.vc.getButtonProvider().isAlwaysEnabled()) {
                            CommonViewer.this.bNew.setEnabled(false);
                        }
                        if (CommonViewer.this.createObjectAction == null) break;
                        CommonViewer.this.createObjectAction.setEnabled(false);
                        break;
                    }
                    case notempty: {
                        if (CommonViewer.this.bNew != null) {
                            CommonViewer.this.bNew.setEnabled(true);
                        }
                        if (CommonViewer.this.createObjectAction == null) break;
                        CommonViewer.this.createObjectAction.setEnabled(true);
                    }
                }
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object[] sel = this.getSelection();
        if (sel != null && sel.length != 0) {
            if (sel[0] instanceof Tree) {
                sel[0] = ((Tree)sel[0]).contents;
            }
            if (sel[0] instanceof PersistentObject) {
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((PersistentObject)sel[0]));
            }
        }
        if (this.selChangeListener != null) {
            this.selChangeListener.selectionChanged(event);
        }
    }

    public void dispose() {
        if (this.vc.getDoubleClickListener() != null) {
            this.viewer.removeDoubleClickListener(this.vc.getDoubleClickListener());
        }
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void addDoubleClickListener(DoubleClickListener dl) {
        if (this.dlListeners == null) {
            this.dlListeners = new HashSet();
            this.getViewerWidget().addDoubleClickListener((IDoubleClickListener)this);
        }
        this.dlListeners.add(dl);
    }

    public void setSelectionChangedListener(@Nullable ISelectionChangedListener selChangeListener) {
        this.selChangeListener = selChangeListener;
    }

    public void removeDoubleClickListener(DoubleClickListener dl) {
        if (this.dlListeners == null) {
            return;
        }
        this.dlListeners.remove(dl);
        if (this.dlListeners.isEmpty()) {
            this.getViewerWidget().removeDoubleClickListener((IDoubleClickListener)this);
            this.dlListeners = null;
        }
    }

    public void setContextMenu(MenuManager mgr) {
        this.mgr = mgr;
        if (this.viewer != null) {
            this.viewer.getControl().setMenu(mgr.createContextMenu(this.viewer.getControl()));
        }
    }

    public Button getButton() {
        return this.bNew;
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.dlListeners != null) {
            for (DoubleClickListener dl : this.dlListeners) {
                if (this.vc.iSelectionRenderer != null) {
                    List<PersistentObject> selected = this.vc.iSelectionRenderer.getSelection();
                    if (selected.isEmpty()) continue;
                    dl.doubleClicked(selected.get(0), this);
                    continue;
                }
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel == null || sel.isEmpty()) continue;
                Object element = sel.getFirstElement();
                if (element instanceof Tree) {
                    element = ((Tree)element).contents;
                }
                if (!(element instanceof PersistentObject)) continue;
                dl.doubleClicked((PersistentObject)element, this);
            }
        }
    }

    public MenuManager getMgr() {
        return this.mgr;
    }

    public static interface DoubleClickListener {
        public void doubleClicked(PersistentObject var1, CommonViewer var2);
    }

    public static enum Message {
        update,
        empty,
        notempty,
        update_keeplabels,
        updateSingle;

    }
}

