/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class NatTableCustomCellPainter
extends TextPainter {
    BackgroundPainter bgPainter = new BackgroundPainter();

    public void paintCell(ILayerCell cell, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        if (this.paintBg) {
            this.bgPainter.paintCell(cell, gc, rectangle, configRegistry);
        }
        if (this.paintFg) {
            String[] lines;
            Rectangle originalClipping = gc.getClipping();
            gc.setClipping(rectangle.intersection(originalClipping));
            IStyle cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
            this.setupGCFromConfig(gc, cellStyle);
            int fontHeight = gc.getFontMetrics().getHeight();
            String text = this.convertDataType(cell, configRegistry);
            text = this.getTextToDisplay(cell, gc, rectangle.width, text);
            int numberOfNewLines = this.getNumberOfNewLines(text);
            int contentHeight = fontHeight * numberOfNewLines + this.spacing * 2;
            int contentToCellDiff = cell.getBounds().height - rectangle.height;
            if (this.performRowResize(contentHeight, rectangle)) {
                ILayer layer = cell.getLayer();
                layer.doCommand((ILayerCommand)new RowResizeCommand(layer, cell.getRowPosition(), contentHeight + contentToCellDiff));
            }
            int yStartPos = rectangle.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)rectangle, (int)contentHeight);
            String[] stringArray = lines = text.split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                int lineContentWidth = Math.min(this.getLengthFromCache(gc, line), rectangle.width);
                this.drawLine(gc, yStartPos, rectangle.x + CellStyleUtil.getHorizontalAlignmentPadding((IStyle)cellStyle, (Rectangle)rectangle, (int)lineContentWidth) + this.spacing, line);
                yStartPos += fontHeight;
                ++n2;
            }
            gc.setClipping(originalClipping);
        }
    }

    private void drawLine(GC gc, int yStartPos, int xStartPos, String line) {
        List<TextPart> textParts = this.getTextParts(line);
        for (TextPart textPart : textParts) {
            xStartPos = this.drawTextPart(gc, yStartPos, xStartPos, textPart);
        }
    }

    private List<TextPart> getTextParts(String line) {
        ArrayList<TextPart> ret = new ArrayList<TextPart>();
        String[] parts = null;
        if (line.contains("</strong>")) {
            parts = line.split("</strong>");
        }
        if (line.contains("</ strong>")) {
            parts = line.split("</ strong>");
        }
        if (parts != null && parts.length > 0) {
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.startsWith("<strong>")) {
                    string = string.replaceAll("<strong>", "");
                    ret.add(new TextPart(string, TextPart.PartStyle.BOLD));
                } else {
                    ret.add(new TextPart(string, TextPart.PartStyle.NORMAL));
                }
                ++n2;
            }
        } else {
            ret.add(new TextPart(line, TextPart.PartStyle.NORMAL));
        }
        return ret;
    }

    private int drawTextPart(GC gc, int yStartPos, int xStartPos, TextPart text) {
        Point textExtent = new Point(0, 0);
        if (text.getStyle() == TextPart.PartStyle.NORMAL) {
            textExtent = gc.stringExtent(text.getText());
            gc.drawText(text.getText(), xStartPos, yStartPos + this.spacing, 3);
        } else if (text.getStyle() == TextPart.PartStyle.BOLD) {
            Font origFont = gc.getFont();
            FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)gc.getFont()).setStyle(1);
            Font boldFont = boldDescriptor.createFont((Device)Display.getDefault());
            gc.setFont(boldFont);
            textExtent = gc.stringExtent(text.getText());
            gc.drawText(text.getText(), xStartPos, yStartPos + this.spacing, 3);
            gc.setFont(origFont);
            boldFont.dispose();
        }
        return xStartPos + textExtent.x;
    }

    private static class TextPart {
        private PartStyle style;
        private String text;

        public TextPart(String text, PartStyle style) {
            this.text = text;
            this.style = style;
        }

        public PartStyle getStyle() {
            return this.style;
        }

        public String getText() {
            return this.text;
        }

        static enum PartStyle {
            NORMAL,
            BOLD;

        }
    }
}

