/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.core.ui.util.SWTHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ListDisplay<T>
extends Composite
implements IUnlockable {
    private IHyperlinkListener listen;
    protected org.eclipse.swt.widgets.List list;
    private final ArrayList<T> objects;
    private LDListener dlisten;
    private final Composite cLinks;
    private final FormToolkit tk = UiDesk.getToolkit();
    Transfer myTransfer = TextTransfer.getInstance();

    public void toClipBoard(boolean bAsString) {
        Clipboard clip = new Clipboard(UiDesk.getDisplay());
        StringBuilder sb = new StringBuilder();
        String[] stringArray = this.list.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(s).append("\n");
            ++n2;
        }
        clip.setContents(new Object[]{sb.toString()}, new Transfer[]{this.myTransfer});
    }

    public void setDLDListener(LDListener dld) {
        this.dlisten = dld;
    }

    public ListDisplay(Composite parent, int flags, LDListener dld) {
        super(parent, flags);
        this.objects = new ArrayList();
        this.dlisten = dld;
        this.setLayout((Layout)new GridLayout(1, false));
        this.cLinks = new Composite((Composite)this, 0);
        RowLayout rl = new RowLayout(256);
        rl.spacing = 2;
        this.cLinks.setLayout((Layout)rl);
        this.list = new org.eclipse.swt.widgets.List((Composite)this, 516);
        this.list.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.tk.adapt((Composite)this);
    }

    public void addHyperlinks(String ... titles) {
        if (this.listen == null) {
            this.listen = new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    if (ListDisplay.this.dlisten != null) {
                        ListDisplay.this.dlisten.hyperlinkActivated(e.getLabel());
                    }
                }
            };
        }
        String[] stringArray = titles;
        int n = titles.length;
        int n2 = 0;
        while (n2 < n) {
            String title = stringArray[n2];
            Hyperlink mhl = this.tk.createHyperlink(this.cLinks, title, 0);
            mhl.addHyperlinkListener(this.listen);
            ++n2;
        }
    }

    @Override
    public void setUnlocked(boolean unlock) {
        this.enableHyperlinks(unlock);
    }

    private void enableHyperlinks(boolean bEnable) {
        this.cLinks.setEnabled(bEnable);
        Control[] controlArray = this.cLinks.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            Hyperlink hl = (Hyperlink)c;
            if (bEnable) {
                hl.setForeground(UiDesk.getColor("blau"));
            } else {
                hl.setForeground(UiDesk.getColor("grau"));
            }
            c.setEnabled(bEnable);
            ++n2;
        }
        this.cLinks.redraw();
    }

    public void add(T item) {
        this.objects.add(item);
        this.list.add(this.dlisten.getLabel(item));
    }

    public void remove(T item) {
        this.objects.remove(item);
        this.list.remove(this.dlisten.getLabel(item));
    }

    public void clear() {
        this.list.removeAll();
        this.objects.clear();
    }

    public void setMenu(final IAction ... actions) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ListDisplay.this.fillContextMenu(manager, actions);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.list);
        this.list.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager, IAction ... actions) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction ac = iActionArray[n2];
            if (ac == null) {
                manager.add((IContributionItem)new Separator());
            } else {
                if (ac instanceof RestrictedAction) {
                    ((RestrictedAction)ac).reflectRight();
                }
                manager.add(ac);
            }
            ++n2;
        }
    }

    public T getSelection() {
        String[] obj = this.list.getSelection();
        if (obj == null || obj.length == 0) {
            return null;
        }
        for (T po : this.objects) {
            if (!this.dlisten.getLabel(po).equals(obj[0])) continue;
            return po;
        }
        return null;
    }

    public void setSelection(T object) {
        if (object == null) {
            this.list.deselectAll();
        } else {
            for (T t : this.objects) {
                if (!t.equals(object)) continue;
                this.list.setSelection(new String[]{this.dlisten.getLabel(t)});
                break;
            }
        }
    }

    public void setSelection(int index) {
        this.list.setSelection(index);
    }

    public List<T> getAll() {
        return this.objects;
    }

    public void addListener(SelectionListener l) {
        this.list.addSelectionListener(l);
    }

    public void removeListener(SelectionListener l) {
        this.list.removeSelectionListener(l);
    }

    public void addListenerToSelectionList(int eventType, Listener listener) {
        this.list.addListener(eventType, listener);
    }

    public static interface LDListener {
        public void hyperlinkActivated(String var1);

        public String getLabel(Object var1);
    }
}

