/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.ui.util.Messages;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class LimitedText {
    private ControlDecoration decorator;
    private Control control;
    private Text txt;
    private int limit;

    public LimitedText(Composite parent, int style, int maxLength) {
        this(parent, style, maxLength, null);
    }

    public LimitedText(Composite parent, int style, int maxLength, Control disableControl) {
        this.control = disableControl;
        this.limit = maxLength;
        this.txt = new Text(parent, style);
        this.txt.setLayoutData((Object)new GridData(4, 128, true, true));
        this.txt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LimitedText.this.txt.getText().length() > LimitedText.this.limit) {
                    LimitedText.this.decorator.show();
                    LimitedText.this.enableControl(false);
                } else {
                    LimitedText.this.decorator.hide();
                    LimitedText.this.enableControl(true);
                }
            }
        });
        this.txt.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (LimitedText.this.txt.getText().length() > LimitedText.this.limit) {
                    e.doit = e.keyCode == 8 || e.keyCode == 127;
                }
            }
        });
        this.decorator = new ControlDecoration((Control)this.txt, 16512);
        this.decorator.setDescriptionText(Messages.LimitedText_MaxLengthReached);
        Image errorImg = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.decorator.setImage(errorImg);
    }

    private void enableControl(boolean enable) {
        if (this.control == null) {
            return;
        }
        this.control.setEnabled(enable);
    }

    public void setDisableControl(Control control) {
        this.control = control;
    }

    public void setText(String text) {
        this.txt.setText(text);
    }

    public String getText() {
        return this.txt.getText();
    }
}

