/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.ui.UiDesk;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import com.tiff.common.ui.datepicker.DatePickerCombo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TypedListener;

public class DayDateCombo
extends Composite {
    private Spinner spinner;
    private DatePickerCombo dp;
    private SpinnerListener spl;
    private DateListener dl;
    private TimeTool ttBase;
    private TimeTool ttNow;
    private boolean spinBack;
    private Label frontLabel;
    private Label middleLabel;
    private final String text1;
    private final String text2;
    private final String text1Neg;
    private final String text2Neg;

    public DayDateCombo(Composite parent, String text1, String text2) {
        this(parent, text1, text2, null, null);
    }

    public DayDateCombo(Composite parent, String text1, String text2, String text1Neg, String text2Neg) {
        super(parent, 0);
        this.text1 = text1;
        this.text2 = text2;
        this.text1Neg = text1Neg;
        this.text2Neg = text2Neg;
        this.ttNow = new TimeTool();
        this.ttNow.chop(3);
        this.setLayout((Layout)new RowLayout(256));
        this.frontLabel = UiDesk.getToolkit().createLabel((Composite)this, text1);
        this.spl = new SpinnerListener();
        this.dl = new DateListener();
        this.spinner = new Spinner((Composite)this, 0);
        this.middleLabel = UiDesk.getToolkit().createLabel((Composite)this, text2);
        this.dp = new DatePickerCombo(this, 0);
        this.setListeners();
    }

    public void spinDaysBack() {
        this.spinBack = true;
    }

    public void setEnabled(boolean bEnable) {
        this.dp.setEnabled(bEnable);
        this.spinner.setEnabled(bEnable);
    }

    public void setDates(TimeTool baseDate) {
        this.removeListeners();
        this.ttBase = baseDate == null ? new TimeTool() : new TimeTool(baseDate);
        this.ttBase.chop(3);
        this.dp.setDate(this.ttBase.getTime());
        int days = this.ttBase.daysTo(this.ttNow);
        this.updateLabels(days);
        this.spinner.setValues(Math.abs(days), 0, 999, 0, 1, 10);
        this.setListeners();
    }

    private void updateLabels(int days) {
        if (this.text1Neg != null && this.text2Neg != null) {
            if (days < 0) {
                this.frontLabel.setText(this.text1);
                this.middleLabel.setText(this.text2);
            } else {
                this.frontLabel.setText(this.text1Neg);
                this.middleLabel.setText(this.text2Neg);
            }
        }
    }

    public void setDays(int days) {
        this.removeListeners();
        this.ttBase = new TimeTool(this.ttNow);
        this.ttBase.addDays(days);
        this.dp.setDate(this.ttBase.getTime());
        int diff = this.ttBase.daysTo(this.ttNow);
        this.updateLabels(diff);
        this.spinner.setValues(Math.abs(days), 0, 999, 0, 1, 10);
        this.setListeners();
    }

    public TimeTool getDate() {
        int v = this.spinner.getSelection();
        if (v == 0) {
            return null;
        }
        if (StringTool.isNothing((Object)this.dp.getText())) {
            return null;
        }
        return new TimeTool(this.dp.getDate().getTime());
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    private void setListeners() {
        this.spinner.addModifyListener((ModifyListener)this.spl);
        this.dp.addSelectionListener((SelectionListener)this.dl);
        this.dp.addModifyListener(this.dl);
    }

    private void removeListeners() {
        this.spinner.removeModifyListener((ModifyListener)this.spl);
        this.dp.removeSelectionListener((SelectionListener)this.dl);
        this.dp.removeModifyListener(this.dl);
    }

    class DateListener
    extends SelectionAdapter
    implements ModifyListener {
        DateListener() {
        }

        public void widgetSelected(SelectionEvent se) {
            DayDateCombo.this.removeListeners();
            TimeTool nt = new TimeTool(DayDateCombo.this.dp.getDate().getTime());
            int days = DayDateCombo.this.ttNow.daysTo(nt);
            DayDateCombo.this.spinner.setValues(Math.abs(days), 0, 999, 0, 1, 10);
            Event e = new Event();
            e.time = se.time;
            DayDateCombo.this.notifyListeners(13, e);
            DayDateCombo.this.setListeners();
        }

        public void modifyText(ModifyEvent me) {
            Event e = new Event();
            e.time = me.time;
            DayDateCombo.this.notifyListeners(13, e);
        }
    }

    class SpinnerListener
    implements ModifyListener {
        SpinnerListener() {
        }

        public void modifyText(ModifyEvent me) {
            DayDateCombo.this.removeListeners();
            int d = DayDateCombo.this.spinner.getSelection();
            if (DayDateCombo.this.ttBase.isBefore(DayDateCombo.this.ttNow) || DayDateCombo.this.spinBack) {
                d *= -1;
            }
            DayDateCombo.this.ttBase = new TimeTool(DayDateCombo.this.ttNow);
            DayDateCombo.this.ttBase.addDays(d);
            DayDateCombo.this.dp.setDate(DayDateCombo.this.ttBase.getTime());
            Event e = new Event();
            e.time = me.time;
            DayDateCombo.this.notifyListeners(13, e);
            DayDateCombo.this.setListeners();
        }
    }
}

