/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.ui.dialogs.PrescriptionSignatureTitleAreaDialog;
import ch.elexis.core.ui.locks.AcquireLockUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.util.Messages;
import ch.elexis.data.ArticleDefaultSignature;
import ch.elexis.data.Artikel;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.PersistentObjectFactory;
import ch.elexis.data.Prescription;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Optional;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class CreatePrescriptionHelper {
    public static final String MEDICATION_SETTINGS_ALWAYS_SHOW_SIGNATURE_DIALOG = "medication/settings/alwaysShowSignatureDialog";
    public static final String MEDICATION_SETTINGS_SIGNATURE_STD_DISPENSATION = "medication/settings/signatureStdDispensation";
    public static final String MEDICATION_SETTINGS_DISPENSE_ARTIKELSTAMM_CONVERT = "medication/settings/artikelstammConvert";
    private Artikel article;
    private Shell parentShell;
    private boolean medicationTypeFix = false;

    public CreatePrescriptionHelper(Artikel article, Shell parentShell) {
        this.article = article;
        this.parentShell = parentShell;
    }

    public void setMedicationTypeFix(boolean value) {
        this.medicationTypeFix = value;
    }

    public void createPrescription() {
        Optional<ArticleDefaultSignature.ArticleSignature> signature;
        ArticleDefaultSignature defaultSignature = ArticleDefaultSignature.getDefaultsignatureForArticle((Artikel)this.article);
        if (defaultSignature != null) {
            signature = Optional.of(ArticleDefaultSignature.ArticleSignature.fromDefault((ArticleDefaultSignature)defaultSignature));
            if (CoreHub.userCfg.get(MEDICATION_SETTINGS_ALWAYS_SHOW_SIGNATURE_DIALOG, false)) {
                signature = this.getSignatureWithDialog(signature);
            }
        } else {
            signature = this.getSignatureWithDialog(Optional.empty());
        }
        signature.ifPresent(s -> this.createPrescriptionFromSignature((ArticleDefaultSignature.ArticleSignature)s));
    }

    private Optional<ArticleDefaultSignature.ArticleSignature> getSignatureWithDialog(Optional<ArticleDefaultSignature.ArticleSignature> preSelectedSignature) {
        PrescriptionSignatureTitleAreaDialog dialog = new PrescriptionSignatureTitleAreaDialog(this.parentShell, this.article);
        dialog.setMedicationTypeFix(this.medicationTypeFix);
        preSelectedSignature.ifPresent(s -> dialog.setSignature((ArticleDefaultSignature.ArticleSignature)s));
        if (dialog.open() != 0) {
            return Optional.empty();
        }
        return Optional.of(dialog.getSignature());
    }

    public void createPrescriptionFromSignature(final ArticleDefaultSignature.ArticleSignature signature) {
        EntryType disposalType;
        final Prescription prescription = new Prescription(this.article, (Patient)ElexisEventDispatcher.getSelected(Patient.class), signature.getSignatureAsDosisString(), signature.getComment());
        AcquireLockUi.aquireAndRun((IPersistentObject)prescription, new ILockHandler(){

            @Override
            public void lockFailed() {
                prescription.remove();
            }

            @Override
            public void lockAcquired() {
                prescription.setEntryType(signature.getMedicationType());
                if (EntryType.SYMPTOMATIC_MEDICATION.equals((Object)signature.getMedicationType()) && signature.getEndDate() != null) {
                    prescription.stop(signature.getEndDate());
                    prescription.setStopReason("Stop geplant");
                }
            }
        });
        if (signature.getDisposalType() != EntryType.RECIPE && (disposalType = signature.getDisposalType()) == EntryType.SELF_DISPENSED) {
            this.selfDispense(prescription);
        }
    }

    public void selfDispense(Prescription prescription) {
        boolean isToday;
        Konsultation kons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
        if (kons != null && (isToday = new TimeTool(kons.getDatum()).isSameDay(new TimeTool()))) {
            Result result;
            Artikel dispensationArticle = prescription.getArtikel();
            if (this.shouldUpdateToArtikelstamm() && this.isArtikelstammAvailable() && !this.isEigenartikel(dispensationArticle) && !this.isArtikelstamm(dispensationArticle)) {
                Optional<Artikel> item = this.getArtikelstammItem(dispensationArticle);
                if (item.isPresent()) {
                    prescription.set("Artikel", item.get().storeToString());
                    MessageDialog.openInformation((Shell)this.parentShell, (String)Messages.CreatePrescriptionHelper_InfoDispensationArtikelstammTitel, (String)MessageFormat.format(Messages.CreatePrescriptionHelper_InfoDispensationArtikelstammUpate, dispensationArticle.getLabel(), item.get().getLabel()));
                    dispensationArticle = item.get();
                } else {
                    MessageDialog.openError((Shell)this.parentShell, (String)Messages.CreatePrescriptionHelper_InfoDispensationArtikelstammTitel, (String)MessageFormat.format(Messages.CreatePrescriptionHelper_ErrorDispensationArtikelstammUpate, dispensationArticle.getLabel()));
                    dispensationArticle = item.get();
                }
            }
            if ((result = kons.addLeistung((IVerrechenbar)dispensationArticle)).isOK()) {
                return;
            }
        }
        MessageDialog.openWarning((Shell)this.parentShell, (String)Messages.CreatePrescriptionHelper_WarninigNoConsTitle, (String)Messages.CreatePrescriptionHelper_WarninigNoConsText);
    }

    private boolean shouldUpdateToArtikelstamm() {
        return CoreHub.userCfg.get(MEDICATION_SETTINGS_DISPENSE_ARTIKELSTAMM_CONVERT, false);
    }

    private boolean isEigenartikel(Artikel dispensationArticle) {
        return dispensationArticle.getCodeSystemName().equals("Eigenartikel");
    }

    private boolean isArtikelstamm(Artikel dispensationArticle) {
        return dispensationArticle.storeToString().startsWith("ch.artikelstamm.elexis.common.ArtikelstammItem");
    }

    private boolean isArtikelstammAvailable() {
        return PersistentObject.tableExists((String)"ARTIKELSTAMM_CH");
    }

    private Optional<Artikel> getArtikelstammItem(Artikel dispensationArticle) {
        String gtin = dispensationArticle.getGTIN();
        Optional<Artikel> ret = Optional.empty();
        if (gtin != null && !gtin.isEmpty() && (ret = this.loadArtikelWithGtin(gtin)).isPresent()) {
            return ret;
        }
        String pharma = dispensationArticle.getPharmaCode();
        if (pharma != null && !pharma.isEmpty() && (ret = this.loadArtikelWithPharma(pharma)).isPresent()) {
            return ret;
        }
        return ret;
    }

    private Optional<Artikel> loadArtikelWithPharma(String pharma) {
        Optional<Artikel> ret = Optional.empty();
        PreparedStatement pstm = PersistentObject.getDefaultConnection().getPreparedStatement("SELECT ID FROM ARTIKELSTAMM_CH WHERE PHAR=?");
        try {
            try {
                pstm.setString(1, pharma);
                ret = this.loadArtikel(pstm.executeQuery());
            }
            catch (SQLException e) {
                LoggerFactory.getLogger(CreatePrescriptionHelper.class).error("Could not lookup artikelstamm with GTIN", (Throwable)e);
                PersistentObject.getDefaultConnection().releasePreparedStatement(pstm);
            }
        }
        finally {
            PersistentObject.getDefaultConnection().releasePreparedStatement(pstm);
        }
        return ret;
    }

    private Optional<Artikel> loadArtikelWithGtin(String gtin) {
        Optional<Artikel> ret = Optional.empty();
        PreparedStatement pstm = PersistentObject.getDefaultConnection().getPreparedStatement("SELECT ID FROM ARTIKELSTAMM_CH WHERE GTIN=?");
        try {
            try {
                pstm.setString(1, gtin);
                ret = this.loadArtikel(pstm.executeQuery());
            }
            catch (SQLException e) {
                LoggerFactory.getLogger(CreatePrescriptionHelper.class).error("Could not lookup artikelstamm with GTIN", (Throwable)e);
                PersistentObject.getDefaultConnection().releasePreparedStatement(pstm);
            }
        }
        finally {
            PersistentObject.getDefaultConnection().releasePreparedStatement(pstm);
        }
        return ret;
    }

    private Optional<Artikel> loadArtikel(ResultSet result) throws SQLException {
        Optional<Artikel> ret = Optional.empty();
        while (result.next()) {
            ret = this.loadArtikelstamm(result.getString(1));
            if (ret.isPresent()) break;
        }
        result.close();
        return ret;
    }

    private Optional<Artikel> loadArtikelstamm(String id) {
        PersistentObjectFactory factory = new PersistentObjectFactory();
        PersistentObject item = factory.createFromString("ch.artikelstamm.elexis.common.ArtikelstammItem::" + id);
        if (item != null && item.exists()) {
            return Optional.of((Artikel)item);
        }
        return Optional.empty();
    }
}

