/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.propertypage;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.data.Patient;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.statushandlers.StatusManager;

public class PatientPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage,
IUnlockable {
    public static final String ID = "at.medevit.elexis.properties.propertyPage.PatientPropertyPage";
    private static final String SEX_MALE = "m\u00e4nnlich";
    private static final String SEX_FEMALE = "weiblich";
    private Patient pat;
    private Text textVorname;
    private Text textNachname;
    private Text textTelefon1;
    private Text textTelefon2;
    private Text textHandy;
    private Text textFax;
    private Text textEmail;
    private Text textBemerkungen;
    private CDateTime geburtsdatum;
    private Combo comboGeschlecht;

    protected Control createContents(Composite parent) {
        this.init();
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label lblNachname = new Label(comp, 0);
        lblNachname.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNachname.setText("Nachname");
        this.textVorname = new Text(comp, 2048);
        this.textVorname.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblVorname = new Label(comp, 0);
        lblVorname.setLayoutData((Object)new GridData(131072, 1024, false, false, 1, 1));
        lblVorname.setText("Vorname");
        this.textNachname = new Text(comp, 2048);
        this.textNachname.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblGeschlecht = new Label(comp, 0);
        lblGeschlecht.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblGeschlecht.setText("Geschlecht");
        this.comboGeschlecht = new Combo(comp, 0);
        this.comboGeschlecht.setItems(new String[]{SEX_MALE, SEX_FEMALE});
        this.comboGeschlecht.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblGeburtsdatum = new Label(comp, 0);
        lblGeburtsdatum.setText("Geburtsdatum");
        this.geburtsdatum = new CDateTime(comp, 2098179);
        this.geburtsdatum.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        new Label(comp, 0);
        new Label(comp, 0);
        Label lblTelefon1 = new Label(comp, 0);
        lblTelefon1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTelefon1.setText("Telefon");
        this.textTelefon1 = new Text(comp, 2048);
        this.textTelefon1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblTelefon2 = new Label(comp, 0);
        lblTelefon2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTelefon2.setText("Telefon");
        this.textTelefon2 = new Text(comp, 2048);
        this.textTelefon2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblHandy = new Label(comp, 0);
        lblHandy.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblHandy.setText("Handy");
        this.textHandy = new Text(comp, 2048);
        this.textHandy.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblFax = new Label(comp, 0);
        lblFax.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFax.setText("Fax");
        this.textFax = new Text(comp, 2048);
        this.textFax.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(comp, 0);
        new Label(comp, 0);
        Label lblEmail = new Label(comp, 0);
        lblEmail.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblEmail.setText("E-Mail");
        this.textEmail = new Text(comp, 2048);
        this.textEmail.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(comp, 0);
        new Label(comp, 0);
        Label lblBemerkungen = new Label(comp, 0);
        lblBemerkungen.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        lblBemerkungen.setText("Bemerkungen");
        this.textBemerkungen = new Text(comp, 2050);
        this.textBemerkungen.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        super.setTitle(this.pat.getLabel());
        this.textVorname.setText(this.pat.getName());
        this.textNachname.setText(this.pat.getVorname());
        this.geburtsdatum.setSelection(this.getGeburtsdatum());
        if (this.pat.getGeschlecht().trim().equalsIgnoreCase("m")) {
            this.comboGeschlecht.setText(SEX_MALE);
        } else {
            this.comboGeschlecht.setText(SEX_FEMALE);
        }
        this.textTelefon1.setText(this.pat.get("Telefon1"));
        this.textTelefon2.setText(this.pat.get("Telefon2"));
        this.textFax.setText(this.pat.get("Fax"));
        this.textHandy.setText(this.pat.get("NatelNr"));
        this.textEmail.setText(this.pat.get("E-Mail"));
        this.textBemerkungen.setText(this.pat.getBemerkung());
        this.setUnlocked(CoreHub.getLocalLockService().isLocked((IPersistentObject)this.pat));
        return comp;
    }

    private void init() {
        IAdaptable adapt = this.getElement();
        this.pat = (Patient)adapt.getAdapter(Patient.class);
    }

    private Date getGeburtsdatum() {
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        try {
            return df.parse(this.pat.getGeburtsdatum());
        }
        catch (ParseException e) {
            Status status = new Status(2, "at.medevit.elexis.properties", e.getLocalizedMessage());
            StatusManager.getManager().handle((IStatus)status, 1);
            return null;
        }
    }

    protected void performApply() {
        Date bd = this.geburtsdatum.getSelection();
        Calendar cal = Calendar.getInstance();
        cal.setTime(bd);
        int geschlechtSelection = this.comboGeschlecht.getSelectionIndex();
        if (geschlechtSelection != -1) {
            String geschlecht = this.comboGeschlecht.getItems()[geschlechtSelection].trim().equalsIgnoreCase(SEX_MALE) ? "m" : "w";
            this.pat.set("Geschlecht", geschlecht);
        }
        String bdS = String.valueOf(cal.get(5)) + "." + (cal.get(2) + 1) + "." + cal.get(1);
        String[] fields = new String[]{"Vorname", "Name", "Geburtsdatum", "E-Mail", "Telefon1", "Telefon2", "NatelNr", "Bemerkung", "Fax"};
        String[] values = new String[]{this.textNachname.getText(), this.textVorname.getText(), bdS, this.textEmail.getText(), this.textTelefon1.getText(), this.textTelefon2.getText(), this.textHandy.getText(), this.textBemerkungen.getText(), this.textFax.getText()};
        this.pat.set(fields, values);
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    @Override
    public void setUnlocked(boolean unlocked) {
        this.textVorname.setEditable(unlocked);
        this.textNachname.setEditable(unlocked);
        this.textTelefon1.setEditable(unlocked);
        this.textTelefon2.setEditable(unlocked);
        this.textHandy.setEditable(unlocked);
        this.textFax.setEditable(unlocked);
        this.textEmail.setEditable(unlocked);
        this.textBemerkungen.setEditable(unlocked);
        this.geburtsdatum.setEditable(unlocked);
        this.comboGeschlecht.setEnabled(unlocked);
    }
}

