/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.propertypage;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.core.ui.propertypage.CountryComboLabelProvider;
import ch.elexis.data.Patient;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class PatientAddressPage
extends PropertyPage
implements IWorkbenchPropertyPage,
IUnlockable {
    private Patient pat;
    private Text textStrasse;
    private Text textPostleitzahl;
    private Text textOrtschaft;
    private TableCombo tableCombo;

    protected Control createContents(Composite parent) {
        this.init();
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label lblNewLabel = new Label(comp, 0);
        lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel.setText("Strasse");
        this.textStrasse = new Text(comp, 2048);
        this.textStrasse.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textStrasse.setTextLimit(80);
        Label lblPostleitzahl = new Label(comp, 0);
        lblPostleitzahl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPostleitzahl.setText("Postleitzahl");
        this.textPostleitzahl = new Text(comp, 2048);
        this.textPostleitzahl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textPostleitzahl.setTextLimit(6);
        Label lblOrtschaft = new Label(comp, 0);
        lblOrtschaft.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblOrtschaft.setText("Ortschaft");
        this.textOrtschaft = new Text(comp, 2048);
        this.textOrtschaft.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textOrtschaft.setTextLimit(50);
        Label lblLand = new Label(comp, 0);
        lblLand.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLand.setText("Land");
        TableComboViewer countryComboViewer = new TableComboViewer(comp);
        this.tableCombo = countryComboViewer.getTableCombo();
        this.tableCombo.setTableWidthPercentage(90);
        this.tableCombo.setShowFontWithinSelection(false);
        this.tableCombo.setShowColorWithinSelection(false);
        this.tableCombo.setShowTableLines(false);
        this.tableCombo.setShowTableHeader(false);
        this.tableCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        countryComboViewer.setLabelProvider((IBaseLabelProvider)new CountryComboLabelProvider());
        countryComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        String[] items = new String[]{"CH", "FL", "AT", "DE", "FR", "IT"};
        countryComboViewer.setInput((Object)items);
        super.setTitle(this.pat.getLabel());
        this.textStrasse.setText(this.pat.get("Strasse"));
        this.textPostleitzahl.setText(this.pat.get("Plz"));
        this.textOrtschaft.setText(this.pat.get("Ort"));
        String country = this.pat.get("Land").trim();
        int i = 0;
        while (i < items.length) {
            if (country.equalsIgnoreCase(items[i])) {
                countryComboViewer.setSelection((ISelection)new StructuredSelection((Object)items[i]), true);
            }
            ++i;
        }
        this.setUnlocked(CoreHub.getLocalLockService().isLocked((IPersistentObject)this.pat));
        return comp;
    }

    private void init() {
        IAdaptable adapt = this.getElement();
        this.pat = (Patient)adapt.getAdapter(Patient.class);
    }

    protected void performApply() {
        String[] fields = new String[]{"Strasse", "Land", "Plz", "Ort"};
        String[] values = new String[]{this.textStrasse.getText(), this.tableCombo.getText(), this.textPostleitzahl.getText(), this.textOrtschaft.getText()};
        this.pat.set(fields, values);
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    @Override
    public void setUnlocked(boolean unlocked) {
        this.textStrasse.setEditable(unlocked);
        this.textPostleitzahl.setEditable(unlocked);
        this.textOrtschaft.setEditable(unlocked);
        this.tableCombo.setEnabled(unlocked);
    }
}

