/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences.inputs;

import ch.rgw.tools.StringTool;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class ComboFieldEditor
extends FieldEditor {
    Combo combo;
    String[] values;

    public Combo getCombo() {
        return this.combo;
    }

    public ComboFieldEditor(String preferenceName, String title, String[] values, Composite parent) {
        this.init(preferenceName, title);
        this.values = values;
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData fd = (GridData)this.combo.getLayoutData();
        fd.horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        if (this.combo == null) {
            this.combo = new Combo(parent, 0);
            this.combo.setLayoutData((Object)new GridData(768));
            this.combo.setItems(this.values);
        }
    }

    protected void doLoad() {
        if (this.combo != null) {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this.combo.setText(value);
        }
    }

    protected void doLoadDefault() {
        if (this.combo != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            int idx = StringTool.getIndex((String[])this.values, (String)value);
            this.combo.select(idx);
        }
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.combo.getText());
    }

    public int getNumberOfControls() {
        return 2;
    }
}

