/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.ui.preferences.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Organisation;
import ch.elexis.data.Person;
import ch.elexis.data.Xid;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class XIDEdit
extends PreferencePage
implements IWorkbenchPreferencePage {
    Table table;

    protected Control createContents(Composite parent) {
        this.table = new Table(parent, 65536);
        this.table.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        TableColumn tc0 = new TableColumn(this.table, 0);
        tc0.setText(Messages.XIDEdit_ShortName);
        tc0.setWidth(150);
        TableColumn tc1 = new TableColumn(this.table, 0);
        tc1.setText(Messages.XIDEdit_DomainName);
        tc1.setWidth(300);
        TableColumn tc2 = new TableColumn(this.table, 0);
        tc2.setText(Messages.XIDEdit_Display);
        tc2.setWidth(50);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        for (String dom : Xid.getXIDDomains()) {
            TableItem it = new TableItem(this.table, 0);
            Xid.XIDDomain xd = Xid.getDomain((String)dom);
            it.setText(0, Xid.getSimpleNameForXIDDomain((String)dom));
            it.setText(1, dom);
            StringBuilder sb = new StringBuilder();
            if (xd.isDisplayedFor(Person.class)) {
                sb.append("P");
            }
            if (xd.isDisplayedFor(Organisation.class)) {
                sb.append("O");
            }
            it.setText(2, sb.toString());
        }
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] sel = XIDEdit.this.table.getSelection();
                if (sel != null && sel.length > 0) {
                    new XidEditDialog(XIDEdit.this.getShell(), sel[0].getText(1)).open();
                    TableItem[] tableItemArray = XIDEdit.this.table.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem it = tableItemArray[n2];
                        Xid.XIDDomain xd = Xid.getDomain((String)it.getText(1));
                        StringBuilder sb = new StringBuilder();
                        if (xd.isDisplayedFor(Person.class)) {
                            sb.append("P");
                        }
                        if (xd.isDisplayedFor(Organisation.class)) {
                            sb.append("O");
                        }
                        it.setText(2, sb.toString());
                        ++n2;
                    }
                    XIDEdit.this.table.redraw();
                }
            }
        });
        return this.table;
    }

    public void init(IWorkbench workbench) {
    }

    static class XidEditDialog
    extends Dialog {
        Text tShort;
        Button bPerson;
        Button bOrg;
        Xid.XIDDomain mine;

        public XidEditDialog(Shell shell, String myDomain) {
            super(shell);
            this.mine = Xid.getDomain((String)myDomain);
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.XIDEdit_XidOpetions);
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = (Composite)super.createDialogArea(parent);
            ret.setLayout((Layout)new RowLayout(512));
            new Label(ret, 0).setText(this.mine.getDomainName());
            this.tShort = new Text(ret, 2048);
            this.tShort.setText(this.mine.getSimpleName());
            new Label(ret, 258);
            new Label(ret, 0).setText(Messages.XIDEdit_ShowWith);
            this.bPerson = new Button(ret, 32);
            this.bOrg = new Button(ret, 32);
            this.bPerson.setText(Messages.XIDEdit_Persons);
            this.bOrg.setText(Messages.XIDEdit_Organizations);
            if (this.mine.isDisplayedFor(Person.class)) {
                this.bPerson.setSelection(true);
            }
            if (this.mine.isDisplayedFor(Organisation.class)) {
                this.bOrg.setSelection(true);
            }
            return ret;
        }

        protected void okPressed() {
            if (this.bPerson.getSelection()) {
                this.mine.addDisplayOption(Person.class);
            }
            if (this.bOrg.getSelection()) {
                this.mine.addDisplayOption(Organisation.class);
            }
            this.mine.setSimpleName(this.tShort.getText());
            super.okPressed();
        }
    }
}

