/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.ui.preferences.Messages;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class UserTextPref
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "ch.elexis.preferences.UserPreferences";
    private static final String[] fields = new String[]{"enhancedtextfield/macro_key"};
    private static final String[] texte = new String[]{Messages.UserTextPref_MacroKey};
    private HashMap<String, String> makros = new HashMap();

    public UserTextPref() {
        super(1);
        this.setPreferenceStore(new SettingsPreferenceStore(CoreHub.userCfg));
        this.setDescription(Messages.UserTextPref_UserPreferences);
    }

    protected void createFieldEditors() {
        int i = 0;
        while (i < fields.length) {
            this.addField((FieldEditor)new StringFieldEditor(fields[i], texte[i], this.getFieldEditorParent()));
            ++i;
        }
        Set<String> makroNames = this.makros.keySet();
        for (String name : makroNames) {
            this.addField((FieldEditor)new BooleanFieldEditor("enhancedtextfield/macro_enabled/" + this.makros.get(name), name, this.getFieldEditorParent()));
        }
    }

    public void init(IWorkbench workbench) {
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            String value = CoreHub.userCfg.get(field, "$");
            this.getPreferenceStore().setValue(field, value);
            ++n2;
        }
        UserTextPref.setMakroEnabledDefaults();
        List makroExtensions = Extensions.getExtensions((String)"ch.elexis.core.ui.KonsExtension");
        for (IConfigurationElement iConfigurationElement : makroExtensions) {
            String name = iConfigurationElement.getAttribute("name");
            String clazz = iConfigurationElement.getAttribute("KonsMakro");
            if (clazz == null || clazz.isEmpty() || name.equals("enabled")) continue;
            this.makros.put(name, clazz);
        }
    }

    public static void setMakroEnabledDefaults() {
        List makroExtensions = Extensions.getExtensions((String)"ch.elexis.core.ui.KonsExtension");
        for (IConfigurationElement iConfigurationElement : makroExtensions) {
            String name = iConfigurationElement.getAttribute("name");
            String clazz = iConfigurationElement.getAttribute("KonsMakro");
            if (clazz != null && !clazz.isEmpty() && !name.equals("enabled")) {
                boolean enabled = CoreHub.userCfg.get("enhancedtextfield/macro_enabled/" + clazz, false);
                if (enabled) continue;
                CoreHub.userCfg.set("enhancedtextfield/macro_enabled/" + clazz, false);
                continue;
            }
            if (clazz == null || clazz.isEmpty() || !name.equals("enabled")) continue;
            CoreHub.userCfg.set("enhancedtextfield/macro_enabled/" + clazz, true);
        }
    }

    protected void performDefaults() {
        this.initialize();
    }
}

