/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.BriefExternUtil;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.services.ILocalDocumentService;
import ch.elexis.core.ui.preferences.Messages;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.services.LocalDocumentServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Brief;
import ch.elexis.data.Query;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.LoggerFactory;

public class Texterstellung
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Text externPath;
    private ControlDecoration externPathDeco;
    private Button allExtern;

    public Texterstellung() {
        super(1);
        this.setPreferenceStore(new SettingsPreferenceStore(CoreHub.localCfg));
        this.setDescription(Messages.Texterstellung_TextProcessor);
    }

    protected void createFieldEditors() {
        List list = Extensions.getExtensions((String)"ch.elexis.core.ui.Text");
        this.addField((FieldEditor)new BooleanFieldEditor("briefe/Textmodul_Support_Legacy", Messages.Texterstellung_Support_Legacy, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("briefe/rename_with_f2", Messages.Texterstellung_Rename_with_F2, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("briefe/Textmodul_Edit_Local", Messages.Texterstellung_texteditlocaldesc, this.getFieldEditorParent()));
        if (LocalDocumentServiceHolder.getService().isPresent()) {
            ILocalDocumentService documentService = LocalDocumentServiceHolder.getService().get();
            Composite compBackupDir = new Composite(this.getFieldEditorParent(), 0);
            compBackupDir.setLayout((Layout)new GridLayout(1, false));
            compBackupDir.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            new Label(compBackupDir, 0).setText(Messages.Texterstellung_backupdir);
            Text backupDir = new Text(compBackupDir, 2048);
            backupDir.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            backupDir.setText(String.valueOf(documentService.getDocumentCachePath()) + File.separator + "backup");
            backupDir.setEditable(false);
        }
        String[][] rows = new String[list.size()][];
        int i = 0;
        for (IConfigurationElement ice : list) {
            rows[i] = new String[2];
            rows[i][1] = ice.getAttribute("name");
            rows[i][0] = String.valueOf(Integer.toString(i)) + " : " + rows[i][1];
            ++i;
        }
        this.addField((FieldEditor)new RadioGroupFieldEditor("briefe/Textmodul", Messages.Texterstellung_ExternalProgram, 2, rows, this.getFieldEditorParent()));
        Composite compExtern = new Composite(this.getFieldEditorParent(), 0);
        compExtern.setLayout((Layout)new GridLayout(2, false));
        compExtern.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        final Button check = new Button(compExtern, 32);
        check.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        check.setText("Brief extern speichern (gleicher UNC Pfad auf allen Stationen)");
        check.setSelection(CoreHub.globalCfg.get("briefe/Textmodul_Extern_File", false));
        check.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreHub.globalCfg.set("briefe/Textmodul_Extern_File", check.getSelection());
                Texterstellung.this.externPath.setEnabled(check.getSelection());
                Texterstellung.this.allExtern.setEnabled(check.getSelection());
                Texterstellung.this.externPathDeco.hide();
            }
        });
        this.externPath = new Text(compExtern, 2048);
        this.externPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.externPath.setText(CoreHub.globalCfg.get("briefe/Textmodul_Extern_File_Path", ""));
        this.externPath.setEnabled(check.getSelection());
        this.externPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Texterstellung.this.updateExternPathDeco(Texterstellung.this.externPath.getText());
            }
        });
        this.externPathDeco = new ControlDecoration((Control)this.externPath, 16512);
        this.allExtern = new Button(compExtern, 8);
        this.allExtern.setText("Alle Brief extern speichern");
        this.allExtern.setEnabled(check.getSelection());
        this.allExtern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                if (MessageDialog.openQuestion((Shell)Texterstellung.this.getShell(), (String)"Extern speichern", (String)"Wollen sie wirklich alle Briefe extern speichern, und aus der Datenbank entfernen?")) {
                    ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(Texterstellung.this.getShell());
                    try {
                        progressDialog.run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                Query query = new Query(Brief.class);
                                List allBrief = query.execute();
                                monitor.beginTask("Alle Briefe extern speichern", allBrief.size());
                                for (Brief brief : allBrief) {
                                    BriefExternUtil.exportToExtern((Brief)brief);
                                    monitor.worked(1);
                                }
                            }
                        });
                    }
                    catch (InterruptedException | InvocationTargetException e) {
                        MessageDialog.openError((Shell)Texterstellung.this.getShell(), (String)"Extern speichern", (String)"Fehler beim Briefe extern speichern.");
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error creating saving Brief extern", (Throwable)e);
                    }
                }
            }
        });
        if (check.getSelection()) {
            this.updateExternPathDeco(this.externPath.getText());
        }
    }

    private void updateExternPathDeco(String path) {
        if (BriefExternUtil.isValidExternPath((String)(path = BriefExternUtil.getAsExternFilePath((String)path)), (boolean)false)) {
            this.externPathDeco.hide();
            this.allExtern.setEnabled(true);
        } else {
            this.externPathDeco.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
            this.externPathDeco.setDescriptionText(this.getPathDiagnoseString(path));
            this.externPathDeco.show();
            this.allExtern.setEnabled(false);
        }
    }

    private String getPathDiagnoseString(String path) {
        if (path == null) {
            return "Kein Pfad gesetzt.";
        }
        File dir = new File(path);
        if (!dir.exists()) {
            return "Pfad existiert nicht, bzw. ist nicht erreichbar.";
        }
        if (!dir.isDirectory()) {
            return "Pfad ist keine Verzeichnis.";
        }
        if (!dir.canWrite()) {
            return "Keine Schreibberechtigung auf Verzeichnis";
        }
        return "?";
    }

    public boolean performOk() {
        if (this.externPath != null && !this.externPath.isDisposed() && BriefExternUtil.isValidExternPath((String)BriefExternUtil.getAsExternFilePath((String)this.externPath.getText()), (boolean)false)) {
            CoreHub.globalCfg.set("briefe/Textmodul_Extern_File_Path", this.externPath.getText());
            CoreHub.globalCfg.flush();
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }
}

