/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.actions.ScannerEvents;
import ch.elexis.core.ui.preferences.Messages;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ScannerPref
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "ch.elexis.preferences.ScannerPrefs";
    TextScannerListener txtScannerListener;
    Button backupDefaultButton;
    SettingsPreferenceStore prefs = new SettingsPreferenceStore(CoreHub.globalCfg);

    public ScannerPref() {
        super(1);
        this.prefs.setDefault("scanner/prefixcode", 0);
        this.prefs.setDefault("scanner/postfixcode", 123456789);
        this.prefs.setDefault("scanner/barcodelength", 13);
        this.setPreferenceStore(this.prefs);
        this.setDescription(Messages.ScannerPref_SettingsForScanner);
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new IntegerFieldEditor("scanner/prefixcode", Messages.ScannerPref_ScannerPrefix, this.getFieldEditorParent(), 10));
        this.addField((FieldEditor)new IntegerFieldEditor("scanner/postfixcode", Messages.ScannerPref_ScannerPostfix, this.getFieldEditorParent(), 10));
        this.addField((FieldEditor)new IntegerFieldEditor("scanner/barcodelength", Messages.ScannerPref_Barcodelength, this.getFieldEditorParent(), 50));
    }

    protected Control createContents(Composite parent) {
        super.createContents(parent);
        GridLayout noMarginLayout = new GridLayout(3, false);
        noMarginLayout.marginLeft = 0;
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)noMarginLayout);
        comp.setLayoutData((Object)new GridData(1808));
        Label lblTest = new Label(comp, 0);
        lblTest.setText(Messages.ScannerPref_test);
        lblTest.setLayoutData((Object)new GridData(2));
        final Text txtTest = new Text(comp, 2122);
        txtTest.setLayoutData((Object)new GridData(1808));
        this.txtScannerListener = new TextScannerListener(txtTest);
        this.getShell().getDisplay().addFilter(1, (Listener)this.txtScannerListener);
        this.backupDefaultButton = this.getShell().getDefaultButton();
        final Button hiddenBtn = new Button(parent, 8);
        hiddenBtn.setVisible(false);
        txtTest.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ScannerPref.this.getShell().setDefaultButton(hiddenBtn);
            }

            public void focusLost(FocusEvent e) {
                ScannerPref.this.getShell().setDefaultButton(ScannerPref.this.backupDefaultButton);
            }
        });
        Button btnClear = new Button(comp, 8);
        btnClear.setText(Messages.ScannerPref_clear);
        btnClear.setLayoutData((Object)new GridData(2));
        btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                txtTest.setText("");
                txtTest.setFocus();
            }
        });
        Button btnSteuerblatt = new Button(parent, 8);
        btnSteuerblatt.setText(Messages.ScannerPref_printSheet);
        btnSteuerblatt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageDialog.openInformation((Shell)ScannerPref.this.getShell(), (String)Messages.ScannerPref_printSettingsSheet, (String)Messages.ScannerPref_NotImplemented);
            }
        });
        return parent;
    }

    public boolean performOk() {
        this.prefs.flush();
        boolean ok = super.performOk();
        ScannerEvents.getInstance().reloadCodes();
        return ok;
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        if (this.txtScannerListener != null) {
            this.getShell().getDisplay().removeFilter(1, (Listener)this.txtScannerListener);
        }
        super.dispose();
    }

    private static class TextScannerListener
    implements Listener {
        final Text textfield;

        public TextScannerListener(Text textfield) {
            this.textfield = textfield;
        }

        public void handleEvent(Event event) {
            if (this.textfield.isFocusControl()) {
                String str = this.textfield.getText();
                if (str != null && str.length() > 0) {
                    str = String.valueOf(str) + "; ";
                }
                if (event.character > '\u001f') {
                    str = String.valueOf(str) + event.character;
                }
                str = String.valueOf(str) + "(" + event.keyCode + ")";
                this.textfield.setText(str);
            }
        }
    }
}

