/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.optifier;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.ui.dialogs.SelectFallNoObligationDialog;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.rgw.tools.Result;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;

public class NoObligationOptifier
extends IVerrechenbar.DefaultOptifier {
    private Fall noOblFall;

    public Result<IVerrechenbar> add(final IVerrechenbar code, final Konsultation kons) {
        String gesetz = kons.getFall().getConfiguredBillingSystemLaw().name();
        boolean forceObligation = CoreHub.userCfg.get("billing/obligation", false);
        if (forceObligation && gesetz.equalsIgnoreCase("KVG")) {
            this.noOblFall = null;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    SelectFallNoObligationDialog dlg = new SelectFallNoObligationDialog(kons.getFall(), code);
                    if (dlg.open() == 0) {
                        NoObligationOptifier.this.noOblFall = dlg.getFall();
                    }
                }
            });
            if (this.noOblFall != null) {
                Konsultation noOblKons = this.getKonsFromFallByDate(this.noOblFall, kons.getDatum());
                if (noOblKons == null) {
                    noOblKons = this.noOblFall.neueKonsultation();
                    ArrayList diagnoses = kons.getDiagnosen();
                    for (IDiagnose diag : diagnoses) {
                        noOblKons.addDiagnose(diag);
                    }
                }
                noOblKons.addLeistung(code);
                return new Result((Object)code);
            }
            return new Result(Result.SEVERITY.WARNING, 0, "Auf diesen Fall k\u00f6nnen nur Pflichtleistungen verrechnet werden. Bitte einen separaten Fall f\u00fcr Nichtpflichtleistungen anlegen.", null, false);
        }
        return super.add(code, kons);
    }

    private Konsultation getKonsFromFallByDate(Fall fall, String date) {
        Konsultation[] konsen = fall.getBehandlungen(false);
        int i = 0;
        while (i < konsen.length) {
            Konsultation kons = konsen[i];
            if (kons.getDatum().equals(date)) {
                return kons;
            }
            ++i;
        }
        return null;
    }
}

