/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.locks;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.locks.LockResponseHelper;
import ch.elexis.data.PersistentObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.slf4j.LoggerFactory;

public abstract class MultiLockRequestingAction<T extends List<? extends PersistentObject>>
extends Action {
    private List<? extends PersistentObject> objects;
    private final Strategy strategy;

    public MultiLockRequestingAction(String text) {
        this(text, 0, Strategy.SEQUENTIAL);
    }

    public MultiLockRequestingAction(String text, int style, Strategy strategy) {
        super(text, style);
        this.setEnabled(true);
        this.strategy = strategy;
    }

    public void run() {
        this.objects = this.getTargetedObjects();
        if (this.objects == null || this.objects.size() == 0) {
            return;
        }
        if (Strategy.SEQUENTIAL == this.strategy) {
            this.performSequentialStrategy();
        } else if (Strategy.ALL_OR_NOTHING == this.strategy) {
            this.performAllOrNothingStrategy();
        }
    }

    private void performAllOrNothingStrategy() {
        boolean allLocksAquired = true;
        ArrayList<LockResponse> acquiredLocks = new ArrayList<LockResponse>();
        LockResponse failedLockResponse = null;
        PersistentObject failedPersistentObject = null;
        for (PersistentObject persistentObject : this.objects) {
            LockResponse lockResponse = CoreHub.getLocalLockService().acquireLock((IPersistentObject)persistentObject);
            if (lockResponse.isOk()) {
                acquiredLocks.add(lockResponse);
                continue;
            }
            allLocksAquired = false;
            failedLockResponse = lockResponse;
            failedPersistentObject = persistentObject;
            break;
        }
        if (allLocksAquired) {
            this.doRun(this.objects);
        } else {
            this.acquireLockFailed(failedLockResponse, (IPersistentObject)failedPersistentObject);
        }
        for (LockResponse lockResponse : acquiredLocks) {
            LockResponse releaseLockResponse = CoreHub.getLocalLockService().releaseLock(lockResponse.getLockInfo());
            if (releaseLockResponse.isOk()) continue;
            LockResponseHelper.showInfo(releaseLockResponse, null, LoggerFactory.getLogger(((Object)((Object)this)).getClass()));
        }
    }

    private void performSequentialStrategy() {
        for (PersistentObject persistentObject : this.objects) {
            LockResponse lr = CoreHub.getLocalLockService().acquireLock((IPersistentObject)persistentObject);
            if (lr.isOk()) {
                this.doRun(persistentObject);
                continue;
            }
            this.acquireLockFailed(lr, (IPersistentObject)persistentObject);
        }
    }

    public void acquireLockFailed(LockResponse failedLockResponse, IPersistentObject failedPersistentObject) {
        LockResponseHelper.showInfo(failedLockResponse, failedPersistentObject, null);
    }

    public abstract List<? extends PersistentObject> getTargetedObjects();

    public void doRun(PersistentObject lockedObject) {
    }

    public void doRun(List<? extends PersistentObject> lockedObjects) {
    }

    public static enum Strategy {
        SEQUENTIAL,
        ALL_OR_NOTHING;

    }
}

