/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.locks;

import ch.elexis.admin.ACE;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.locks.LockResponseHelper;
import ch.elexis.data.PersistentObject;

public abstract class LockRequestingRestrictedAction<T extends PersistentObject>
extends RestrictedAction {
    private T object;

    public LockRequestingRestrictedAction(ACE necessaryRight, String text) {
        super(necessaryRight, text);
    }

    public LockRequestingRestrictedAction(ACE necessaryRight, String text, int val) {
        super(necessaryRight, text, val);
    }

    @Override
    public void doRun() {
        if (!CoreHub.acl.request(this.necessaryRight)) {
            return;
        }
        this.object = this.getTargetedObject();
        if (this.object == null) {
            return;
        }
        LockResponse lr = CoreHub.getLocalLockService().acquireLock(this.object);
        if (lr.isOk()) {
            this.doRun(this.object);
            CoreHub.getLocalLockService().releaseLock(this.object);
        } else {
            LockResponseHelper.showInfo(lr, this.object, log);
        }
    }

    public abstract T getTargetedObject();

    public abstract void doRun(T var1);
}

