/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.locks;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.ui.locks.LockResponseHelper;
import ch.elexis.data.PersistentObject;
import org.eclipse.jface.action.Action;

public abstract class LockRequestingAction<T extends PersistentObject>
extends Action {
    private T object;

    public LockRequestingAction(String text) {
        this(text, 0);
    }

    public LockRequestingAction(String text, int style) {
        super(text, style);
        this.setEnabled(true);
    }

    public void run() {
        this.object = this.getTargetedObject();
        if (this.object == null) {
            return;
        }
        LockResponse lr = CoreHub.getLocalLockService().acquireLock(this.object);
        if (lr.isOk()) {
            this.doRun(this.object);
            CoreHub.getLocalLockService().releaseLock(this.object);
        } else {
            LockResponseHelper.showInfo(lr, this.object, null);
        }
    }

    public abstract T getTargetedObject();

    public abstract void doRun(T var1);
}

