/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.locks;

import ch.elexis.admin.ACE;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.lock.types.LockInfo;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.locks.LockResponseHelper;
import ch.elexis.data.PersistentObject;
import java.util.ArrayList;
import java.util.List;

public abstract class AllOrNoneLockRequestingRestrictedAction<T extends PersistentObject>
extends RestrictedAction {
    private List<T> objects;

    public AllOrNoneLockRequestingRestrictedAction(ACE necessaryRight, String text) {
        super(necessaryRight, text);
    }

    public AllOrNoneLockRequestingRestrictedAction(ACE necessaryRight, String text, int val) {
        super(necessaryRight, text, val);
    }

    @Override
    public void doRun() {
        if (!CoreHub.acl.request(this.necessaryRight)) {
            return;
        }
        this.objects = this.getTargetedObjects();
        if (this.objects == null || this.objects.size() == 0) {
            return;
        }
        ArrayList<LockInfo> acquiredLocks = new ArrayList<LockInfo>();
        for (PersistentObject object : this.objects) {
            LockResponse lr = CoreHub.getLocalLockService().acquireLock((IPersistentObject)object);
            if (lr.isOk()) {
                acquiredLocks.add(lr.getLockInfo());
                continue;
            }
            LockResponseHelper.showInfo(lr, (IPersistentObject)object, log);
            this.releaseAllAcquiredLocks(acquiredLocks);
            return;
        }
        this.doRun(this.objects);
        this.releaseAllAcquiredLocks(acquiredLocks);
    }

    private void releaseAllAcquiredLocks(List<LockInfo> acquiredLocks) {
        for (LockInfo lockInfo : acquiredLocks) {
            LockResponse lockResponse = CoreHub.getLocalLockService().releaseLock(lockInfo);
            if (lockResponse.isOk()) continue;
            log.warn("Could not release lock for [{}] with lock response [{}]", (Object)(String.valueOf(lockInfo.getElementType()) + "::" + lockInfo.getElementId()), (Object)lockResponse.getStatus());
        }
    }

    public abstract List<T> getTargetedObjects();

    public abstract void doRun(List<T> var1);
}

