/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange.elements;

import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.ui.exchange.XChangeExporter;
import ch.elexis.core.ui.exchange.elements.AnalysesElement;
import ch.elexis.core.ui.exchange.elements.AnamnesisElement;
import ch.elexis.core.ui.exchange.elements.DocumentElement;
import ch.elexis.core.ui.exchange.elements.DocumentsElement;
import ch.elexis.core.ui.exchange.elements.FindingElement;
import ch.elexis.core.ui.exchange.elements.MedicationElement;
import ch.elexis.core.ui.exchange.elements.MedicationsElement;
import ch.elexis.core.ui.exchange.elements.Messages;
import ch.elexis.core.ui.exchange.elements.RecordElement;
import ch.elexis.core.ui.exchange.elements.RecordsElement;
import ch.elexis.core.ui.exchange.elements.ResultElement;
import ch.elexis.core.ui.exchange.elements.RiskElement;
import ch.elexis.core.ui.exchange.elements.RisksElement;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.data.Brief;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class MedicalElement
extends XChangeElement {
    public static final String XMLNAME = "medical";
    private DocumentsElement eDocuments;
    private RisksElement eRisks;
    private AnamnesisElement elAnamnesis;
    private MedicationsElement eMedications;
    private RecordsElement eRecords;
    private AnalysesElement eAnalyses;

    @Override
    public String getXMLName() {
        return XMLNAME;
    }

    public MedicalElement asExporter(XChangeExporter parent, Patient p) {
        String r;
        String[] stringArray;
        int n;
        this.asExporter(parent);
        parent.getContainer().addMapping(this, (PersistentObject)p);
        this.add(new AnamnesisElement(parent));
        Fall[] faelle = p.getFaelle();
        Fall[] fallArray = faelle;
        int n2 = faelle.length;
        int n3 = 0;
        while (n3 < n2) {
            Konsultation[] kons;
            Fall fall = fallArray[n3];
            Konsultation[] konsultationArray = kons = fall.getBehandlungen(false);
            n = kons.length;
            int n4 = 0;
            while (n4 < n) {
                Konsultation k = konsultationArray[n4];
                RecordElement record = new RecordElement().asExporter(parent, k);
                this.getAnamnesis().link(k, record);
                this.addRecord(record);
                ++n4;
            }
            ++n3;
        }
        Query qbe = new Query(LabResult.class);
        qbe.add("PatientID", "=", p.getId());
        List labs = qbe.execute();
        if (labs != null) {
            for (LabResult lr : labs) {
                ResultElement.addResult(this, lr);
            }
        }
        Query qb = new Query(Brief.class);
        qb.add("PatientID", "=", p.getId());
        List lBriefe = qb.execute();
        if (lBriefe != null && lBriefe.size() > 0) {
            for (Brief b : lBriefe) {
                this.addDocument(new DocumentElement().asExporter(this.sender, b));
            }
        }
        ArrayList relevantMedis = new ArrayList();
        relevantMedis.addAll(p.getMedication(new EntryType[]{EntryType.FIXED_MEDICATION}));
        relevantMedis.addAll(p.getMedication(new EntryType[]{EntryType.RESERVE_MEDICATION}));
        for (Prescription medi : relevantMedis) {
            this.add(new MedicationElement().asExporter(parent, medi));
        }
        String risks = p.get("Risiken");
        if (!StringTool.isNothing((Object)risks)) {
            stringArray = risks.split("[\\n\\r]+");
            int n5 = stringArray.length;
            n = 0;
            while (n < n5) {
                r = stringArray[n];
                this.add(new RiskElement().asExporter(this.sender, r));
                ++n;
            }
        }
        if (!StringTool.isNothing((Object)(risks = p.get("Allergien")))) {
            stringArray = risks.split("[\\n\\r]+");
            int n6 = stringArray.length;
            n = 0;
            while (n < n6) {
                r = stringArray[n];
                this.add(new RiskElement().asExporter(this.sender, r, "allergy"));
                ++n;
            }
        }
        return this;
    }

    public void add(AnamnesisElement ae) {
        this.elAnamnesis = ae;
        super.add(ae);
    }

    public void add(RiskElement re) {
        if (this.eRisks == null) {
            this.eRisks = new RisksElement();
            this.add(this.eRisks);
            this.getContainer().addChoice(this.eRisks, "Risiken");
        }
        this.eRisks.add(re);
    }

    public void add(MedicationElement med) {
        if (this.eMedications == null) {
            this.eMedications = new MedicationsElement();
            this.getContainer().addChoice(this.eMedications, Messages.MedicalElement_Medcaments);
            this.add(this.eMedications);
        }
        this.eMedications.add(med);
    }

    public AnamnesisElement getAnamnesis() {
        if (this.elAnamnesis == null) {
            this.elAnamnesis = (AnamnesisElement)this.getChild("anamnesis", AnamnesisElement.class);
            if (this.elAnamnesis == null) {
                this.elAnamnesis = new AnamnesisElement(this.getSender());
                this.elAnamnesis.setReader(this.getReader());
            }
        }
        return this.elAnamnesis;
    }

    public void addRecord(RecordElement rc) {
        if (this.eRecords == null) {
            this.eRecords = (RecordsElement)this.getChild("records", RecordsElement.class);
        }
        if (this.eRecords == null) {
            this.eRecords = new RecordsElement();
            this.eRecords.setReader(this.getReader());
            this.eRecords.setWriter(this.getSender());
            this.add(this.eRecords);
            this.getContainer().addChoice(this.eRecords, Messages.MedicalElement_EMREntries, (Object)this.eRecords);
        }
        this.eRecords.add(rc);
    }

    public void addAnalyse(ResultElement le) {
        if (this.eAnalyses == null) {
            this.eAnalyses = (AnalysesElement)this.getChild("findings", AnalysesElement.class);
        }
        if (this.eAnalyses == null) {
            this.eAnalyses = new AnalysesElement();
            this.add(this.eAnalyses);
            this.getContainer().addChoice(this.eAnalyses, Messages.MedicalElement_Findings, (Object)this.eAnalyses);
        }
        this.eAnalyses.add(le);
    }

    public void addFindingItem(FindingElement fe) {
        if (this.eAnalyses == null) {
            this.eAnalyses = (AnalysesElement)this.getChild("findings", AnalysesElement.class);
        }
        if (this.eAnalyses == null) {
            this.eAnalyses = new AnalysesElement();
            this.add(this.eAnalyses);
            this.getContainer().addChoice(this.eAnalyses, Messages.MedicalElement_Findings, (Object)this.eAnalyses);
        }
        this.eAnalyses.add(fe);
    }

    public void addDocument(DocumentElement de) {
        List<? extends XChangeElement> lEx;
        if (this.eDocuments == null) {
            this.getContainer();
            this.eDocuments = (DocumentsElement)this.getChild("documents", DocumentsElement.class);
        }
        if (this.eDocuments == null) {
            this.eDocuments = new DocumentsElement();
            this.add(this.eDocuments);
            this.getContainer().addChoice(this.eDocuments, Messages.MedicalElement_Documents, (Object)this.eDocuments);
        }
        if (!(lEx = this.eDocuments.getChildren("document", DocumentElement.class)).contains(de)) {
            this.eDocuments.add(de);
        }
    }

    public List<RecordElement> getRecords() {
        if (this.eRecords == null) {
            this.eRecords = (RecordsElement)this.getChild("records", RecordsElement.class);
        }
        if (this.eRecords != null) {
            List<? extends XChangeElement> records = this.eRecords.getChildren("record", RecordElement.class);
            return records;
        }
        return null;
    }

    public List<FindingElement> getAnalyses() {
        if (this.eAnalyses == null) {
            this.eAnalyses = (AnalysesElement)this.getChild("findings", AnalysesElement.class);
        }
        if (this.eAnalyses != null) {
            List<? extends XChangeElement> analyses = this.eAnalyses.getChildren("finding", FindingElement.class);
            return analyses;
        }
        return new LinkedList<FindingElement>();
    }

    public List<DocumentElement> getDocuments() {
        if (this.eDocuments == null) {
            this.eDocuments = (DocumentsElement)this.getChild("documents", DocumentsElement.class);
        }
        if (this.eDocuments != null) {
            List<? extends XChangeElement> documents = this.eDocuments.getChildren("document", DocumentElement.class);
            return documents;
        }
        return new LinkedList<DocumentElement>();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getAnamnesis().toString());
        List<RecordElement> records = this.getRecords();
        for (RecordElement record : records) {
            ret.append("\n......\n").append(record.toString());
        }
        return ret.toString();
    }

    public PersistentObject doImport(PersistentObject context) {
        Patient pat = Patient.load((String)context.getId());
        AnamnesisElement elAnamnesis = this.getAnamnesis();
        List<RecordElement> records = this.getRecords();
        return pat;
    }
}

