/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange.elements;

import ch.elexis.core.ui.exchange.XChangeExporter;
import ch.elexis.core.ui.exchange.elements.ContactElement;
import ch.elexis.core.ui.exchange.elements.MetaElement;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.data.Brief;
import ch.elexis.data.Kontakt;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.XMLTool;
import org.jdom.Content;
import org.jdom.Element;

public class DocumentElement
extends XChangeElement {
    public static final String XMLNAME = "document";
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_ORIGIN = "origin";
    public static final String ATTR_DESTINATION = "destination";
    public static final String ATTR_MIMETYPE = "mimetype";
    public static final String ATTR_SUBJECT = "subject";
    public static final String ATTR_PLACEMENT = "placement";
    public static final String ATTR_DATE = "date";
    public static final String ATTR_RECORDREF = "recordref";
    public static final String ELEMENT_XID = "xid";
    public static final String ELEMENT_HINT = "hint";
    public static final String ELEMENT_CONTENTS = "contents";
    public static final String PLACEMENT_INLINE = "inline";
    public static final String PLACEMENT_INFILE = "infile";
    public static final String PLACEMENT_URL = "url";

    @Override
    public String getXMLName() {
        return XMLNAME;
    }

    public DocumentElement asExporter(XChangeExporter parent, Brief b) {
        this.asExporter(parent);
        this.setAttribute(ATTR_MIMETYPE, b.getMimeType());
        this.setDefaultXid(b.getId());
        this.setAttribute(ATTR_PLACEMENT, PLACEMENT_INFILE);
        parent.addBinary(this.getID(), b.loadBinary());
        this.setTitle(b.getLabel());
        this.setDestination(b.getAdressat());
        this.setOriginator(Kontakt.load((String)b.get("AbsenderID")));
        this.setDate(b.getDatum());
        String idex = b.get("BehandlungsID");
        if (idex != null) {
            this.setAttribute(ATTR_RECORDREF, XMLTool.idToXMLID((String)idex));
        }
        this.setHint("Dies ist ein Dokument im OpenDocument-Format. Sie k\u00f6nnen es zum Beispiel mit OpenOffice (http://www.openoffice.org) lesen");
        parent.getContainer().addChoice(this, b.getLabel(), (Object)b);
        return this;
    }

    public void setTitle(String title) {
        this.setAttribute(ATTR_TITLE, title);
    }

    public void setOriginator(Kontakt k) {
        if (k != null && k.isValid()) {
            ContactElement ce = this.sender.addContact(k);
            this.setAttribute(ATTR_ORIGIN, ce.getID());
        }
    }

    public void setDestination(Kontakt k) {
        if (k != null && k.isValid()) {
            ContactElement ce = this.sender.addContact(k);
            this.setAttribute(ATTR_DESTINATION, ce.getID());
        }
    }

    public void addMeta(String name, String value) {
        MetaElement meta = new MetaElement().asExporter(this.sender, name, value);
        this.add(meta);
    }

    public void setDate(String date) {
        TimeTool tt = new TimeTool(date);
        this.setAttribute(ATTR_DATE, tt.toString(6));
    }

    public void setHint(String hint) {
        Element eHint = new Element(ELEMENT_HINT, this.getContainer().getNamespace());
        eHint.setText(hint);
        this.getElement().addContent((Content)eHint);
    }

    public void setSubject(String subject) {
        this.setAttribute(ATTR_SUBJECT, subject);
    }

    public void setMimetype(String desc) {
        this.setAttribute(ATTR_MIMETYPE, desc);
    }
}

