/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange.elements;

import ch.elexis.core.ui.exchange.XChangeExporter;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.data.Anschrift;

public class AddressElement
extends XChangeElement {
    public static final String XMLNAME = "address";
    public static final String ATTR_STREET = "street";
    public static final String ATTR_ZIP = "zip";
    public static final String ATTR_CITY = "city";
    public static final String ATTR_COUNTRY = "country";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String VALUE_DEFAULT = "default";

    public AddressElement asExporter(XChangeExporter parent, Anschrift an, String bezug) {
        this.asExporter(parent);
        this.setAnschrift(an);
        this.setBezug(bezug);
        return this;
    }

    public void setAnschrift(Anschrift an) {
        this.setAttribute(ATTR_STREET, an.getStrasse());
        this.setAttribute(ATTR_ZIP, an.getPlz());
        this.setAttribute(ATTR_CITY, an.getOrt());
        this.setAttribute(ATTR_COUNTRY, an.getLand());
    }

    public void setBezug(String bezug) {
        this.setAttribute(ATTR_DESCRIPTION, bezug);
    }

    public String getBezug() {
        return this.getAttr(ATTR_DESCRIPTION);
    }

    public Anschrift getAnschrift() {
        Anschrift ret = new Anschrift();
        ret.setLand(this.getAttr(ATTR_COUNTRY));
        ret.setOrt(this.getAttr(ATTR_CITY));
        ret.setPlz(this.getAttr(ATTR_ZIP));
        ret.setStrasse(this.getAttr(ATTR_STREET));
        return ret;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getAttr(ATTR_STREET)).append(", ").append(this.getAttr(ATTR_ZIP)).append(" ").append(this.getAttr(ATTR_CITY)).append(" ").append(this.getAttr(ATTR_COUNTRY));
        return ret.toString();
    }

    @Override
    public String getXMLName() {
        return XMLNAME;
    }
}

