/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.eigenleistung;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.commands.EditEigenleistungUi;
import ch.elexis.core.ui.eigenleistung.EigenleistungDetailDisplay;
import ch.elexis.core.ui.eigenleistung.Messages;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.data.Eigenleistung;
import ch.elexis.data.PersistentObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class EigenleistungContextMenu {
    private IAction deleteAction;
    private IAction editAction;
    CommonViewer cv;
    EigenleistungDetailDisplay add;
    EigenleistungMenuListener menuListener = new EigenleistungMenuListener();
    MenuManager menu;
    ArrayList<IAction> actions = new ArrayList();

    public EigenleistungContextMenu(Eigenleistung template, CommonViewer cv) {
        this.cv = cv;
        this.makeActions(template);
        this.actions.add(this.deleteAction);
        this.actions.add(this.editAction);
        this.menu = new MenuManager();
        this.menu.addMenuListener((IMenuListener)this.menuListener);
        cv.setContextMenu(this.menu);
    }

    public void addAction(IAction ac) {
        this.actions.add(ac);
    }

    public void removeAction(IAction ac) {
        this.actions.remove(ac);
    }

    public EigenleistungContextMenu(Eigenleistung template, CommonViewer cv, EigenleistungDetailDisplay add) {
        this(template, cv);
        this.add = add;
    }

    private void makeActions(final Eigenleistung art) {
        this.deleteAction = new Action(Messages.EigenleistungContextMenu_deleteAction){
            {
                super($anonymous0);
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(String.valueOf(eigenleistung.getClass().getName()) + Messages.EigenleistungContextMenu_deleteActionToolTip);
            }

            public void run() {
                Eigenleistung act = (Eigenleistung)ElexisEventDispatcher.getSelected(art.getClass());
                if (MessageDialog.openConfirm((Shell)EigenleistungContextMenu.this.cv.getViewerWidget().getControl().getShell(), (String)Messages.EigenleistungContextMenu_deleteActionConfirmCaption, (String)MessageFormat.format(Messages.EigenleistungContextMenu_deleteConfirmBody, act.getText()))) {
                    act.delete();
                    EigenleistungContextMenu.this.cv.getConfigurer().getControlFieldProvider().fireChangedEvent();
                    EigenleistungContextMenu.this.cv.notify(CommonViewer.Message.update);
                }
            }
        };
        this.editAction = new Action(Messages.EigenleistungContextMenu_propertiesAction){
            {
                super($anonymous0);
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.EigenleistungContextMenu_propertiesTooltip);
            }

            public void run() {
                Eigenleistung lstg = (Eigenleistung)ElexisEventDispatcher.getSelected(art.getClass());
                EditEigenleistungUi.executeWithParams((PersistentObject)lstg);
            }
        };
    }

    class EigenleistungMenuListener
    implements IMenuListener {
        EigenleistungMenuListener() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            EigenleistungContextMenu.this.menu.removeAll();
            for (IAction ac : EigenleistungContextMenu.this.actions) {
                if (ac == null) {
                    EigenleistungContextMenu.this.menu.add((IContributionItem)new Separator());
                    continue;
                }
                EigenleistungContextMenu.this.menu.add(ac);
            }
        }
    }
}

