/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.editors;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.data.PersistentObject;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentObjectEditingSupport
extends EditingSupport {
    private TextCellEditor editor;
    private final String field;
    private Logger log = LoggerFactory.getLogger(PersistentObjectEditingSupport.class);

    public PersistentObjectEditingSupport(TableViewer columnViewer, String field) {
        super((ColumnViewer)columnViewer);
        this.field = field;
        this.editor = new TextCellEditor((Composite)columnViewer.getTable());
    }

    public PersistentObjectEditingSupport(TableViewer columnViewer, String field, Class<? extends Serializable> fieldTypeClazz) {
        this(columnViewer, field, fieldTypeClazz, false);
    }

    public PersistentObjectEditingSupport(TableViewer columnViewer, String field, final Class<? extends Serializable> fieldTypeClazz, boolean markValidationFailed) {
        this(columnViewer, field);
        if (fieldTypeClazz != null) {
            this.editor.setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    try {
                        String val = (String)value;
                        fieldTypeClazz.getDeclaredMethod("valueOf", String.class).invoke(null, val);
                        return null;
                    }
                    catch (ClassCastException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        return "dummy";
                    }
                }
            });
            if (markValidationFailed) {
                this.editor.addListener(new ICellEditorListener(){

                    public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                        if (newValidState) {
                            PersistentObjectEditingSupport.this.editor.getControl().setBackground(Display.getCurrent().getSystemColor(1));
                        } else {
                            PersistentObjectEditingSupport.this.editor.getControl().setBackground(Display.getCurrent().getSystemColor(3));
                        }
                    }

                    public void cancelEditor() {
                        PersistentObjectEditingSupport.this.editor.getControl().setBackground(Display.getCurrent().getSystemColor(1));
                    }

                    public void applyEditorValue() {
                        PersistentObjectEditingSupport.this.editor.getControl().setBackground(Display.getCurrent().getSystemColor(1));
                    }
                });
            }
        }
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected boolean canEdit(Object element) {
        return !Objects.isNull(element);
    }

    protected Object getValue(Object element) {
        PersistentObject po = (PersistentObject)element;
        if (po == null) {
            return "";
        }
        return po.get(this.field);
    }

    protected void setValue(Object element, Object value) {
        PersistentObject po = (PersistentObject)element;
        if (po == null) {
            return;
        }
        LockResponse lr = CoreHub.getLocalLockService().acquireLock((IPersistentObject)po);
        if (!lr.isOk()) {
            return;
        }
        po.set(this.field, (String)value);
        lr = CoreHub.getLocalLockService().releaseLock((IPersistentObject)po);
        if (!lr.isOk()) {
            this.log.warn("Error releasing lock for [{}]: {}", (Object)po.getId(), (Object)lr.getStatus());
        }
        this.getViewer().refresh(true);
    }
}

