/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.data.UiMandant;
import ch.elexis.data.Mandant;
import ch.elexis.data.Stock;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class StockSelectorDialog
extends ListDialog {
    private Stock onlyOneStock = null;

    public StockSelectorDialog(Shell parent, boolean includeCommissioningSystems) {
        super(parent);
        List allStocks = CoreHub.getStockService().getAllStocks(includeCommissioningSystems);
        if (allStocks.size() == 1) {
            this.onlyOneStock = (Stock)allStocks.get(0);
        }
        this.setInput(allStocks);
        this.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        this.setLabelProvider((ILabelProvider)new StockLabelProvider());
        this.setTitle("Bitte Lager ausw\u00e4hlen");
    }

    public int open() {
        if (this.onlyOneStock != null) {
            return 0;
        }
        return super.open();
    }

    public Object[] getResult() {
        if (this.onlyOneStock != null) {
            return new Object[]{this.onlyOneStock};
        }
        return super.getResult();
    }

    private class StockLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private StockLabelProvider() {
        }

        public String getText(Object element) {
            Stock s = (Stock)element;
            return s.getLabel();
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            Stock se = (Stock)element;
            Mandant owner = se.getOwner();
            if (owner != null) {
                return UiMandant.getColorForMandator(owner);
            }
            return null;
        }
    }
}

