/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.ui.views.controls.ArticleDefaultSignatureComposite;
import ch.elexis.data.ArticleDefaultSignature;
import ch.elexis.data.Artikel;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PrescriptionSignatureTitleAreaDialog
extends TitleAreaDialog {
    private Artikel article;
    private ArticleDefaultSignatureComposite adsc;
    private Button btnAsDefault;
    private ArticleDefaultSignature.ArticleSignature signature;
    private boolean medicationTypeFix;

    public PrescriptionSignatureTitleAreaDialog(Shell parentShell, Artikel article) {
        super(parentShell);
        this.article = article;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Verordnungs Signatur");
        this.setMessage("Die Signatur der Verordnung von " + this.article.getLabel());
        Composite area = (Composite)super.createDialogArea(parent);
        this.btnAsDefault = new Button(area, 32);
        this.btnAsDefault.setText("Als standard Signatur hinterlegen.");
        this.btnAsDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrescriptionSignatureTitleAreaDialog.this.adsc.setOnLocationEnabled(PrescriptionSignatureTitleAreaDialog.this.btnAsDefault.getSelection());
            }
        });
        GridData gd = new GridData();
        gd.horizontalIndent = 5;
        gd.verticalIndent = 5;
        this.btnAsDefault.setLayoutData((Object)gd);
        this.adsc = new ArticleDefaultSignatureComposite(area, 0);
        this.adsc.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.adsc.initDataBindings(null);
        this.adsc.setToolbarVisible(false);
        this.adsc.setOnLocationEnabled(false);
        this.adsc.setArticleToBind(this.article, false);
        if (this.signature != null) {
            this.adsc.setSignature(this.signature);
        }
        if (this.medicationTypeFix) {
            this.adsc.setMedicationTypeFix();
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.adsc.updateModelNonDatabinding();
        if (this.btnAsDefault.getSelection()) {
            this.adsc.createPersistent();
            this.adsc.safeToDefault();
        }
        super.okPressed();
    }

    public void setMedicationTypeFix(boolean value) {
        this.medicationTypeFix = value;
    }

    public void setSignature(ArticleDefaultSignature.ArticleSignature signature) {
        this.signature = signature;
    }

    public ArticleDefaultSignature.ArticleSignature getSignature() {
        return this.adsc.getSignature();
    }
}

