/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.services.ILocalDocumentService;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Brief;
import ch.elexis.data.Person;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class LocalDocumentsDialog
extends TitleAreaDialog {
    private ILocalDocumentService service;
    private TableViewer tableViewer;

    public LocalDocumentsDialog(Shell parentShell, ILocalDocumentService service) {
        super(parentShell);
        this.service = service;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.LocalDocumentsDialog_dialogtitle);
        this.setMessage(Messages.LocalDocumentsDialog_dialogmessage);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        area.setLayout((Layout)new GridLayout(1, false));
        Composite tableComposite = new Composite(area, 0);
        tableComposite.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        TableColumnLayout tcLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tcLayout);
        this.tableViewer = new TableViewer(tableComposite, 67584);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewerColumn tvc = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tcPatient = tvc.getColumn();
        tcLayout.setColumnData((Widget)tcPatient, (ColumnLayoutData)new ColumnPixelData(150, false, false));
        tcPatient.setText(Messages.LocalDocumentsDialog_patient);
        tvc.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return LocalDocumentsDialog.this.getReflectivePatientText(element);
            }
        });
        tvc = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tcDocument = tvc.getColumn();
        tcLayout.setColumnData((Widget)tcDocument, (ColumnLayoutData)new ColumnPixelData(250, true, true));
        tcDocument.setText(Messages.LocalDocumentsDialog_document);
        tvc.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IPersistentObject) {
                    return ((IPersistentObject)element).getLabel();
                }
                return element.toString();
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new EndLocalEditAction());
        menuManager.add((IAction)new AbortLocalEditAction());
        Menu menu = menuManager.createContextMenu((Control)this.tableViewer.getTable());
        this.tableViewer.getTable().setMenu(menu);
        this.tableViewer.setInput((Object)this.service.getAll());
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button abortAllBtn = new Button(parent, 8);
        abortAllBtn.setText(Messages.LocalDocumentsDialog_abortall);
        abortAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)LocalDocumentsDialog.this.getShell(), (String)Messages.LocalDocumentsDialog_aborttitle, (String)Messages.LocalDocumentsDialog_abortquestion)) {
                    LocalDocumentsDialog.this.abortLocalEdit(new StructuredSelection(LocalDocumentsDialog.this.service.getAll()));
                    LocalDocumentsDialog.this.okPressed();
                }
            }
        });
        ++((GridLayout)parent.getLayout()).numColumns;
        Button endAllBtn = new Button(parent, 8);
        endAllBtn.setText(Messages.LocalDocumentsDialog_endall);
        endAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)LocalDocumentsDialog.this.getShell(), (String)Messages.LocalDocumentsDialog_endttile, (String)Messages.LocalDocumentsDialog_endquestion)) {
                    LocalDocumentsDialog.this.endLocalEdit(new StructuredSelection(LocalDocumentsDialog.this.service.getAll()));
                    LocalDocumentsDialog.this.okPressed();
                }
            }
        });
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private String getReflectivePatientText(Object element) {
        Method getPatientMethod = this.getGetPatientMethod(element.getClass());
        if (getPatientMethod != null) {
            try {
                Person patient = (Person)getPatientMethod.invoke(element, new Object[0]);
                return patient.getLabel(true);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return "?";
    }

    private Method getGetPatientMethod(Class<? extends Object> clazz) {
        Method[] methods;
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equalsIgnoreCase("getpatient") && Person.class.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 0) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private void endLocalEdit(StructuredSelection selection) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("ch.elexis.core.ui.command.endLocalDocument");
        ((IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class)).set(command.getId().concat(".selection"), (Object)selection);
        try {
            command.executeWithChecks(new ExecutionEvent(command, Collections.EMPTY_MAP, (Object)this, null));
            this.tableViewer.setInput((Object)this.service.getAll());
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.LocalDocumentsDialog_errortitle, (String)Messages.LocalDocumentsDialog_errorendmessage);
        }
    }

    private void abortLocalEdit(StructuredSelection selection) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("ch.elexis.core.ui.command.abortLocalDocument");
        ((IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class)).set(command.getId().concat(".selection"), (Object)selection);
        try {
            command.executeWithChecks(new ExecutionEvent(command, Collections.EMPTY_MAP, (Object)this, null));
            this.tableViewer.setInput((Object)this.service.getAll());
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.LocalDocumentsDialog_errortitle, (String)Messages.LocalDocumentsDialog_errorabortmessage);
        }
    }

    public boolean close() {
        ElexisEventDispatcher.reload(Brief.class);
        return super.close();
    }

    private class AbortLocalEditAction
    extends Action {
        private AbortLocalEditAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_EDIT_ABORT.getImageDescriptor();
        }

        public String getText() {
            return Messages.LocalDocumentsDialog_actionaborttext;
        }

        public void run() {
            StructuredSelection selection = (StructuredSelection)LocalDocumentsDialog.this.tableViewer.getSelection();
            if (selection != null) {
                LocalDocumentsDialog.this.abortLocalEdit(selection);
            }
        }
    }

    private class EndLocalEditAction
    extends Action {
        private EndLocalEditAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_EDIT_DONE.getImageDescriptor();
        }

        public String getText() {
            return Messages.LocalDocumentsDialog_actionendtext;
        }

        public void run() {
            StructuredSelection selection = (StructuredSelection)LocalDocumentsDialog.this.tableViewer.getSelection();
            if (selection != null) {
                LocalDocumentsDialog.this.endLocalEdit(selection);
            }
        }
    }
}

