/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.AUF;
import ch.elexis.data.Fall;
import ch.elexis.data.Patient;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import com.tiff.common.ui.datepicker.DatePicker;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditAUFDialog
extends TitleAreaDialog {
    private AUF auf;
    private Fall fall;
    private DatePicker dpVon;
    private DatePicker dpBis;
    private Text tProzent;
    private Text tGrund;
    private Text tZusatz;
    TimeTool tt = new TimeTool();

    public EditAUFDialog(Shell shell, AUF a, Fall fall) {
        super(shell);
        this.auf = a;
        this.fall = fall;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(2, true));
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        new Label(ret, 0).setText(Messages.EditAUFDialog_from);
        new Label(ret, 0).setText(Messages.EditAUFDialog_until);
        this.dpVon = new DatePicker(ret, 0);
        this.dpBis = new DatePicker(ret, 0);
        new Label(ret, 0).setText(Messages.EditAUFDialog_percent);
        new Label(ret, 0).setText(Messages.EditAUFDialog_reason);
        this.tProzent = new Text(ret, 2048);
        this.tGrund = new Text(ret, 2048);
        this.tProzent.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tGrund.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        Label lbZusatz = new Label(ret, 0);
        lbZusatz.setText(Messages.EditAUFDialog_additional);
        lbZusatz.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        this.tZusatz = new Text(ret, 2);
        this.tZusatz.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, true));
        if (this.auf != null) {
            this.dpVon.setDate(this.auf.getBeginn().getTime());
            this.dpBis.setDate(this.auf.getEnd().getTime());
            this.tGrund.setText(this.auf.getGrund());
            this.tProzent.setText(this.auf.getProzent());
            this.tZusatz.setText(this.auf.getZusatz());
        } else {
            if (this.fall == null) {
                this.fall = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
            }
            if (this.fall != null) {
                this.tGrund.setText(this.fall.getGrund());
            } else {
                this.setMessage("Bitte w\u00e4hlen Sie zuerst einen Fall f\u00fcr diese AUF aus");
            }
            this.tProzent.setText("100");
            this.dpVon.setDate(this.tt.getTime());
            this.dpBis.setDate(this.tt.getTime());
        }
        return ret;
    }

    public void create() {
        super.create();
        Patient sp = ElexisEventDispatcher.getSelectedPatient();
        String patLabel = sp != null ? sp.getLabel() : "missing patient name";
        this.setTitle(String.valueOf(Messages.EditAUFDialog_auf) + " - " + patLabel);
        if (this.auf == null) {
            this.setMessage(Messages.EditAUFDialog_enterNewAUF);
        } else {
            this.setMessage(Messages.EditAUFDialog_editAufDetails);
        }
        this.getShell().setText(Messages.EditAUFDialog_auf);
        this.setTitleImage(Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize));
    }

    protected void okPressed() {
        TimeTool tt = new TimeTool();
        tt.setTimeInMillis(this.dpVon.getDate().getTime());
        String von = tt.toString(4);
        tt.setTimeInMillis(this.dpBis.getDate().getTime());
        String bis = tt.toString(4);
        String zus = this.tZusatz.getText();
        if (this.auf == null) {
            this.auf = new AUF(this.fall, von, bis, this.tProzent.getText(), this.tGrund.getText());
            if (!StringTool.isNothing((Object)zus)) {
                this.auf.set("Zusatz", zus);
            }
        } else {
            this.fall = this.auf.getFall();
            String[] parms = new String[]{"FallID", "Grund", "Prozent", "Zusatz"};
            String[] vals = new String[]{this.fall.getId(), this.tGrund.getText(), this.tProzent.getText(), zus};
            this.auf.set(parms, vals);
            this.auf.set("von", von);
            this.auf.set("bis", bis);
        }
        super.okPressed();
    }
}

