/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.compatibility;

import ch.elexis.core.ui.UiDesk;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;

public class ElexisFastViewUtil {
    private static final String ELEXIS_FASTVIEW_STACK = "fastview.elexis";

    public static void addToFastView(String perspectiveId, String viewId) {
        MUIElement obj;
        MApplication mApplication;
        EModelService eModelService = ElexisFastViewUtil.getService(EModelService.class);
        MTrimmedWindow window = ElexisFastViewUtil.getCurrentWindow(eModelService, mApplication = ElexisFastViewUtil.getService(MApplication.class));
        if (window != null && (obj = eModelService.find(perspectiveId, (MUIElement)mApplication)) instanceof MPerspective) {
            MPerspective mPerspective = (MPerspective)obj;
            MPartStack stack = (MPartStack)eModelService.find(ELEXIS_FASTVIEW_STACK, (MUIElement)mPerspective);
            if (stack == null) {
                stack = ElexisFastViewUtil.createFastViewStack(window, mPerspective, eModelService);
            }
            if (stack != null) {
                MToolControl toolControl = (MToolControl)eModelService.find(ElexisFastViewUtil.getToolControlId(window, mPerspective), (MUIElement)mApplication);
                if (toolControl == null) {
                    MTrimBar mTrimBar = eModelService.getTrim(window, SideValue.BOTTOM);
                    if (toolControl == null) {
                        toolControl = ElexisFastViewUtil.createFastViewToolControl(window, mPerspective, eModelService, mTrimBar);
                    }
                }
                if (toolControl != null && !ElexisFastViewUtil.isViewInsideFastview(stack, viewId) && mApplication.getContext().getActiveChild() != null) {
                    EPartService partService = ElexisFastViewUtil.getService(EPartService.class);
                    MPlaceholder placeholder = partService.createSharedPart(viewId);
                    placeholder.setToBeRendered(true);
                    placeholder.setElementId(viewId);
                    placeholder.setCloseable(true);
                    placeholder.getTags().add("removeOnHide");
                    ((MPart)placeholder.getRef()).setToBeRendered(true);
                    stack.getChildren().add(placeholder);
                }
            }
        }
    }

    private static MTrimmedWindow getCurrentWindow(EModelService eModelService, MApplication mApplication) {
        List windows;
        MTrimmedWindow window = (MTrimmedWindow)eModelService.find("IDEWindow", (MUIElement)mApplication);
        if (window == null && !(windows = mApplication.getChildren()).isEmpty() && windows.get(0) instanceof MTrimmedWindow) {
            window = (MTrimmedWindow)windows.get(0);
        }
        return window;
    }

    public static void createFastViewMenuItem(final Menu menu, MPart part) {
        EModelService eModelService = ElexisFastViewUtil.getService(EModelService.class);
        final EPartService ePartService = ElexisFastViewUtil.getService(EPartService.class);
        MPerspective mPerspective = eModelService.getPerspectiveFor((MUIElement)part);
        if (mPerspective != null) {
            MPartStack stack = (MPartStack)eModelService.find(ELEXIS_FASTVIEW_STACK, (MUIElement)mPerspective);
            MenuItem menuItemClose = new MenuItem(menu, 0);
            menuItemClose.setText("Fast View");
            menuItemClose.setEnabled(!ElexisFastViewUtil.isViewInsideFastview(stack, part.getElementId()));
            menuItemClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MPart part = (MPart)menu.getData("stack_selected_part");
                    if (ePartService.savePart(part, true)) {
                        String id = part.getElementId();
                        MPerspective mPerspective = ((EModelService)ElexisFastViewUtil.getService(EModelService.class)).getActivePerspective(((EModelService)ElexisFastViewUtil.getService(EModelService.class)).getTopLevelWindowFor((MUIElement)part));
                        ePartService.hidePart(part, true);
                        ElexisFastViewUtil.addToFastView(mPerspective.getElementId(), id);
                    }
                }
            });
        }
    }

    public static void addToFastViewAfterPerspectiveOpened(final String perspectiveId, final String ... viewIds) {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            UiDesk.asyncExec(new Runnable(){

                @Override
                public void run() {
                    String[] stringArray = viewIds;
                    int n = viewIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String viewId = stringArray[n2];
                        ElexisFastViewUtil.addToFastView(perspectiveId, viewId);
                        ++n2;
                    }
                }
            });
        }
    }

    private static MPartStack createFastViewStack(MTrimmedWindow window, MPerspective mPerspective, EModelService eModelService) {
        if (window != null && mPerspective != null) {
            MPartStack mPartStack = (MPartStack)eModelService.createModelElement(MPartStack.class);
            mPartStack.setElementId(ELEXIS_FASTVIEW_STACK);
            mPartStack.setToBeRendered(true);
            mPartStack.getTags().add("Minimized");
            mPartStack.setOnTop(false);
            mPartStack.setVisible(false);
            mPartStack.getTags().add("NoAutoCollapse");
            mPartStack.getTags().add("active");
            mPerspective.getChildren().add(0, mPartStack);
            return mPartStack;
        }
        return null;
    }

    private static MToolControl createFastViewToolControl(MTrimmedWindow window, MPerspective mPerspective, EModelService eModelService, MTrimBar mTrimBar) {
        if (mTrimBar != null) {
            MToolControl mToolControl = (MToolControl)eModelService.createModelElement(MToolControl.class);
            mToolControl.setElementId(ElexisFastViewUtil.getToolControlId(window, mPerspective));
            mToolControl.setContributionURI("bundleclass://org.eclipse.e4.ui.workbench.addons.swt/org.eclipse.e4.ui.workbench.addons.minmax.TrimStack");
            mToolControl.setToBeRendered(true);
            mToolControl.setVisible(true);
            mToolControl.getTags().add("TrimStack");
            if (!ElexisFastViewUtil.hasFastViewPersistedState(mPerspective)) {
                mToolControl.getPersistedState().put("YSize", "600");
            }
            mTrimBar.getChildren().add(0, mToolControl);
            mTrimBar.setVisible(true);
            mTrimBar.setToBeRendered(true);
            return mToolControl;
        }
        return null;
    }

    private static String getToolControlId(MTrimmedWindow window, MPerspective mPerspective) {
        return ElexisFastViewUtil.getToolControlId((MUIElement)window, mPerspective.getElementId());
    }

    private static String getToolControlId(MUIElement window, String perspectiveId) {
        return "fastview.elexis(" + perspectiveId + ")";
    }

    private static <T> T getService(Class<T> clazz) {
        return (T)PlatformUI.getWorkbench().getService(clazz);
    }

    private static boolean isViewInsideFastview(MPartStack stack, String placeholderId) {
        if (stack != null) {
            for (MStackElement stackElement : stack.getChildren()) {
                if (!stackElement.getElementId().equals(placeholderId)) continue;
                return true;
            }
        }
        return false;
    }

    public static void registerPerspectiveListener() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            workbenchWindow.addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

                public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                    super.perspectiveChanged(page, perspective, changeId);
                    if ("resetComplete".equals(changeId)) {
                        UiDesk.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MTrimmedWindow mWindow;
                                EModelService eModelService = (EModelService)ElexisFastViewUtil.getService(EModelService.class);
                                MApplication mApplication = (MApplication)ElexisFastViewUtil.getService(MApplication.class);
                                if (eModelService != null && mApplication != null && mApplication.isToBeRendered() && (mWindow = ElexisFastViewUtil.getCurrentWindow(eModelService, mApplication)) != null && mWindow.isToBeRendered()) {
                                    ElexisFastViewUtil.changeFastViewBarFromLeftToBottom();
                                    MPerspective mPerspective = eModelService.getActivePerspective((MWindow)mWindow);
                                    ElexisFastViewUtil.transferFastViewPersistedState(mPerspective, mWindow);
                                }
                            }
                        });
                    }
                }

                public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                    UiDesk.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MTrimmedWindow mWindow;
                            EModelService eModelService = (EModelService)ElexisFastViewUtil.getService(EModelService.class);
                            MApplication mApplication = (MApplication)ElexisFastViewUtil.getService(MApplication.class);
                            if (eModelService != null && mApplication != null && mApplication.isToBeRendered() && (mWindow = ElexisFastViewUtil.getCurrentWindow(eModelService, mApplication)) != null && mWindow.isToBeRendered()) {
                                ElexisFastViewUtil.changeFastViewBarFromLeftToBottom();
                                MPerspective mPerspective = eModelService.getActivePerspective((MWindow)mWindow);
                                if (ElexisFastViewUtil.hasFastViewPersistedState(mPerspective) && !ElexisFastViewUtil.hasFastViewPersistedState(mWindow, mPerspective.getElementId())) {
                                    ElexisFastViewUtil.transferFastViewPersistedState(mPerspective, mWindow);
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    private static boolean hasFastViewPersistedState(MTrimmedWindow mWindow, String perspectiveId) {
        EModelService eModelService = ElexisFastViewUtil.getService(EModelService.class);
        Optional<MToolControl> mToolControl = ElexisFastViewUtil.getFastViewToolControl(eModelService, mWindow, perspectiveId, SideValue.BOTTOM);
        if (mToolControl.isPresent()) {
            Map persistedState = mToolControl.get().getPersistedState();
            return persistedState != null && !persistedState.isEmpty();
        }
        return false;
    }

    private static boolean hasFastViewPersistedState(MPerspective mPerspective) {
        Optional<MPartStack> mStack = ElexisFastViewUtil.getFastViewPartStack(mPerspective);
        if (mStack.isPresent()) {
            Map persistedState = mStack.get().getPersistedState();
            return persistedState != null && !persistedState.isEmpty();
        }
        return false;
    }

    private static Optional<MToolControl> getFastViewToolControl(EModelService eModelService, MTrimmedWindow workbenchWindow, String perspectiveId, SideValue sideValue) {
        MTrimBar trimbar;
        if (workbenchWindow != null && (trimbar = ElexisFastViewUtil.findTrimBar(eModelService, workbenchWindow, sideValue)) != null) {
            MToolControl toolControl = (MToolControl)eModelService.find(ElexisFastViewUtil.getToolControlId((MUIElement)workbenchWindow, perspectiveId), (MUIElement)trimbar);
            if (toolControl == null && workbenchWindow.getElementId() != null && (toolControl = (MToolControl)eModelService.find("fastview.elexis(" + workbenchWindow.getElementId() + ").(" + perspectiveId + ")", (MUIElement)trimbar)) != null) {
                toolControl.setElementId(ElexisFastViewUtil.getToolControlId((MUIElement)workbenchWindow, perspectiveId));
            }
            if (toolControl != null) {
                return Optional.of(toolControl);
            }
        }
        return Optional.empty();
    }

    private static Optional<MPartStack> getFastViewPartStack(MPerspective mPerspective) {
        EModelService modelService = ElexisFastViewUtil.getService(EModelService.class);
        MPartStack stack = (MPartStack)modelService.find(ELEXIS_FASTVIEW_STACK, (MUIElement)mPerspective);
        if (stack != null) {
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    private static MTrimBar findTrimBar(EModelService eModelService, MTrimmedWindow workbenchWindow, SideValue sideValue) {
        if (workbenchWindow != null) {
            MTrimBar trimbar = eModelService.getTrim(workbenchWindow, sideValue);
            return trimbar;
        }
        return null;
    }

    public static void transferFastViewPersistedState(MTrimmedWindow fromWindow, MPerspective toPerspective) {
        EModelService modelService = ElexisFastViewUtil.getService(EModelService.class);
        MToolControl toolControl = (MToolControl)modelService.find(ElexisFastViewUtil.getToolControlId(fromWindow, toPerspective), (MUIElement)fromWindow);
        if (toolControl != null && toolControl.getPersistedState() != null) {
            Optional<MPartStack> mStack = ElexisFastViewUtil.getFastViewPartStack(toPerspective);
            mStack.ifPresent(stack -> {
                Map perspectiveState = stack.getPersistedState();
                for (String key : toolControl.getPersistedState().keySet()) {
                    perspectiveState.put(key, (String)toolControl.getPersistedState().get(key));
                }
            });
        }
    }

    public static void transferFastViewPersistedState(MPerspective fromPerspective, MTrimmedWindow toWindow) {
        EModelService modelService = ElexisFastViewUtil.getService(EModelService.class);
        String perspectiveId = fromPerspective.getElementId();
        Optional<MToolControl> mToolControl = ElexisFastViewUtil.getFastViewToolControl(modelService, toWindow, perspectiveId, SideValue.BOTTOM);
        mToolControl.ifPresent(toolControl -> {
            Optional<MPartStack> mStack = ElexisFastViewUtil.getFastViewPartStack(fromPerspective);
            mStack.ifPresent(stack -> {
                if (stack.getPersistedState() != null && !stack.getPersistedState().isEmpty()) {
                    for (String key : stack.getPersistedState().keySet()) {
                        toolControl.getPersistedState().put(key, (String)stack.getPersistedState().get(key));
                    }
                }
            });
        });
    }

    private static void changeFastViewBarFromLeftToBottom() {
        MPerspective mPerspective;
        MApplication mApplication;
        EModelService eModelService = ElexisFastViewUtil.getService(EModelService.class);
        MTrimmedWindow mWindow = ElexisFastViewUtil.getCurrentWindow(eModelService, mApplication = ElexisFastViewUtil.getService(MApplication.class));
        if (mWindow != null && (mPerspective = eModelService.getActivePerspective((MWindow)mWindow)) != null) {
            String perspectiveId = mPerspective.getElementId();
            Optional<MToolControl> mToolControl = ElexisFastViewUtil.getFastViewToolControl(eModelService, mWindow, perspectiveId, SideValue.BOTTOM);
            if (!mToolControl.isPresent()) {
                mToolControl = ElexisFastViewUtil.getFastViewToolControl(eModelService, mWindow, perspectiveId, SideValue.LEFT);
                mToolControl.ifPresent(toolControl -> {
                    MTrimBar trimBarBottom = ElexisFastViewUtil.findTrimBar(eModelService, mWindow, SideValue.BOTTOM);
                    if (trimBarBottom != null) {
                        MToolControl copyToolcontrol = (MToolControl)eModelService.createModelElement(MToolControl.class);
                        copyToolcontrol.setElementId(toolControl.getElementId());
                        copyToolcontrol.setContributionURI("bundleclass://org.eclipse.e4.ui.workbench.addons.swt/org.eclipse.e4.ui.workbench.addons.minmax.TrimStack");
                        copyToolcontrol.setToBeRendered(true);
                        copyToolcontrol.setVisible(true);
                        copyToolcontrol.getTags().add("TrimStack");
                        if (!ElexisFastViewUtil.hasFastViewPersistedState(mPerspective)) {
                            copyToolcontrol.getPersistedState().put("YSize", "600");
                        }
                        trimBarBottom.getChildren().add(0, copyToolcontrol);
                        toolControl.setToBeRendered(false);
                        toolControl.setVisible(false);
                        toolControl.getParent().getChildren().remove(toolControl);
                        toolControl.setParent(null);
                        trimBarBottom.setVisible(true);
                        trimBarBottom.setToBeRendered(true);
                    }
                });
            } else {
                mToolControl.get().setToBeRendered(true);
            }
        }
    }
}

