/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.BriefExternUtil;
import ch.elexis.core.data.util.LocalLock;
import ch.elexis.core.lock.ILocalLockService;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.services.IConflictHandler;
import ch.elexis.core.services.ILocalDocumentService;
import ch.elexis.core.ui.commands.Messages;
import ch.elexis.core.ui.locks.AcquireLockUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.services.LocalDocumentServiceHolder;
import ch.elexis.data.Brief;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class StartEditLocalDocumentHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEclipseContext iEclipseContext = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        StructuredSelection selection = (StructuredSelection)iEclipseContext.get(event.getCommand().getId().concat(".selection"));
        iEclipseContext.remove(event.getCommand().getId().concat(".selection"));
        if (selection != null && !selection.isEmpty()) {
            List selected = selection.toList();
            Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            for (final Object object : selected) {
                if (object instanceof Brief && BriefExternUtil.isExternFile()) {
                    Optional file = BriefExternUtil.getExternFile((Brief)((Brief)object));
                    if (file.isPresent()) {
                        Program.launch((String)((File)file.get()).getAbsolutePath());
                        continue;
                    }
                    MessageDialog.openError((Shell)parentShell, (String)Messages.StartEditLocalDocumentHandler_errortitle, (String)Messages.StartEditLocalDocumentHandler_errormessage);
                    continue;
                }
                LocalDocumentServiceHolder.getService().ifPresent(service -> {
                    if (CoreHub.getLocalLockService().getStatus() == ILocalLockService.Status.REMOTE) {
                        AcquireLockUi.aquireAndRun((IPersistentObject)object, new ILockHandler((ILocalDocumentService)service, parentShell){
                            private final /* synthetic */ ILocalDocumentService val$service;
                            private final /* synthetic */ Shell val$parentShell;
                            {
                                this.val$service = iLocalDocumentService;
                                this.val$parentShell = shell;
                            }

                            @Override
                            public void lockFailed() {
                            }

                            @Override
                            public void lockAcquired() {
                                StartEditLocalDocumentHandler.this.startEditLocal(object, this.val$service, this.val$parentShell);
                            }
                        });
                    } else {
                        LocalLock lock = new LocalLock(object);
                        if (!lock.tryLock()) {
                            if (service.contains(object) && lock.hasLock(CoreHub.actUser.getLabel()) || MessageDialog.openQuestion((Shell)parentShell, (String)Messages.StartEditLocalDocumentHandler_warning, (String)(String.valueOf(Messages.StartEditLocalDocumentHandler_alreadyOpenStart) + lock.getLockMessage() + Messages.StartEditLocalDocumentHandler_alreadyOpenEnd))) {
                                lock.unlock();
                                if (!lock.tryLock()) {
                                    MessageDialog.openError((Shell)parentShell, (String)Messages.StartEditLocalDocumentHandler_errortitle, (String)Messages.StartEditLocalDocumentHandler_errormessage);
                                    return;
                                }
                            } else {
                                return;
                            }
                        }
                        this.startEditLocal(object, (ILocalDocumentService)service, parentShell);
                    }
                });
            }
        }
        return null;
    }

    private void startEditLocal(Object object, ILocalDocumentService service, final Shell parentShell) {
        Optional file = service.add(object, new IConflictHandler(){

            public IConflictHandler.Result getResult() {
                if (MessageDialog.openQuestion((Shell)parentShell, (String)Messages.StartEditLocalDocumentHandler_conflicttitle, (String)Messages.StartEditLocalDocumentHandler_conflictmessage)) {
                    return IConflictHandler.Result.KEEP;
                }
                return IConflictHandler.Result.OVERWRITE;
            }
        });
        if (file.isPresent()) {
            Program.launch((String)((File)file.get()).getAbsolutePath());
        } else {
            MessageDialog.openError((Shell)parentShell, (String)Messages.StartEditLocalDocumentHandler_errortitle, (String)Messages.StartEditLocalDocumentHandler_errormessage);
        }
    }
}

