/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.BillingUtil;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.ui.commands.Handler;
import ch.elexis.core.ui.commands.TreeToStringConverter;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.Result;
import ch.rgw.tools.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterValueConversionException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;

public class ErstelleRnnCommand
extends AbstractHandler {
    public static final String ID = "bill.create";

    public Object execute(ExecutionEvent eev) throws ExecutionException {
        Tree tSelection = null;
        String px = eev.getParameter("ch.elexis.RechnungErstellen.parameter");
        try {
            tSelection = (Tree)new TreeToStringConverter().convertToObject(px);
        }
        catch (ParameterValueConversionException pe) {
            throw new ExecutionException("Bad parameter " + pe.getMessage());
        }
        IProgressMonitor monitor = Handler.getMonitor(eev);
        Result res = null;
        Tree tPat = tSelection.getFirstChild();
        while (tPat != null) {
            int rejected = 0;
            Tree tFall = tPat.getFirstChild();
            while (tFall != null) {
                Fall fall = (Fall)tFall.contents;
                if (CoreHub.userCfg.get("billing/strict", true) && !fall.isValid()) {
                    ++rejected;
                } else {
                    Collection lt = tFall.getChildren();
                    ArrayList<Konsultation> toBill = new ArrayList<Konsultation>(lt.size() + 1);
                    for (Tree t : lt) {
                        toBill.add((Konsultation)t.contents);
                    }
                    Map sortedByYears = BillingUtil.getSortedByYear(toBill);
                    if (!BillingUtil.canBillYears(new ArrayList(sortedByYears.keySet()))) {
                        StringJoiner sj = new StringJoiner(", ");
                        sortedByYears.keySet().forEach(i -> {
                            StringJoiner stringJoiner2 = sj.add(Integer.toString(i));
                        });
                        if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Rechnung Validierung", (String)("Die Leistungen sind aus Jahren die nicht kombinierbar sind.\n\nWollen Sie separate Rechnungen f\u00fcr die Jahre " + sj.toString() + " erstellen?"))) {
                            for (Integer year : sortedByYears.keySet()) {
                                res = Rechnung.build((List)((List)sortedByYears.get(year)));
                                if (monitor != null) {
                                    monitor.worked(1);
                                }
                                if (!res.isOK()) {
                                    ErrorDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)eev), (String)Messages.KonsZumVerrechnenView_errorInInvoice, (String)NLS.bind((String)Messages.KonsZumVerrechnenView_invoiceForCase, (Object[])new Object[]{fall.getLabel(), fall.getPatient().getLabel()}), (IStatus)ResultAdapter.getResultAsStatus((Result)res));
                                    continue;
                                }
                                tPat.remove(tFall);
                            }
                        }
                    } else {
                        res = Rechnung.build(toBill);
                        if (monitor != null) {
                            monitor.worked(1);
                        }
                        if (!res.isOK()) {
                            ErrorDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)eev), (String)Messages.KonsZumVerrechnenView_errorInInvoice, (String)NLS.bind((String)Messages.KonsZumVerrechnenView_invoiceForCase, (Object[])new Object[]{fall.getLabel(), fall.getPatient().getLabel()}), (IStatus)ResultAdapter.getResultAsStatus((Result)res));
                        } else {
                            tPat.remove(tFall);
                        }
                    }
                }
                tFall = tFall.getNextSibling();
            }
            if (rejected != 0) {
                SWTHelper.showError(Messages.ErstelleRnnCommand_BadCaseDefinition, String.valueOf(Integer.toString(rejected)) + Messages.ErstelleRnnCommand_BillsNotCreatedMissingData + Messages.ErstelleRnnCommand_ErstelleRnnCheckCaseDetails);
            } else {
                tSelection.remove(tPat);
            }
            tPat = tPat.getNextSibling();
        }
        return res;
    }

    public static Object ExecuteWithParams(IViewSite origin, Tree<?> tSelection) {
        IHandlerService handlerService = (IHandlerService)origin.getService(IHandlerService.class);
        ICommandService cmdService = (ICommandService)origin.getService(ICommandService.class);
        try {
            Command command = cmdService.getCommand(ID);
            Parameterization px = new Parameterization(command.getParameter("ch.elexis.RechnungErstellen.parameter"), new TreeToStringConverter().convertToString(tSelection));
            ParameterizedCommand parmCommand = new ParameterizedCommand(command, new Parameterization[]{px});
            return handlerService.executeCommand(parmCommand, null);
        }
        catch (Exception ex) {
            throw new RuntimeException("add.command not found");
        }
    }
}

