/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.actions;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.PersistentObjectLoader;
import ch.elexis.core.ui.selectors.SelectorPanel;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.SelectorPanelProvider;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;

public class ReadOnceTreeLoader
extends PersistentObjectLoader
implements ITreeContentProvider {
    protected String parentColumn;
    protected String orderBy;
    private HashMap<PersistentObject, HashMap<PersistentObject, ?>> allNodes = new HashMap();
    private PersistentObject[] root;
    TreeViewer tv;
    int size = 0;
    SelectorPanelProvider slp;
    ViewerFilter filter;
    Object[] expanded = null;

    public ReadOnceTreeLoader(CommonViewer cv, Query<? extends PersistentObject> qbe, String parentField, String orderBy) {
        super(cv, qbe);
        this.parentColumn = parentField;
        this.orderBy = orderBy;
        this.setQuery("NIL");
        this.root = qbe.execute().toArray(new PersistentObject[0]);
    }

    @Override
    public IStatus work(IProgressMonitor monitor, HashMap<String, Object> params) {
        UiDesk.asyncExec(new Runnable(){

            @Override
            public void run() {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(ReadOnceTreeLoader.this.cv.getViewerWidget().getControl().getShell());
                try {
                    dialog.run(false, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask("Durchsuche Tarmed....", -1);
                            (this).ReadOnceTreeLoader.this.tv.refresh(false);
                            if ((this).ReadOnceTreeLoader.this.slp.isEmpty()) {
                                if ((this).ReadOnceTreeLoader.this.expanded != null) {
                                    (this).ReadOnceTreeLoader.this.tv.setExpandedElements((this).ReadOnceTreeLoader.this.expanded);
                                    (this).ReadOnceTreeLoader.this.expanded = null;
                                }
                            } else {
                                if ((this).ReadOnceTreeLoader.this.expanded == null) {
                                    (this).ReadOnceTreeLoader.this.expanded = (this).ReadOnceTreeLoader.this.tv.getExpandedElements();
                                }
                                (this).ReadOnceTreeLoader.this.tv.expandAll();
                            }
                            monitor.done();
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        return Status.OK_STATUS;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        return this.root;
    }

    public Object getParent(Object element) {
        return null;
    }

    public Object[] getChildren(Object parent) {
        PersistentObject par = (PersistentObject)parent;
        HashMap<Object, Object> children = this.allNodes.get(par);
        if (children == null) {
            children = new HashMap();
            this.setQuery(par.getId());
            List ch = this.qbe.execute();
            for (PersistentObject po : ch) {
                children.put(po, new HashMap());
            }
            this.allNodes.put(par, children);
        }
        return children.keySet().toArray();
    }

    protected void setQuery(String parent) {
        this.qbe.clear();
        this.qbe.add(this.parentColumn, "=", parent);
        this.applyQueryFilters();
    }

    @Override
    public void init() {
        if (this.slp == null) {
            this.slp = (SelectorPanelProvider)this.cv.getConfigurer().getControlFieldProvider();
        }
        if (this.filter == null) {
            this.filter = new TreeFilter(this.slp.getPanel());
        }
        this.tv = (TreeViewer)this.cv.getViewerWidget();
        if (this.orderBy != null) {
            this.tv.setSorter(new ViewerSorter(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    String c1 = ((PersistentObject)e1).get(ReadOnceTreeLoader.this.orderBy);
                    String c2 = ((PersistentObject)e2).get(ReadOnceTreeLoader.this.orderBy);
                    return c1.compareTo(c2);
                }
            });
        }
        this.tv.setFilters(new ViewerFilter[]{this.filter});
    }

    public boolean hasChildren(Object element) {
        HashMap<PersistentObject, ?> children = this.allNodes.get(element);
        if (children == null) {
            return this.getChildren(element).length > 0;
        }
        return children.size() > 0;
    }

    class TreeFilter
    extends ViewerFilter {
        SelectorPanel panel;

        TreeFilter(SelectorPanel sp) {
            this.panel = sp;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            PersistentObject po = (PersistentObject)element;
            HashMap<String, String> vals = this.panel.getValues();
            if (po.isMatching(vals, 4, true)) {
                return true;
            }
            Object[] objectArray = ReadOnceTreeLoader.this.getChildren(po);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object poc = objectArray[n2];
                if (this.select(viewer, po, poc)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

