/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.actions;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.actions.BackgroundJob;
import ch.elexis.core.ui.actions.KonsFilter;
import ch.elexis.core.ui.actions.Messages;
import ch.elexis.core.ui.actions.ObjectFilterRegistry;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionedResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IFilter;

public class HistoryLoader
extends BackgroundJob {
    StringBuilder sb;
    List<Konsultation> lKons;
    KonsFilter filter;
    IFilter globalFilter;
    private final int currentPage;
    private final int pageSize;
    boolean multiline = false;

    public void setFilter(KonsFilter kf) {
        this.filter = kf;
    }

    public HistoryLoader(StringBuilder sb, List<Konsultation> lKons) {
        this(sb, lKons, false);
    }

    public HistoryLoader(StringBuilder sb, List<Konsultation> lKons, boolean multiline) {
        this(sb, lKons, multiline, 0, 0);
    }

    public HistoryLoader(StringBuilder sb, List<Konsultation> lKons, boolean multiline, int currentPage, int pageSize) {
        super(Messages.HistoryLoader_LoadKonsMessage);
        this.sb = sb;
        this.lKons = new ArrayList<Konsultation>(lKons);
        this.multiline = multiline;
        this.setPriority(50);
        this.setUser(false);
        this.currentPage = currentPage;
        this.pageSize = pageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatus execute(IProgressMonitor monitor) {
        List<Konsultation> list = this.lKons;
        synchronized (list) {
            monitor.beginTask(Messages.HistoryLoader_LoadKonsMessage, this.lKons.size() + 100);
            monitor.subTask(Messages.HistoryLoader_Sorting);
            if (this.lKons.isEmpty()) {
                return Status.OK_STATUS;
            }
            Collections.sort(this.lKons, new Comparator<Konsultation>(){
                TimeTool t1 = new TimeTool();
                TimeTool t2 = new TimeTool();

                @Override
                public int compare(Konsultation o1, Konsultation o2) {
                    if (o1 == null || o2 == null) {
                        return 0;
                    }
                    this.t1.set(o1.getDatum());
                    this.t2.set(o2.getDatum());
                    if (this.t1.isBefore(this.t2)) {
                        return 1;
                    }
                    if (this.t1.isAfter(this.t2)) {
                        return -1;
                    }
                    return Long.compare(o2.getLastUpdate(), o1.getLastUpdate());
                }
            });
            if (this.currentPage > 0 && this.pageSize > 0) {
                int fromIdx = (this.currentPage - 1) * this.pageSize;
                int toIdx = this.currentPage * this.pageSize;
                if (toIdx > this.lKons.size()) {
                    toIdx = this.lKons.size();
                    fromIdx = toIdx - this.pageSize;
                }
                if (fromIdx < 0) {
                    fromIdx = 0;
                }
                this.lKons = new ArrayList<Konsultation>(fromIdx < toIdx ? this.lKons.subList(fromIdx, toIdx) : this.lKons);
            } else {
                this.lKons = new ArrayList<Konsultation>(this.lKons);
            }
            monitor.worked(50);
            Fall selectedFall = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
            Iterator<Konsultation> it = this.lKons.iterator();
            this.sb.append("<form>");
            this.globalFilter = ObjectFilterRegistry.getInstance().getFilterFor(Konsultation.class);
            while (!monitor.isCanceled()) {
                if (!it.hasNext()) {
                    this.sb.append("</form>");
                    this.result = this.sb.toString();
                    monitor.worked(1);
                    monitor.done();
                    return Status.OK_STATUS;
                }
                Konsultation k = it.next();
                if (this.filter != null && !this.filter.pass(k) || this.globalFilter != null && !this.globalFilter.select((Object)k)) continue;
                VersionedResource vr = k.getEintrag();
                String s = vr.getHead();
                if (s != null) {
                    if (s.startsWith("<")) {
                        Samdas samdas = new Samdas(s);
                        s = samdas.getRecordText();
                    }
                    s = this.maskHTML(s);
                    if (this.multiline) {
                        s = s.replaceAll("\r\n", "<br/>");
                        s = s.replaceAll("\n", "<br/>");
                    }
                } else {
                    s = "";
                }
                String label = this.maskHTML(k.getLabel());
                if (selectedFall != null && !selectedFall.equals((Object)k.getFall())) {
                    this.sb.append("<p><a href=\"").append(this.maskHTML(k.getId())).append("\">").append(label).append("</a><br/>").append("<span color=\"gruen\">").append(this.maskHTML(k.getFall().getLabel())).append("</span><br/><span color=\"gruen\">").append(s).append("</span></p>");
                } else {
                    this.sb.append("<p><a href=\"").append(this.maskHTML(k.getId())).append("\">").append(label).append("</a><br/>").append("<span color=\"gruen\">").append(this.maskHTML(k.getFall().getLabel())).append("</span><br/>").append(s).append("</p>");
                }
                monitor.worked(1);
            }
            this.sb.setLength(0);
            monitor.done();
        }
        return Status.CANCEL_STATUS;
    }

    private String maskHTML(String input) {
        String s = input.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll("&", "&amp;");
        return s;
    }

    @Override
    public int getSize() {
        return this.lKons.size();
    }

    public List<Konsultation> getlKons() {
        return this.lKons;
    }
}

